/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf;

import com.yahoo.platform.yui.compressor.CssCompressor;
import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import com.yahoo.platform.yui.javascript.ErrorReporter;
import com.yahoo.platform.yui.javascript.EvaluatorException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.element.GenericConfigElement;
import org.springframework.extensions.surf.CssImageDataHandler;
import org.springframework.extensions.surf.CssThemeHandler;
import org.springframework.extensions.surf.DependencyHandler;
import org.springframework.extensions.surf.DependencyResource;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;
import org.springframework.extensions.webscripts.ScriptConfigModel;
import org.springframework.web.context.WebApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyAggregator
implements ApplicationContextAware {
    private static final Log logger = LogFactory.getLog(DependencyAggregator.class);
    public String charset = "UTF-8";
    public int linebreak = -1;
    public boolean munge = true;
    public boolean verbose = false;
    public boolean preserveAllSemiColons = false;
    public boolean disableOptimizations = false;
    private Boolean isDebugMode = null;
    private Boolean isCollationDebugMode = null;
    public static final String FLAGS = "flags";
    public static final String CLIENT_DEBUG = "client-debug";
    public static final String CLIENT_COLLATION_DEBUG = "client-collation-debug";
    public static final String INLINE_AGGREGATION_MARKER = ">>>";
    private CssImageDataHandler cssImageDataHandler;
    private CssThemeHandler cssThemeHandler;
    private DependencyHandler dependencyHandler;
    private List<String> compressionExclusions;
    private List<Pattern> compressionExclusionPatterns = new ArrayList<Pattern>();
    private ServletContext servletContext = null;
    private ScriptConfigModel scriptConfigModel;
    private Map<Set<String>, String> fileSetToMD5Map = new HashMap<Set<String>, String>();
    private Map<String, String> compressedJSResources = new HashMap<String, String>();
    private Map<String, String> compressedCSSResources = new HashMap<String, String>();
    private Map<String, DependencyResource> combinedDependencyMap = new HashMap<String, DependencyResource>();
    private ReentrantReadWriteLock fileSetToMD5MapLock = new ReentrantReadWriteLock();
    private ReentrantReadWriteLock compressedJSResourcesLock = new ReentrantReadWriteLock();
    private ReentrantReadWriteLock compressedCSSResourcesLock = new ReentrantReadWriteLock();
    private ReentrantReadWriteLock combinedDependencyMapLock = new ReentrantReadWriteLock();
    public static char SINGLE_QUOTE = new Character('\'').charValue();
    public static char DOUBLE_QUOTE = new Character('\"').charValue();
    public static final Pattern p = Pattern.compile("(@import[\\s\\t]*url[\\s\\t]*\\((.*?)\\))");

    public void setCssImageDataHandler(CssImageDataHandler cssImageDataHandler) {
        this.cssImageDataHandler = cssImageDataHandler;
    }

    public void setCssThemeHandler(CssThemeHandler cssThemeHandler) {
        this.cssThemeHandler = cssThemeHandler;
    }

    public DependencyHandler getDependencyHandler() {
        return this.dependencyHandler;
    }

    public void setDependencyHandler(DependencyHandler dependencyHandler) {
        this.dependencyHandler = dependencyHandler;
    }

    public void setCompressionExclusions(List<String> compressionExclusions) {
        this.compressionExclusions = compressionExclusions;
        for (String exlusion : this.compressionExclusions) {
            String regex = exlusion.replace("?", ".?").replace("*", ".*?");
            this.compressionExclusionPatterns.add(Pattern.compile(regex));
        }
    }

    public boolean isDebugMode() {
        if (this.isDebugMode == null) {
            this.isDebugMode = this.getDebugFlag(CLIENT_DEBUG, Boolean.FALSE);
        }
        return this.isDebugMode;
    }

    public boolean isCollationDebugMode() {
        if (this.isCollationDebugMode == null) {
            this.isCollationDebugMode = this.getDebugFlag(CLIENT_COLLATION_DEBUG, Boolean.FALSE);
        }
        return this.isCollationDebugMode;
    }

    private Boolean getDebugFlag(String element, Boolean defaultValue) {
        ConfigElement clientDebugElement;
        Object flags;
        Boolean debugValue = defaultValue;
        Map global = this.scriptConfigModel.getGlobal();
        if (global != null && (flags = global.get(FLAGS)) instanceof GenericConfigElement && (clientDebugElement = ((GenericConfigElement)flags).getChild(element)) != null) {
            debugValue = Boolean.valueOf(clientDebugElement.getValue());
        }
        return debugValue;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (applicationContext instanceof WebApplicationContext) {
            this.servletContext = ((WebApplicationContext)applicationContext).getServletContext();
        }
    }

    public void setScriptConfigModel(ScriptConfigModel scriptConfigModel) {
        this.scriptConfigModel = scriptConfigModel;
    }

    public String generateJavaScriptDependencies(LinkedHashSet<String> paths) {
        return this.generateDependencies(paths, CompressionType.JAVASCRIPT);
    }

    public String generateCSSDependencies(LinkedHashSet<String> paths) {
        return this.generateDependencies(paths, CompressionType.CSS);
    }

    private String generateDependencies(LinkedHashSet<String> paths, CompressionType compressionType) {
        String checksum = this.getCachedChecksumForFileSet(paths);
        if (checksum == null) {
            StringBuilder aggregatedFileContents = new StringBuilder();
            for (String path : paths) {
                try {
                    String fileContents = null;
                    if (path.startsWith(INLINE_AGGREGATION_MARKER)) {
                        aggregatedFileContents.append("\n/*Path=Inline insert...*/\n\n");
                        fileContents = path.substring(INLINE_AGGREGATION_MARKER.length());
                        aggregatedFileContents.append(fileContents);
                        aggregatedFileContents.append("\n\n");
                        continue;
                    }
                    if (this.dependencyHandler.isDebugMode()) {
                        InputStream in = this.dependencyHandler.getResourceInputStream(path);
                        if (in == null) continue;
                        fileContents = this.dependencyHandler.convertResourceToString(in);
                        aggregatedFileContents.append("\n/*Path=");
                        aggregatedFileContents.append(path);
                        aggregatedFileContents.append("*/\n\n");
                        if (compressionType == CompressionType.CSS) {
                            fileContents = this.processCssImports(path, fileContents, new HashSet<String>()).toString();
                            StringBuilder sb = new StringBuilder(fileContents);
                            this.adjustImageURLs(path, sb);
                            fileContents = this.cssThemeHandler.processCssThemes(sb);
                        }
                        aggregatedFileContents.append(fileContents);
                        aggregatedFileContents.append("\n");
                        continue;
                    }
                    fileContents = this.getCompressedFile(path, compressionType);
                    fileContents = this.processCssImports(path, fileContents, new HashSet<String>()).toString();
                    if (compressionType == CompressionType.CSS) {
                        StringBuilder sb = new StringBuilder(fileContents);
                        this.adjustImageURLs(path, sb);
                        fileContents = this.cssThemeHandler.processCssThemes(sb);
                    }
                    if (fileContents == null) {
                        if (!logger.isErrorEnabled()) continue;
                        logger.error((Object)("Could not retrieve path:" + path));
                        continue;
                    }
                    aggregatedFileContents.append(fileContents);
                }
                catch (IOException e) {
                    if (!logger.isErrorEnabled()) continue;
                    logger.error((Object)("An exception occurred compressing: " + path));
                }
            }
            String combinedDependencies = aggregatedFileContents.toString();
            checksum = this.dependencyHandler.generateCheckSum(combinedDependencies) + compressionType.fileExtension;
            DependencyResource resource = new DependencyResource(compressionType.mimetype, combinedDependencies);
            this.cacheDependencyResource(checksum, resource);
            this.cacheChecksumForFileSet(paths, checksum);
        }
        return checksum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCachedChecksumForFileSet(Set<String> fileSet) {
        String checksum = null;
        String themeId = ThreadLocalRequestContext.getRequestContext().getThemeId();
        fileSet.add(themeId);
        this.fileSetToMD5MapLock.readLock().lock();
        try {
            checksum = this.fileSetToMD5Map.get(fileSet);
        }
        finally {
            this.fileSetToMD5MapLock.readLock().unlock();
        }
        fileSet.remove(themeId);
        return checksum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cacheChecksumForFileSet(Set<String> fileSet, String checksum) {
        this.fileSetToMD5MapLock.writeLock().lock();
        try {
            String themeId = ThreadLocalRequestContext.getRequestContext().getThemeId();
            fileSet.add(themeId);
            this.fileSetToMD5Map.put(fileSet, checksum);
        }
        finally {
            this.fileSetToMD5MapLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCachedCompressedJSResource(String path) {
        String checksum = null;
        this.compressedJSResourcesLock.readLock().lock();
        try {
            checksum = this.compressedJSResources.get(path);
        }
        finally {
            this.compressedJSResourcesLock.readLock().unlock();
        }
        return checksum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cacheCompressedJSResource(String path, String content) {
        this.compressedJSResourcesLock.writeLock().lock();
        try {
            this.compressedJSResources.put(path, content);
        }
        finally {
            this.compressedJSResourcesLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCachedCompressedCssResource(String path) {
        String content = null;
        String prefix = ThreadLocalRequestContext.getRequestContext().getThemeId();
        this.compressedCSSResourcesLock.readLock().lock();
        try {
            content = this.compressedCSSResources.get(prefix + path);
        }
        finally {
            this.compressedCSSResourcesLock.readLock().unlock();
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cacheCompressedCssResource(String path, String content) {
        String prefix = ThreadLocalRequestContext.getRequestContext().getThemeId();
        this.compressedCSSResourcesLock.writeLock().lock();
        try {
            this.compressedCSSResources.put(prefix + path, content);
        }
        finally {
            this.compressedCSSResourcesLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DependencyResource getCachedDependencyResource(String path) {
        DependencyResource dependencyResource = null;
        this.combinedDependencyMapLock.readLock().lock();
        try {
            dependencyResource = this.combinedDependencyMap.get(path);
        }
        finally {
            this.combinedDependencyMapLock.readLock().unlock();
        }
        return dependencyResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cacheDependencyResource(String checksum, DependencyResource content) {
        this.combinedDependencyMapLock.writeLock().lock();
        try {
            this.combinedDependencyMap.put(checksum, content);
        }
        finally {
            this.combinedDependencyMapLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCaches() {
        this.fileSetToMD5MapLock.writeLock().lock();
        try {
            this.fileSetToMD5Map.clear();
        }
        finally {
            this.fileSetToMD5MapLock.writeLock().unlock();
        }
        this.compressedJSResourcesLock.writeLock().lock();
        try {
            this.compressedJSResources.clear();
        }
        finally {
            this.compressedJSResourcesLock.writeLock().unlock();
        }
        this.compressedCSSResourcesLock.writeLock().lock();
        try {
            this.compressedCSSResources.clear();
        }
        finally {
            this.compressedCSSResourcesLock.writeLock().unlock();
        }
        this.combinedDependencyMapLock.writeLock().lock();
        try {
            this.combinedDependencyMap.clear();
        }
        finally {
            this.combinedDependencyMapLock.writeLock().unlock();
        }
    }

    public void adjustImageURLs(String cssPath, StringBuilder cssContents) throws IOException {
        String pathPrefix = "";
        int lastForwardSlash = cssPath.lastIndexOf("/");
        if (lastForwardSlash != -1) {
            pathPrefix = cssPath.substring(0, lastForwardSlash);
        }
        int index = cssContents.indexOf("url(");
        while (index != -1) {
            int matchingClose = cssContents.indexOf(")", index + "url(".length());
            if (matchingClose == -1) {
                return;
            }
            String imageSrc = cssContents.substring(index + "url(".length(), matchingClose).trim();
            if (imageSrc.startsWith("\"") || imageSrc.startsWith("'")) {
                imageSrc = imageSrc.substring(1);
            }
            if (imageSrc.endsWith("\"") || imageSrc.endsWith("'")) {
                imageSrc = imageSrc.substring(0, imageSrc.length() - 1);
            }
            if (imageSrc.startsWith("data:image/") || imageSrc.toLowerCase().startsWith("http://") || imageSrc.startsWith("/")) {
                index = cssContents.indexOf("url(", matchingClose);
                continue;
            }
            if (imageSrc.startsWith(".") && !imageSrc.startsWith("..")) {
                imageSrc = imageSrc.substring(1);
                imageSrc = pathPrefix + imageSrc;
            } else if (!imageSrc.startsWith("..")) {
                imageSrc = pathPrefix + "/" + imageSrc;
            } else {
                String tmp = pathPrefix;
                while (imageSrc.startsWith("..")) {
                    imageSrc = imageSrc.substring(3);
                    int lastSlashIndex = tmp.lastIndexOf("/");
                    if (lastSlashIndex != -1) {
                        tmp = tmp.substring(0, lastSlashIndex);
                        continue;
                    }
                    tmp = "";
                }
                imageSrc = !tmp.endsWith("/") && !imageSrc.startsWith("/") ? tmp + "/" + imageSrc : tmp + imageSrc;
            }
            if (imageSrc.startsWith("/")) {
                imageSrc = imageSrc.substring(1);
            }
            String prefix = this.getServletContext().getContextPath() + this.dependencyHandler.getResourceControllerMapping() + "/";
            imageSrc = prefix + imageSrc;
            int offset = index + "url(".length();
            cssContents.delete(offset, matchingClose);
            offset = this.cssImageDataHandler.insert(cssContents, offset, imageSrc);
            index = cssContents.indexOf("url(", offset);
        }
    }

    public StringBuffer processCssImports(String cssPath, String fileContents, Set<String> processedPaths) {
        StringBuffer s = new StringBuffer(1024);
        if (fileContents != null) {
            Matcher m = p.matcher(fileContents);
            while (m.find()) {
                char lastChar;
                if (m.group(2) == null) continue;
                StringBuilder path = new StringBuilder(m.group(2).trim());
                if (path.charAt(0) == SINGLE_QUOTE || path.charAt(0) == DOUBLE_QUOTE) {
                    path.deleteCharAt(0);
                }
                if ((lastChar = path.charAt(path.length() - 1)) == SINGLE_QUOTE || lastChar == DOUBLE_QUOTE) {
                    path.deleteCharAt(path.length() - 1);
                }
                String importContents = null;
                try {
                    String importPath;
                    if (this.isDebugMode()) {
                        importPath = this.dependencyHandler.getRelativePath(cssPath, path.toString());
                        InputStream in = this.dependencyHandler.getResourceInputStream(importPath);
                        if (in != null) {
                            importContents = this.dependencyHandler.convertResourceToString(in);
                            importContents = this.processCssImport(importContents, cssPath, importPath, processedPaths);
                        }
                    } else {
                        importPath = this.dependencyHandler.getRelativePath(cssPath, path.toString());
                        importContents = this.getCompressedFile(importPath, CompressionType.CSS);
                        importContents = this.processCssImport(importContents, cssPath, importPath, processedPaths);
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (importContents == null) continue;
                m.appendReplacement(s, importContents);
            }
            m.appendTail(s);
        }
        return s;
    }

    protected String processCssImport(String importContents, String cssPath, String importPath, Set<String> processedPaths) throws IOException {
        StringBuilder s1 = new StringBuilder();
        if (importPath.equals(cssPath) || processedPaths.contains(importPath)) {
            s1.append(importContents);
        } else {
            processedPaths.add(importPath);
            s1.append(this.processCssImports(importPath, importContents, processedPaths));
        }
        this.adjustImageURLs(importPath, s1);
        importContents = s1.toString();
        return importContents;
    }

    String getCompressedFile(String path, CompressionType type) throws IOException {
        String compressedFile;
        block20: {
            compressedFile = null;
            if (type == CompressionType.JAVASCRIPT) {
                compressedFile = this.getCachedCompressedJSResource(path);
            } else if (type == CompressionType.CSS) {
                compressedFile = this.getCachedCompressedCssResource(path);
            }
            if (compressedFile == null) {
                if (this.excludeFileFromCompression(path)) {
                    InputStream in = this.dependencyHandler.getResourceInputStream(path);
                    if (in != null) {
                        compressedFile = this.dependencyHandler.convertResourceToString(in);
                        if (type == CompressionType.JAVASCRIPT) {
                            this.cacheCompressedJSResource(path, compressedFile);
                        } else if (type == CompressionType.CSS) {
                            StringBuilder source = new StringBuilder(compressedFile);
                            this.cssImageDataHandler.processCssImages(path, source);
                            compressedFile = this.cssThemeHandler.processCssThemes(source);
                            this.cacheCompressedCssResource(path, compressedFile);
                        }
                    }
                } else {
                    InputStream in = this.dependencyHandler.getResourceInputStream(path);
                    if (in == null) {
                        if (logger.isErrorEnabled()) {
                            logger.error((Object)("Could not find compressed file: " + path));
                        }
                    } else {
                        try {
                            if (type == CompressionType.JAVASCRIPT) {
                                InputStreamReader reader = new InputStreamReader(in, "UTF-8");
                                compressedFile = this.compressJavaScript(reader);
                                this.cacheCompressedJSResource(path, compressedFile);
                            } else if (type == CompressionType.CSS) {
                                compressedFile = this.compressCSSFile(in);
                                StringBuilder source = new StringBuilder(compressedFile);
                                this.cssImageDataHandler.processCssImages(path, source);
                                compressedFile = source.toString();
                                this.cacheCompressedCssResource(path, compressedFile);
                            }
                        }
                        catch (EvaluatorException e) {
                            if (logger.isWarnEnabled()) {
                                logger.warn((Object)("The file: \"" + path + "\" could not be compressed due to the following error: "), (Throwable)e);
                            }
                            compressedFile = IOUtils.toString((InputStream)in, (String)this.charset);
                            if (type == CompressionType.JAVASCRIPT) {
                                this.cacheCompressedJSResource(path, compressedFile);
                            }
                            if (type != CompressionType.CSS) break block20;
                            this.cacheCompressedCssResource(path, compressedFile);
                        }
                    }
                }
            }
        }
        return compressedFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String compressJavaScript(Reader reader) throws IOException {
        String compressedFile = null;
        StringWriter out = new StringWriter();
        if (this.isCollationDebugMode()) {
            try {
                char[] buffer = new char[1024];
                try {
                    int n;
                    while ((n = reader.read(buffer)) != -1) {
                        out.write(buffer, 0, n);
                    }
                }
                finally {
                    reader.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)"Compression error: ", (Throwable)e);
            }
        } else {
            JavaScriptCompressor jsc = new JavaScriptCompressor(reader, (ErrorReporter)new YuiCompressorErrorReporter());
            reader.close();
            jsc.compress((Writer)out, this.linebreak, this.munge, this.verbose, this.preserveAllSemiColons, this.disableOptimizations);
        }
        compressedFile = out.toString();
        return compressedFile;
    }

    public String compressCSSFile(InputStream in) throws IOException {
        String compressedFile = null;
        InputStreamReader reader = new InputStreamReader(in, "UTF-8");
        CssCompressor cssc = new CssCompressor((Reader)reader);
        ((Reader)reader).close();
        in.close();
        StringWriter out = new StringWriter();
        cssc.compress((Writer)out, this.linebreak);
        compressedFile = out.toString();
        return compressedFile;
    }

    public boolean excludeFileFromCompression(String path) {
        boolean exclude = false;
        for (Pattern p : this.compressionExclusionPatterns) {
            Matcher m = p.matcher(path);
            if (!m.matches()) continue;
            exclude = true;
            break;
        }
        return exclude;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setLinebreak(int linebreak) {
        this.linebreak = linebreak;
    }

    public void setMunge(boolean munge) {
        this.munge = munge;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setPreserveAllSemiColons(boolean preserveAllSemiColons) {
        this.preserveAllSemiColons = preserveAllSemiColons;
    }

    public void setDisableOptimizations(boolean disableOptimizations) {
        this.disableOptimizations = disableOptimizations;
    }

    private static class YuiCompressorErrorReporter
    implements ErrorReporter {
        private YuiCompressorErrorReporter() {
        }

        public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
            if (line < 0) {
                logger.warn((Object)message);
            } else {
                logger.warn((Object)(line + 58 + lineOffset + 58 + message));
            }
        }

        public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
            if (line < 0) {
                logger.error((Object)message);
            } else {
                logger.error((Object)(line + 58 + lineOffset + 58 + message));
            }
        }

        public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
            this.error(message, sourceName, line, lineSource, lineOffset);
            return new EvaluatorException(message);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CompressionType {
        JAVASCRIPT("text/javascript", ".js"),
        CSS("text/css", ".css");

        private String mimetype = null;
        private String fileExtension = null;

        private CompressionType(String mimetype, String fileExtension) {
            this.mimetype = mimetype;
            this.fileExtension = fileExtension;
        }
    }
}

