/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf;

import java.io.PrintWriter;
import java.io.StringWriter;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.config.ConfigService;
import org.springframework.extensions.config.RemoteConfigElement;
import org.springframework.extensions.config.WebFrameworkConfigElement;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.ServletUtil;
import org.springframework.extensions.surf.WebFrameworkServiceRegistry;
import org.springframework.extensions.surf.exception.ConnectorServiceException;
import org.springframework.extensions.surf.exception.CredentialVaultProviderException;
import org.springframework.extensions.surf.render.RenderService;
import org.springframework.extensions.surf.resource.ResourceLoader;
import org.springframework.extensions.surf.resource.ResourceService;
import org.springframework.extensions.surf.support.ThreadLocalRequestContext;
import org.springframework.extensions.webscripts.Container;
import org.springframework.extensions.webscripts.connector.Connector;
import org.springframework.extensions.webscripts.connector.ConnectorService;
import org.springframework.extensions.webscripts.connector.ConnectorSession;
import org.springframework.extensions.webscripts.connector.CredentialVault;

public final class FrameworkUtil {
    private static Log logger = LogFactory.getLog(FrameworkUtil.class);

    public static RequestContext getCurrentRequestContext() {
        return ThreadLocalRequestContext.getRequestContext();
    }

    public static WebFrameworkServiceRegistry getServiceRegistry() {
        return FrameworkUtil.getCurrentRequestContext().getServiceRegistry();
    }

    public static ConfigService getConfigService() {
        return FrameworkUtil.getServiceRegistry().getConfigService();
    }

    public static WebFrameworkConfigElement getWebFrameworkConfiguration() {
        return FrameworkUtil.getServiceRegistry().getWebFrameworkConfiguration();
    }

    public static WebFrameworkConfigElement getConfig() {
        return FrameworkUtil.getWebFrameworkConfiguration();
    }

    public static RemoteConfigElement getRemoteConfiguration() {
        return FrameworkUtil.getServiceRegistry().getRemoteConfigElement();
    }

    public static ConnectorService getConnectorService() {
        return FrameworkUtil.getServiceRegistry().getConnectorService();
    }

    public static RenderService getRenderService() {
        return FrameworkUtil.getServiceRegistry().getRenderService();
    }

    public static ResourceService getResourceService() {
        return FrameworkUtil.getServiceRegistry().getResourceService();
    }

    public static Log getLogger() {
        return logger;
    }

    public static RemoteConfigElement.EndpointDescriptor getEndpoint(String endpointId) {
        return FrameworkUtil.getRemoteConfiguration().getEndpointDescriptor(endpointId);
    }

    public static Connector getConnector(String endpointId) throws ConnectorServiceException {
        return FrameworkUtil.getConnectorService().getConnector(endpointId);
    }

    public static Connector getConnector(RequestContext context, String endpointId) throws ConnectorServiceException {
        HttpSession httpSession = ServletUtil.getSession();
        return FrameworkUtil.getConnector(httpSession, context.getUserId(), endpointId);
    }

    public static Connector getConnector(HttpSession httpSession, String userId, String endpointId) throws ConnectorServiceException {
        return FrameworkUtil.getConnectorService().getConnector(endpointId, userId, httpSession);
    }

    public static CredentialVault getCredentialVault(HttpSession httpSession, String userId) {
        CredentialVault vault = null;
        try {
            vault = FrameworkUtil.getConnectorService().getCredentialVault(httpSession, userId);
        }
        catch (CredentialVaultProviderException cvpe) {
            logger.error((Object)("Unable to retrieve credential vault for user: " + userId), (Throwable)cvpe);
        }
        return vault;
    }

    public static CredentialVault getCredentialVault(RequestContext context, String userId) {
        HttpSession httpSession = ServletUtil.getSession(false);
        return httpSession != null ? FrameworkUtil.getCredentialVault(httpSession, userId) : null;
    }

    public static ConnectorSession getConnectorSession(RequestContext context, String endpointId) {
        HttpSession httpSession = ServletUtil.getSession();
        return FrameworkUtil.getConnectorSession(httpSession, endpointId);
    }

    public static ConnectorSession getConnectorSession(HttpSession httpSession, String endpointId) {
        return FrameworkUtil.getConnectorService().getConnectorSession(httpSession, endpointId);
    }

    public static void removeConnectorSessions(RequestContext context) {
        try {
            HttpSession httpSession = ServletUtil.getSession();
            String[] endpointIds = FrameworkUtil.getRemoteConfiguration().getEndpointIds();
            for (int i = 0; i < endpointIds.length; ++i) {
                FrameworkUtil.getConnectorService().removeConnectorSession(httpSession, endpointIds[i]);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Unable to remove connector sessions", (Throwable)ex);
        }
    }

    public static String getFrameworkTitle() {
        return "Spring Surf";
    }

    public static String getFrameworkVersion() {
        return "1.0.0";
    }

    public static ResourceLoader getResourceLoader(String objectId, String endpointId) {
        return FrameworkUtil.getServiceRegistry().getResourceService().getResourceLoader(objectId, endpointId);
    }

    public static void resetWebScripts() {
        Container container = FrameworkUtil.getServiceRegistry().getWebFrameworkContainer();
        if (container != null) {
            int previousCount = container.getRegistry().getWebScripts().size();
            int previousFailures = container.getRegistry().getFailures().size();
            container.reset();
            FrameworkUtil.getLogger().info((Object)("Reset Web Scripts Registry; registered " + container.getRegistry().getWebScripts().size() + " Web Scripts.  Previously, there were " + previousCount + "."));
            int newFailures = container.getRegistry().getFailures().size();
            if (newFailures != 0 || previousFailures != 0) {
                FrameworkUtil.getLogger().info((Object)("Warning: found " + newFailures + " broken Web Scripts.  Previously, there were " + previousFailures + "."));
            }
        }
    }

    public static void logFullStacktrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        throwable.printStackTrace(pw);
        FrameworkUtil.getLogger().error((Object)sw.toString());
    }
}

