/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.render;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Element;
import org.springframework.extensions.surf.ModelPersisterInfo;
import org.springframework.extensions.surf.render.RenderMode;
import org.springframework.extensions.surf.render.Renderable;
import org.springframework.extensions.surf.types.AbstractModelObject;
import org.springframework.extensions.surf.util.XMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRenderableModelObject
extends AbstractModelObject
implements Renderable {
    public static String PROP_PROCESSOR = "processor";
    private static final String PROP_PROCESSOR_ID = "id";
    private static final String ATTR_RENDER_MODE = "mode";
    private final Map<RenderMode, Map<String, String>> processorPropertyCache;
    private final RenderMode[] renderModes;

    public AbstractRenderableModelObject(String id, ModelPersisterInfo info, Document document) {
        super(id, info, document);
        if (document != null && document.getRootElement().elements(PROP_PROCESSOR).size() != 0) {
            List processorElements = document.getRootElement().elements(PROP_PROCESSOR);
            this.renderModes = new RenderMode[processorElements.size()];
            this.processorPropertyCache = new HashMap<RenderMode, Map<String, String>>(this.renderModes.length + 1);
            for (int i = 0; i < processorElements.size(); ++i) {
                Element processorElement = (Element)processorElements.get(i);
                this.renderModes[i] = RenderMode.valueOf(processorElement.attributeValue(ATTR_RENDER_MODE).toUpperCase());
                List children = XMLUtil.getChildren(processorElement);
                HashMap<String, String> props = new HashMap<String, String>(children.size() + 1);
                for (int n = 0; n < children.size(); ++n) {
                    Element child = (Element)children.get(n);
                    String name = child.getName();
                    String value = XMLUtil.getChildValue(processorElement, name);
                    props.put(name, value);
                }
                this.processorPropertyCache.put(this.renderModes[i], props);
            }
        } else {
            this.renderModes = new RenderMode[0];
            this.processorPropertyCache = Collections.emptyMap();
        }
    }

    @Override
    public String getProcessorId() {
        return this.getProcessorId(null);
    }

    @Override
    public String getProcessorId(RenderMode mode) {
        return this.getProcessorProperty(mode, PROP_PROCESSOR_ID);
    }

    @Override
    public String getProcessorProperty(String propertyName) {
        return this.getProcessorProperty(null, propertyName);
    }

    @Override
    public String getProcessorProperty(RenderMode mode, String propertyName) {
        Map<String, String> modeData;
        String processorProperty = null;
        if (mode == null) {
            mode = RenderMode.VIEW;
        }
        if ((modeData = this.processorPropertyCache.get((Object)mode)) != null) {
            processorProperty = modeData.get(propertyName);
        }
        return processorProperty;
    }

    @Override
    public Map<String, String> getProcessorProperties() {
        return this.getProcessorProperties(null);
    }

    @Override
    public Map<String, String> getProcessorProperties(RenderMode renderMode) {
        if (renderMode == null) {
            renderMode = RenderMode.VIEW;
        }
        return (Map)((HashMap)this.processorPropertyCache.get((Object)renderMode)).clone();
    }

    @Override
    public RenderMode[] getRenderModes() {
        return this.renderModes;
    }
}

