/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.types;

import org.dom4j.Document;
import org.springframework.extensions.surf.ModelHelper;
import org.springframework.extensions.surf.ModelPersisterInfo;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.render.AbstractRenderableModelObject;
import org.springframework.extensions.surf.render.RenderUtil;
import org.springframework.extensions.surf.types.Component;
import org.springframework.extensions.surf.types.ComponentType;
import org.springframework.extensions.webscripts.WebScript;

public class ComponentImpl
extends AbstractRenderableModelObject
implements Component {
    private static final long serialVersionUID = -5779261897878106804L;
    private String regionId = null;
    private String scope = null;
    private String sourceId = null;
    private String componentTypeId = null;
    private WebScript resolvedWebScript;

    public ComponentImpl(String id, ModelPersisterInfo key, Document document) {
        super(id, key, document);
        this.setGUID(id);
    }

    public String getTypeId() {
        return "component";
    }

    public String getRegionId() {
        if (this.regionId == null) {
            this.regionId = this.getProperty("region-id");
        }
        return this.regionId;
    }

    public void setRegionId(String regionId) {
        this.setProperty("region-id", regionId);
        this.regionId = regionId;
        this.regenerateId();
    }

    public String getSourceId() {
        if (this.sourceId == null) {
            this.sourceId = this.getProperty("source-id");
        }
        return this.sourceId;
    }

    public void setSourceId(String sourceId) {
        this.setProperty("source-id", sourceId);
        this.sourceId = sourceId;
        this.regenerateId();
    }

    public String getScope() {
        if (this.scope == null) {
            this.scope = this.getProperty("scope");
        }
        return this.scope;
    }

    public void setScope(String scope) {
        this.setProperty("scope", scope);
        this.scope = scope;
        this.regenerateId();
    }

    public String getComponentTypeId() {
        if (this.componentTypeId == null) {
            this.componentTypeId = this.getProperty("component-type-id");
            if (this.componentTypeId == null) {
                this.componentTypeId = "webscript";
            }
        }
        return this.componentTypeId;
    }

    public void setComponentTypeId(String componentTypeId) {
        this.setProperty("component-type-id", componentTypeId);
        this.componentTypeId = componentTypeId;
    }

    public String getChrome() {
        return this.getProperty("chrome");
    }

    public void setChrome(String chrome) {
        this.setProperty("chrome", chrome);
    }

    public String getURL() {
        String url = this.getProperty("url");
        if (url == null) {
            url = this.getProperty("uri");
        }
        return url;
    }

    public void setURL(String url) {
        if (url != null) {
            this.setProperty("url", url);
        }
    }

    public String getURI() {
        String uri = this.getProperty("uri");
        if (uri == null) {
            uri = this.getProperty("url");
        }
        return uri;
    }

    public void setURI(String uri) {
        if (uri != null) {
            this.setProperty("url", uri);
        }
    }

    public String getGUID() {
        return this.getProperty("guid");
    }

    public void setGUID(String guid) {
        this.setProperty("guid", guid);
    }

    public Object getSourceObject(RequestContext context) {
        return RenderUtil.getComponentBindingSourceObject(context, this);
    }

    public ComponentType getComponentType(RequestContext context) {
        return context.getObjectService().getComponentType(this.getComponentTypeId());
    }

    protected void regenerateId() {
        String id = RenderUtil.generateComponentId(this.scope, this.regionId, this.sourceId);
        if (id == null && (id = this.getGUID()) == null) {
            id = ModelHelper.newGUID();
            this.setGUID(id);
        }
        this.id = id;
    }

    public void setId(String id) {
    }

    public void setResolvedWebScript(WebScript webScript) {
        this.resolvedWebScript = webScript;
    }

    public WebScript getResolvedWebScript() {
        return this.resolvedWebScript;
    }

    public String getIndex() {
        return this.getProperty("index");
    }

    public void setIndex(String index) {
        this.setProperty("index", index);
    }

    public int compareTo(Component o) {
        int oIndex = 50;
        int thisIndex = 50;
        try {
            oIndex = Integer.valueOf(o.getIndex());
        }
        catch (NumberFormatException e) {
            oIndex = 50;
        }
        try {
            thisIndex = Integer.valueOf(this.getIndex());
        }
        catch (NumberFormatException e) {
            thisIndex = 50;
        }
        return thisIndex - oIndex;
    }
}

