/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.types;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Element;
import org.springframework.extensions.surf.FrameworkBean;
import org.springframework.extensions.surf.ModelObject;
import org.springframework.extensions.surf.ModelPersisterInfo;
import org.springframework.extensions.surf.RequestContext;
import org.springframework.extensions.surf.exception.PlatformRuntimeException;
import org.springframework.extensions.surf.types.AbstractModelObject;
import org.springframework.extensions.surf.types.Page;
import org.springframework.extensions.surf.types.PageAssociation;
import org.springframework.extensions.surf.types.PageType;
import org.springframework.extensions.surf.types.TemplateInstance;
import org.springframework.extensions.webscripts.Description;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageImpl
extends AbstractModelObject
implements Page {
    private String templateId = null;

    public PageImpl(String id, ModelPersisterInfo key, Document document) {
        super(id, key, document);
        if (this.getPageTypeId() == null) {
            this.setPageTypeId("generic");
        }
    }

    @Override
    public String getTypeId() {
        return "page";
    }

    @Override
    public String getTemplateId() {
        if (this.templateId == null) {
            this.templateId = this.getTemplateId(null);
        }
        return this.templateId;
    }

    @Override
    public String getTemplateId(String formatId) {
        Element templateElement = this.getTemplateElement(formatId);
        if (templateElement != null) {
            return templateElement.getStringValue();
        }
        return null;
    }

    @Override
    public void setTemplateId(String templateId) {
        this.setTemplateId(templateId, null);
    }

    @Override
    public void setTemplateId(String templateId, String formatId) {
        Document document;
        Element templateElement;
        this.templateId = templateId;
        if (formatId != null && formatId.equals(FrameworkBean.getConfig().getDefaultFormatId())) {
            formatId = null;
        }
        if ((templateElement = this.getTemplateElement(document = this.getDocument(), formatId)) == null) {
            templateElement = document.getRootElement().addElement("template-instance");
            if (formatId != null) {
                templateElement.addAttribute("format-id", formatId);
            }
        }
        templateElement.setText(templateId);
        this.updateXML(document);
    }

    @Override
    public void removeTemplateId(String formatId) {
        if (formatId != null && formatId.equals(FrameworkBean.getConfig().getDefaultFormatId())) {
            formatId = null;
        }
        if (formatId == null) {
            this.templateId = null;
        }
        Element result = null;
        Document document = this.getDocument();
        List templateElements = document.getRootElement().elements("template-instance");
        for (int i = 0; i < templateElements.size(); ++i) {
            Element templateElement = (Element)templateElements.get(i);
            String _formatId = templateElement.attributeValue("format-id");
            if (formatId == null) {
                if (_formatId != null && _formatId.length() != 0) continue;
                result = templateElement;
                break;
            }
            if (!formatId.equals(_formatId)) continue;
            result = templateElement;
            break;
        }
        if (result != null) {
            result.getParent().remove(result);
            this.updateXML(document);
        }
    }

    @Override
    public Map<String, TemplateInstance> getTemplates(RequestContext context) {
        HashMap<String, TemplateInstance> map = new HashMap<String, TemplateInstance>(8, 1.0f);
        List templateElements = this.getDocument().getRootElement().elements("template-instance");
        for (int i = 0; i < templateElements.size(); ++i) {
            String templateId;
            Element templateElement = (Element)templateElements.get(i);
            String formatId = templateElement.attributeValue("format-id");
            if (formatId == null || formatId.length() == 0) {
                formatId = FrameworkBean.getConfig().getDefaultFormatId();
            }
            if ((templateId = templateElement.getStringValue()) == null) continue;
            TemplateInstance template = context.getObjectService().getTemplate(templateId);
            map.put(formatId, template);
        }
        return map;
    }

    @Override
    public TemplateInstance getTemplate(RequestContext context) {
        TemplateInstance instance = null;
        String templateId = this.getTemplateId();
        if (templateId != null) {
            instance = context.getObjectService().getTemplate(templateId);
        }
        return instance;
    }

    @Override
    public TemplateInstance getTemplate(RequestContext context, String formatId) {
        TemplateInstance instance = null;
        String templateId = this.getTemplateId(formatId);
        if (templateId != null) {
            instance = context.getObjectService().getTemplate(templateId);
        }
        return instance;
    }

    public PageImpl[] getChildPages(RequestContext context) {
        Map<String, ModelObject> objects = context.getObjectService().findPageAssociations(this.getId(), null, "child");
        PageImpl[] pages = new PageImpl[objects.size()];
        int i = 0;
        for (PageAssociation pageAssociation : objects.values()) {
            pages[i] = (PageImpl)pageAssociation.getDestPage(context);
            ++i;
        }
        return pages;
    }

    @Override
    public String getPageTypeId() {
        return this.getProperty("page-type-id");
    }

    @Override
    public void setPageTypeId(String pageTypeId) {
        this.setProperty("page-type-id", pageTypeId);
    }

    @Override
    public Description.RequiredAuthentication getAuthentication() {
        Description.RequiredAuthentication authentication = Description.RequiredAuthentication.none;
        String auth = this.getProperty("authentication");
        if (auth != null) {
            try {
                authentication = Description.RequiredAuthentication.valueOf((String)auth.toLowerCase());
            }
            catch (IllegalArgumentException enumErr) {
                throw new PlatformRuntimeException("Invalid page <authentication> element value: " + auth);
            }
        }
        return authentication;
    }

    @Override
    public void setAuthentication(String authentication) {
        this.setProperty("authentication", authentication);
    }

    @Override
    public PageType getPageType(RequestContext context) {
        String pageTypeId = this.getPageTypeId();
        if (pageTypeId != null) {
            return context.getObjectService().getPageType(pageTypeId);
        }
        return null;
    }

    protected Element getTemplateElement(String formatId) {
        return this.getTemplateElement(this.getDocument(), formatId);
    }

    protected Element getTemplateElement(Document document, String formatId) {
        if (formatId != null && formatId.equals(FrameworkBean.getConfig().getDefaultFormatId())) {
            formatId = null;
        }
        Element result = null;
        List templateElements = document.getRootElement().elements("template-instance");
        for (int i = 0; i < templateElements.size(); ++i) {
            Element templateElement = (Element)templateElements.get(i);
            String _formatId = templateElement.attributeValue("format-id");
            if (formatId == null) {
                if (_formatId != null && _formatId.length() != 0) continue;
                result = templateElement;
                break;
            }
            if (!formatId.equals(_formatId)) continue;
            result = templateElement;
            break;
        }
        return result;
    }
}

