/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.webscripts;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.dom4j.DocumentException;
import org.springframework.extensions.surf.ModuleDeploymentService;
import org.springframework.extensions.surf.exception.ModelObjectPersisterException;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddExtensionModule
extends DeclarativeWebScript {
    private ModuleDeploymentService moduleDeploymentService;

    public void setModuleDeploymentService(ModuleDeploymentService moduleDeploymentService) {
        this.moduleDeploymentService = moduleDeploymentService;
    }

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        HashMap<String, Object> model = new HashMap<String, Object>(7, 1.0f);
        if (this.moduleDeploymentService != null) {
            try {
                StringBuilder sb = new StringBuilder();
                Reader reader = req.getContent().getReader();
                BufferedReader br = new BufferedReader(reader);
                String line = null;
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                }
                if (!this.moduleDeploymentService.addModuleToExtension(sb.toString())) {
                    status.setCode(409);
                    status.setMessage("A module already exists with the requested id");
                    status.setRedirect(true);
                }
            }
            catch (IOException e) {
                status.setCode(500);
                status.setMessage("An error occurred reading posted content.");
                status.setException((Throwable)e);
                status.setRedirect(true);
            }
            catch (DocumentException e) {
                status.setCode(500);
                status.setMessage("An error occurred parsing the supplied Module XML definition.");
                status.setException((Throwable)e);
                status.setRedirect(true);
            }
            catch (ModelObjectPersisterException e) {
                status.setCode(500);
                status.setMessage("An error occurred saving the Extension");
                status.setException((Throwable)e);
                status.setRedirect(true);
            }
        }
        return model;
    }
}

