/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.surf.webscripts;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.springframework.extensions.config.WebFrameworkConfigElement;
import org.springframework.extensions.directives.OutputCSSContentModelElement;
import org.springframework.extensions.surf.DependencyAggregator;
import org.springframework.extensions.surf.DependencyHandler;
import org.springframework.extensions.surf.DojoDependencies;
import org.springframework.extensions.surf.DojoDependencyHandler;
import org.springframework.extensions.surf.I18nDependencyHandler;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XHRDojoDependencies
extends DeclarativeWebScript {
    private DependencyHandler dependencyHandler;
    private DojoDependencyHandler dojoDependencyHandler;
    private DependencyAggregator dependencyAggregator;
    private I18nDependencyHandler i18nDependencyHandler;
    private WebFrameworkConfigElement webFrameworkConfig;

    protected Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        HashMap<String, Object> model = new HashMap<String, Object>(7, 1.0f);
        if (this.dojoDependencyHandler != null) {
            try {
                String content = req.getContent().getContent();
                JSONParser jp = new JSONParser();
                Object o = jp.parse(content);
                if (o instanceof JSONObject) {
                    JSONObject jsonData = (JSONObject)o;
                    JSONObject widgetsAsJson = (JSONObject)jsonData.get((Object)"jsonContent");
                    LinkedHashMap<String, DojoDependencies> dependenciesForCurrentRequest = new LinkedHashMap<String, DojoDependencies>();
                    this.processWidgets(widgetsAsJson, dependenciesForCurrentRequest);
                    Map<String, String> mediaToResource = this.generateCssMediaToResourceMap(dependenciesForCurrentRequest);
                    Map<String, Map<String, Object>> i18nMap = this.i18nDependencyHandler.generateScopeToBundleMap(dependenciesForCurrentRequest);
                    String aggregatedOutput = this.dojoDependencyHandler.outputAggregateResource(dependenciesForCurrentRequest, null).toString();
                    String checksum = this.dojoDependencyHandler.getChecksumPathForDependencies(aggregatedOutput);
                    model.put("jsResource", checksum);
                    model.put("cssMap", mediaToResource);
                    model.put("i18nMap", i18nMap);
                    model.put("i18nGlobalObject", this.webFrameworkConfig.getDojoMessagesObject());
                }
            }
            catch (IOException e) {
            }
            catch (ParseException e) {
                status.setCode(500);
                status.setMessage("An error occurred parsing the 'widgets' request parameter into JSON");
                status.setException((Throwable)e);
                status.setRedirect(true);
            }
        }
        return model;
    }

    public void processWidgets(JSONObject widgets, Map<String, DojoDependencies> dependenciesForCurrentRequest) {
        Object o;
        if (widgets != null && (o = widgets.get((Object)"widgets")) instanceof JSONArray) {
            JSONArray widgetList = (JSONArray)o;
            for (Object p : widgetList) {
                Object _config;
                if (!(p instanceof JSONObject)) continue;
                JSONObject widget = (JSONObject)p;
                Object _name = widget.get((Object)"name");
                if (_name instanceof String) {
                    String widgetPath = this.dojoDependencyHandler.getPath(null, (String)_name) + ".js";
                    DojoDependencies widgetDeps = this.dojoDependencyHandler.getDependencies(widgetPath);
                    dependenciesForCurrentRequest.put(widgetPath, widgetDeps);
                    this.dojoDependencyHandler.recursivelyProcessDependencies(widgetDeps, dependenciesForCurrentRequest);
                }
                if (!((_config = widget.get((Object)"config")) instanceof JSONObject)) continue;
                this.processWidgets((JSONObject)_config, dependenciesForCurrentRequest);
            }
        }
    }

    public Map<String, String> generateCssMediaToResourceMap(Map<String, DojoDependencies> dependenciesForCurrentRequest) {
        HashMap<String, String> mediaToResource = new HashMap<String, String>();
        OutputCSSContentModelElement outputCss = new OutputCSSContentModelElement(null, null, this.dependencyAggregator);
        String prefix = this.dependencyAggregator.getServletContext().getContextPath() + this.dependencyHandler.getResourceControllerMapping() + "/";
        this.dojoDependencyHandler.processCssDependencies(dependenciesForCurrentRequest, outputCss, prefix, "xhr");
        LinkedHashMap<String, HashMap<String, LinkedHashSet<String>>> cssMap = outputCss.getDojoCssGroupToDependencyMap();
        for (HashMap<String, LinkedHashSet<String>> group : cssMap.values()) {
            for (Map.Entry<String, LinkedHashSet<String>> mediaToCssResource : group.entrySet()) {
                String checksum = this.dependencyAggregator.generateCSSDependencies(mediaToCssResource.getValue());
                mediaToResource.put(mediaToCssResource.getKey(), this.dependencyHandler.getResourceControllerMapping() + "/" + checksum);
            }
        }
        return mediaToResource;
    }

    public DependencyHandler getDependencyHandler() {
        return this.dependencyHandler;
    }

    public void setDependencyHandler(DependencyHandler dependencyHandler) {
        this.dependencyHandler = dependencyHandler;
    }

    public DojoDependencyHandler getDojoDependencyHandler() {
        return this.dojoDependencyHandler;
    }

    public void setDojoDependencyHandler(DojoDependencyHandler dojoDependencyHandler) {
        this.dojoDependencyHandler = dojoDependencyHandler;
    }

    public DependencyAggregator getDependencyAggregator() {
        return this.dependencyAggregator;
    }

    public void setDependencyAggregator(DependencyAggregator dependencyAggregator) {
        this.dependencyAggregator = dependencyAggregator;
    }

    public I18nDependencyHandler getI18nDependencyHandler() {
        return this.i18nDependencyHandler;
    }

    public void setI18nDependencyHandler(I18nDependencyHandler i18nDependencyHandler) {
        this.i18nDependencyHandler = i18nDependencyHandler;
    }

    public WebFrameworkConfigElement getWebFrameworkConfig() {
        return this.webFrameworkConfig;
    }

    public void setWebFrameworkConfig(WebFrameworkConfigElement webFrameworkConfig) {
        this.webFrameworkConfig = webFrameworkConfig;
    }
}

