/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.config.forms;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.alfresco.web.config.forms.ServiceBasedEvaluator;
import org.springframework.extensions.surf.exception.ConnectorServiceException;

public abstract class NodeMetadataBasedEvaluator
extends ServiceBasedEvaluator {
    protected static final Pattern nodeRefPattern = Pattern.compile(".+://.+/.+");

    protected abstract boolean checkJsonAgainstCondition(String var1, String var2);

    public boolean applies(Object obj, String condition) {
        boolean result;
        block7: {
            Matcher m;
            String objAsString;
            result = false;
            if (obj instanceof String && (objAsString = (String)obj).indexOf(58) != -1 && (m = nodeRefPattern.matcher(objAsString)).matches()) {
                try {
                    String jsonResponseString = this.callMetadataService(objAsString);
                    if (jsonResponseString != null) {
                        result = this.checkJsonAgainstCondition(condition, jsonResponseString);
                    } else if (this.getLogger().isWarnEnabled()) {
                        this.getLogger().warn((Object)"Metadata service response appears to be null!");
                    }
                }
                catch (ServiceBasedEvaluator.NotAuthenticatedException ne) {
                }
                catch (ConnectorServiceException e) {
                    if (!this.getLogger().isWarnEnabled()) break block7;
                    this.getLogger().warn((Object)"Failed to connect to metadata service.", (Throwable)e);
                }
            }
        }
        return result;
    }

    private String callMetadataService(String nodeString) throws ConnectorServiceException {
        return this.callService("/api/metadata?nodeRef=" + nodeString + "&shortQNames=true");
    }
}

