/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.awe.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WebEditorFilter
implements Filter {
    private static final Log logger = LogFactory.getLog(WebEditorFilter.class);
    public static final String DEFAULT_CONTEXT_PATH = "/awe";
    private static final String PARAM_CONTEXT_PATH = "contextPath";
    private static final String PARAM_DEBUG = "debug";
    private String urlPrefix;
    private boolean debugEnabled = Boolean.FALSE;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        request.setAttribute("wef_enabled", (Object)Boolean.TRUE);
        request.setAttribute("wef_url_prefix", (Object)this.urlPrefix);
        request.setAttribute("wef_debug", (Object)this.debugEnabled);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Setup request for Web Editor: (urlPrefix: " + this.urlPrefix + ", debug: " + this.debugEnabled + ")"));
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig config) throws ServletException {
        String contextPathParam = config.getInitParameter(PARAM_CONTEXT_PATH);
        if (contextPathParam != null && contextPathParam.length() > 0 && !contextPathParam.startsWith("/")) {
            contextPathParam = "/" + contextPathParam;
        }
        this.urlPrefix = contextPathParam != null ? contextPathParam : DEFAULT_CONTEXT_PATH;
        String debug = config.getInitParameter(PARAM_DEBUG);
        if (debug != null && debug.equalsIgnoreCase("true")) {
            this.debugEnabled = Boolean.TRUE;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Initialised Web Editor: (urlPrefix: " + this.urlPrefix + ", debug: " + this.debugEnabled + ")"));
        }
    }

    public void destroy() {
    }
}

