/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owbpm;

import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwMimeManager;
import com.wewebu.ow.server.dmsdialogs.views.OwObjectListView;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwObjectReference;
import com.wewebu.ow.server.ecm.bpm.OwWorkitemContainer;
import com.wewebu.ow.server.field.OwFieldDefinitionProvider;
import com.wewebu.ow.server.field.OwPriorityRule;
import com.wewebu.ow.server.field.OwSearchNode;
import com.wewebu.ow.server.field.OwSearchTemplate;
import com.wewebu.ow.server.field.OwSort;
import com.wewebu.ow.server.plug.owbpm.OwBPMDocument;
import com.wewebu.ow.server.plug.owbpm.OwBPMVirtualQueue;
import com.wewebu.ow.server.plug.owbpm.log.OwLog;
import com.wewebu.ow.server.ui.OwDocument;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;

public class OwBPMQueue
implements OwBPMVirtualQueue {
    private static final Logger LOG = OwLog.getLogger(OwBPMQueue.class);
    private OwSort m_sort;
    private OwObjectListView.OwFilter m_filter;
    private OwBPMDocument m_doc;
    private OwWorkitemContainer m_queuefolder;
    private boolean m_fIsFilter;
    private Collection m_rulelist;

    public OwBPMQueue(OwBPMDocument doc_p, OwWorkitemContainer queueFolder_p, Collection rulelist_p) {
        this.m_rulelist = rulelist_p;
        this.m_doc = doc_p;
        this.m_queuefolder = queueFolder_p;
    }

    @Override
    public String applyRules(OwObject obj_p) {
        for (OwPriorityRule rule : this.getRules()) {
            try {
                if (!rule.appliesTo(obj_p)) continue;
                return rule.getStylClass();
            }
            catch (Exception e) {
                LOG.warn((Object)"Failed to process priority rule !", (Throwable)e);
            }
        }
        return null;
    }

    private Collection getRules() {
        return this.m_rulelist;
    }

    @Override
    public OwWorkitemContainer getQueueFolder() {
        return this.m_queuefolder;
    }

    @Override
    public boolean canResubmit() throws Exception {
        return this.m_queuefolder.canResubmit();
    }

    protected OwMainAppContext getContext() {
        return (OwMainAppContext)this.m_doc.getContext();
    }

    @Override
    public OwObjectCollection getWorkItems(OwSearchNode filterNode_p) throws Exception {
        return this.getQueueFolder().getChilds(new int[]{16384}, null, this.getSort(), this.m_doc.getMaxChildCount(), 0, filterNode_p);
    }

    @Override
    public OwSort getSort() throws Exception {
        if (null == this.m_sort) {
            List sortCriterias = this.m_doc.getColumnSortCriteria();
            if (sortCriterias != null) {
                this.m_sort = new OwSort(this.getContext().getMaxSortCriteriaCount(), true);
                for (int i = sortCriterias.size() - 1; i >= 0; --i) {
                    this.m_sort.addCriteria((OwSort.OwSortCriteria)sortCriterias.get(i));
                }
            } else if (null != this.getSearchTemplate()) {
                this.m_sort = this.getSearchTemplate().getSort(this.getContext().getMaxSortCriteriaCount());
            }
        }
        return this.m_sort;
    }

    @Override
    public OwObjectListView.OwFilter getObjectListFilter() throws Exception {
        if (this.m_filter == null) {
            Collection fprops = this.m_queuefolder.getFilterProperties((Collection)this.getColumnInfo());
            this.m_filter = fprops != null ? OwObjectListView.createFilter((Collection)fprops, (OwFieldDefinitionProvider)this.m_doc.getBpmRepository(), null, (String)this.getName(), (OwDocument)this.m_doc) : OwObjectListView.createFilter((String)this.getName());
        }
        return this.m_filter;
    }

    @Override
    public List getColumnInfo() throws Exception {
        return this.m_doc.getDefaultColumnInfo();
    }

    @Override
    public String getName() throws Exception {
        return this.getQueueFolder().getID();
    }

    @Override
    public int getItemCount(int context_p) throws Exception {
        return this.getQueueFolder().getChildCount(new int[]{16385}, context_p);
    }

    @Override
    public String getDisplayName() throws Exception {
        return this.getQueueFolder().getName();
    }

    @Override
    public OwSearchTemplate getSearchTemplate() throws Exception {
        return this.getQueueFolder().getSearchTemplate();
    }

    @Override
    public String getIcon() throws Exception {
        return OwMimeManager.getMimeIcon((OwMainAppContext)this.getContext(), (OwObjectReference)this.getQueueFolder());
    }

    @Override
    public void toggleResubmitFilter() {
        if (this.isResubmitFilter()) {
            this.getQueueFolder().setFilterType(3);
        } else {
            this.getQueueFolder().setFilterType(1);
        }
    }

    @Override
    public boolean isResubmitFilter() {
        return this.getQueueFolder().getFilterType() != 3;
    }

    @Override
    public void toggleFilter() {
        this.m_fIsFilter = !this.m_fIsFilter;
    }

    @Override
    public void enableFilter(boolean fEnable_p) {
        this.m_fIsFilter = fEnable_p;
    }

    @Override
    public boolean isFilter() {
        return this.m_fIsFilter;
    }
}

