/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owbpm;

import com.wewebu.ow.server.app.OwClientRefreshContext;
import com.wewebu.ow.server.app.OwClipboard;
import com.wewebu.ow.server.app.OwClipboardContentOwObject;
import com.wewebu.ow.server.app.OwDocumentFunction;
import com.wewebu.ow.server.app.OwFieldManager;
import com.wewebu.ow.server.app.OwFieldManagerControl;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.dmsdialogs.views.OwObjectListView;
import com.wewebu.ow.server.dmsdialogs.views.OwObjectListViewRow;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwObjectReference;
import com.wewebu.ow.server.ecm.OwResource;
import com.wewebu.ow.server.ecm.OwStandardObjectCollection;
import com.wewebu.ow.server.ecm.OwUnresolvedReference;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.field.OwField;
import com.wewebu.ow.server.field.OwFieldDefinition;
import com.wewebu.ow.server.field.OwStandardFieldColumnInfo;
import com.wewebu.ow.server.plug.owbpm.log.OwLog;
import com.wewebu.ow.server.util.OwStandardXMLUtil;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;

public class OwBPMResultlistAttachmentFieldControl
extends OwFieldManagerControl {
    private static final Logger LOG = OwLog.getLogger(OwBPMResultlistAttachmentFieldControl.class);
    public static final String PLUGIN_CONFIG_ID_ATTACHMENT_FUNCTION = "AttachmentDocumentFunctions";
    private Map m_editableListViews = new HashMap();
    private Map m_readonlyListViews = new HashMap();
    private List m_enabledAttachmentFunctionIDs;

    public OwBPMResultlistAttachmentFieldControl() {
        this.m_enabledAttachmentFunctionIDs = null;
    }

    public OwBPMResultlistAttachmentFieldControl(List attachmentFunctionIDs_p) {
        this.m_enabledAttachmentFunctionIDs = attachmentFunctionIDs_p != null ? attachmentFunctionIDs_p : new ArrayList();
    }

    protected void applyConfiguration(OwObjectListView listView_p) {
        listView_p.setViewMask(69);
        ArrayList<OwStandardFieldColumnInfo> columninfo = new ArrayList<OwStandardFieldColumnInfo>();
        columninfo.add(new OwStandardFieldColumnInfo((OwFieldDefinition)OwResource.m_ObjectNamePropertyClass, 0));
        listView_p.setColumnInfo(columninfo);
    }

    private void enableFunctions(OwObjectListView listView_p) throws Exception {
        if (this.m_enabledAttachmentFunctionIDs != null) {
            LinkedList<OwDocumentFunction> enabledDocumentFunctions = new LinkedList<OwDocumentFunction>();
            for (String id : this.m_enabledAttachmentFunctionIDs) {
                if (!((OwMainAppContext)this.getContext()).getConfiguration().isDocumentFunctionAllowed(id)) continue;
                OwDocumentFunction function = ((OwMainAppContext)this.getContext()).getConfiguration().getDocumentFunction(id);
                enabledDocumentFunctions.add(function);
            }
            listView_p.setDocumentFunctionPluginList(enabledDocumentFunctions);
        }
    }

    private OwObjectListView editableListViewFormControlId(String strID_p) throws Exception {
        OwObjectListView listView = (OwObjectListView)this.m_editableListViews.get(strID_p);
        if (listView == null) {
            listView = new OwObjectListViewRow();
            listView.setExternalFormTarget(this.getFormTarget());
            this.applyConfiguration(listView);
            listView.attach(this.getContext(), null);
            this.enableFunctions(listView);
            OwDeleteAttachmentFunction m_delAttachmentFunction = new OwDeleteAttachmentFunction(strID_p);
            m_delAttachmentFunction.init((OwXMLUtil)new OwStandardXMLUtil(), (OwMainAppContext)this.getContext());
            ArrayList<OwDeleteAttachmentFunction> documentFunctions = new ArrayList<OwDeleteAttachmentFunction>(listView.getDocumentFunctionPluginList());
            documentFunctions.add(m_delAttachmentFunction);
            listView.setDocumentFunctionPluginList(documentFunctions);
            listView.setStickyFooterInUse(false);
            this.m_editableListViews.put(strID_p, listView);
        }
        return listView;
    }

    private OwObjectListView readonlyListViewFormControlId(String listID_p) throws Exception {
        OwObjectListView listView = (OwObjectListView)this.m_readonlyListViews.get(listID_p);
        if (listView == null) {
            listView = new OwObjectListViewRow();
            listView.setExternalFormTarget(this.getFormTarget());
            this.applyConfiguration(listView);
            listView.attach(this.getContext(), null);
            this.enableFunctions(listView);
            this.m_readonlyListViews.put(listID_p, listView);
        }
        return listView;
    }

    public void detach() {
        Set viewsEntries = this.m_editableListViews.entrySet();
        for (Map.Entry viewEntry : viewsEntries) {
            OwObjectListView view = (OwObjectListView)viewEntry.getValue();
            view.detach();
        }
        Set readOnlyViewsEntries = this.m_readonlyListViews.entrySet();
        for (Map.Entry viewEntry : readOnlyViewsEntries) {
            OwObjectListView view = (OwObjectListView)viewEntry.getValue();
            view.detach();
        }
        super.detach();
    }

    public void init(OwFieldManager fieldmanager_p, Node configNode_p) throws Exception {
        super.init(fieldmanager_p, configNode_p);
    }

    private Object[] createListValues(Object value_p, OwFieldDefinition fieldDef_p) throws Exception {
        Object[] listValues = null;
        Object fieldValue = value_p;
        if (fieldValue == null) {
            listValues = new Object[]{};
        } else if (fieldDef_p.isArray()) {
            if (fieldValue != null) {
                listValues = (Object[])fieldValue;
            }
        } else if (fieldValue != null) {
            listValues = new Object[]{fieldValue};
        }
        ArrayList<Object> listValuesList = new ArrayList<Object>();
        for (int i = 0; i < listValues.length; ++i) {
            if (listValues[i] instanceof OwObject) {
                listValuesList.add(listValues[i]);
                continue;
            }
            if (!(listValues[i] instanceof OwObjectReference)) continue;
            OwObjectReference reference = (OwObjectReference)listValues[i];
            if (reference instanceof OwUnresolvedReference) {
                OwUnresolvedReference unresolvedReference = (OwUnresolvedReference)reference;
                LOG.warn((Object)("OwBPMResultlistAttachmentFieldControl.createListValues : unresolved reference ignored in list control - " + unresolvedReference.getUnresolvedReason()));
                continue;
            }
            listValuesList.add(reference.getInstance());
        }
        return listValuesList.toArray(new Object[listValuesList.size()]);
    }

    public void insertEditField(Writer w_p, OwFieldDefinition fieldDef_p, OwField field_p, String strID_p) throws Exception {
        Object[] listValues = this.createListValues(field_p.getValue(), fieldDef_p);
        this.renderEditableList(w_p, strID_p, listValues);
        w_p.write("<div style='float:left;clear:left'>");
        boolean disabledPaste_ListFull = !fieldDef_p.isArray() && listValues.length > 0;
        this.renderPasteLink(w_p, "PasteObjects", strID_p, disabledPaste_ListFull, fieldDef_p);
        w_p.write("</div>");
    }

    public void insertReadOnlyField(Writer w_p, OwFieldDefinition fieldDef_p, Object value_p) throws Exception {
        Object[] listValues = this.createListValues(value_p, fieldDef_p);
        String className = fieldDef_p.getClassName();
        this.renderReadonlyList(w_p, className, listValues);
    }

    private void renderList(Writer w_p, OwObjectListView listView_p, Object[] values_p) throws Exception {
        w_p.write("<div style='floaf:left;'>");
        OwStandardObjectCollection objectList = new OwStandardObjectCollection();
        if (values_p != null) {
            objectList.addAll(Arrays.asList(values_p));
        }
        listView_p.setObjectList((OwObjectCollection)objectList, null);
        if (objectList.size() > 0) {
            listView_p.render(w_p);
        }
        w_p.write("</div>");
    }

    private void renderEditableList(Writer w_p, String strID_p, Object[] values_p) throws Exception {
        OwObjectListView listView = this.editableListViewFormControlId(strID_p);
        this.renderList(w_p, listView, values_p);
    }

    private void renderReadonlyList(Writer w_p, String listId_p, Object[] values_p) throws Exception {
        OwObjectListView listView = this.readonlyListViewFormControlId(listId_p);
        this.renderList(w_p, listView, values_p);
    }

    private void renderPasteLink(Writer w_p, String callbackfunction_p, String strID_p, boolean disabledPaste_ListFull, OwFieldDefinition fieldDef_p) throws Exception {
        OwClipboard clipboard = ((OwMainAppContext)this.getContext()).getClipboard();
        String pasteClipboardObjectTooltip = "";
        if (!disabledPaste_ListFull) {
            if (clipboard.getContentType() == 1 && (fieldDef_p.isArray() || !fieldDef_p.isArray() && clipboard.getContent().size() == 1)) {
                pasteClipboardObjectTooltip = this.getContext().localize("app.OwStandardFieldManager.pasteobject", "Paste an object from the clipboard.");
                w_p.write("<a class=\"OwMimeItem\" title=\"");
                w_p.write(pasteClipboardObjectTooltip);
                w_p.write("\" href=\"");
                w_p.write(this.getFormEventURL(callbackfunction_p, "fieldid=" + strID_p));
                w_p.write("\">");
                w_p.write("<img align=\"absmiddle\" src=\"");
                w_p.write(this.getContext().getDesignURL());
                w_p.write("/images/plug/owbpm/add_paste.png\" vspace=\"3\" class=\"OwMimeIcon\"");
                w_p.write(" alt=\"");
                w_p.write(pasteClipboardObjectTooltip);
                w_p.write("\" title=\"");
                w_p.write(pasteClipboardObjectTooltip);
                w_p.write("\"/></a>");
            } else {
                pasteClipboardObjectTooltip = !fieldDef_p.isArray() && clipboard.getContent().size() > 1 ? this.getContext().localize("app.OwStandardFieldManager.howtopasteobject.onlyone", "Please copy only one object to the clipboard first. Then you can paste it using the paste icon.") : this.getContext().localize("app.OwStandardFieldManager.howtopasteobject", "Please copy an object to the clipboard first. Then you can paste it using the paste icon.");
                w_p.write("<img title=\"");
                w_p.write(pasteClipboardObjectTooltip);
                w_p.write("\" alt=\"");
                w_p.write(pasteClipboardObjectTooltip);
                w_p.write("\" src=\"");
                w_p.write(this.getContext().getDesignURL());
                w_p.write("/images/plug/owbpm/add_paste_disabled.png\" vspace=\"3\" class=\"OwMimeIcon\"/>");
            }
        }
    }

    public void onPasteObjects(HttpServletRequest request_p) throws Exception {
        OwClipboard clipboard = ((OwMainAppContext)this.getContext()).getClipboard();
        if (clipboard.getContentType() != 1) {
            return;
        }
        OwField field = this.getFieldManager().getField(request_p.getParameter("fieldid"));
        OwFieldDefinition definition = field.getFieldDefinition();
        if (definition.isArray()) {
            int i;
            Object[] values = (Object[])field.getValue();
            Object[] newValues = null;
            if (null == values) {
                newValues = new Object[clipboard.getContent().size()];
            } else {
                newValues = new Object[values.length + clipboard.getContent().size()];
                for (i = 0; i < values.length; ++i) {
                    newValues[i] = values[i];
                }
            }
            for (i = 0; i < clipboard.getContent().size(); ++i) {
                newValues[newValues.length - clipboard.getContent().size() + i] = ((OwClipboardContentOwObject)clipboard.getContent().get(i)).getObject();
            }
            field.setValue((Object)newValues);
        } else if (clipboard.getContent().size() == 1) {
            field.setValue((Object)((OwClipboardContentOwObject)clipboard.getContent().get(0)).getObject());
        }
    }

    public Object updateField(HttpServletRequest request_p, OwFieldDefinition fieldDef_p, Object value_p, String strID_p) throws Exception {
        return value_p;
    }

    public void insertLabel(Writer w_p, String suffix_p, OwFieldDefinition fieldDef_p, String strID_p, boolean writeLabel_p) throws Exception {
        w_p.write(fieldDef_p.getDisplayName(this.getContext().getLocale()));
        if (suffix_p != null) {
            w_p.write(suffix_p);
        }
    }

    public class OwDeleteAttachmentFunction
    extends OwDocumentFunction {
        private static final String PLUGIN_ID_PREFIX = "delete.attachment";
        private String m_fieldID;
        private String m_pluginID;

        public OwDeleteAttachmentFunction(String fieldID_p) {
            this.m_fieldID = fieldID_p;
            Random random = new Random(System.currentTimeMillis());
            int randomSuffix = random.nextInt(Integer.MAX_VALUE);
            this.m_pluginID = "delete.attachment." + randomSuffix;
        }

        public String getIcon() throws Exception {
            return this.getContext().getDesignURL() + this.getConfigNode().getSafeTextValue("icon", "/images/plug/owdelref/remove.png");
        }

        public String getBigIcon() throws Exception {
            return this.getContext().getDesignURL() + this.getConfigNode().getSafeTextValue("iconbig", "/images/plug/owdelref/remove_24.png");
        }

        public void onClickEvent(OwObject object_p, OwObject parent_p, OwClientRefreshContext refreshCtx_p) throws Exception {
            ArrayList<OwObject> oneObjectList = new ArrayList<OwObject>();
            oneObjectList.add(object_p);
            this.onMultiselectClickEvent(oneObjectList, parent_p, refreshCtx_p);
        }

        public void onMultiselectClickEvent(Collection objects_p, OwObject parent_p, OwClientRefreshContext refreshCtx_p) throws Exception {
            OwField field = OwBPMResultlistAttachmentFieldControl.this.getFieldManager().getField(this.m_fieldID);
            OwFieldDefinition fieldDefinition = field.getFieldDefinition();
            if (fieldDefinition.isArray()) {
                Object[] values = (Object[])field.getValue();
                ArrayList<Object> newValuesList = new ArrayList<Object>();
                for (int i = 0; i < values.length; ++i) {
                    if (objects_p.contains(values[i])) continue;
                    newValuesList.add(values[i]);
                }
                Object[] newValues = newValuesList.toArray(new Object[newValuesList.size()]);
                field.setValue((Object)newValues);
            } else if (objects_p.contains(field.getValue())) {
                field.setValue(null);
            }
        }

        protected Set getSupportedObjectTypesFromDescriptor(String strKey_p) throws OwConfigurationException {
            Integer[] supportedObjects = new Integer[]{new Integer(4097), new Integer(8193)};
            return new HashSet<Integer>(Arrays.asList(supportedObjects));
        }

        public boolean isEnabled(OwObject object_p, OwObject parent_p, int context_p) throws Exception {
            return true;
        }

        public boolean getContextMenu() {
            return true;
        }

        public boolean getMultiselect() {
            return true;
        }

        public boolean getObjectInstance() {
            return true;
        }

        public String getPluginTitle() {
            return this.getContext().localize("owbpm.OwBPMResultlistAttachmentFieldControl.removeattachment", "Remove Attachment");
        }

        public String getTooltip() throws Exception {
            return this.getPluginTitle();
        }

        public String getPluginID() {
            return this.m_pluginID;
        }
    }
}

