/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owbpm.plug;

import com.wewebu.ow.server.app.OwFieldManager;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwStandardDialog;
import com.wewebu.ow.server.app.OwSubMenuView;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwProperty;
import com.wewebu.ow.server.ecm.OwPropertyCollection;
import com.wewebu.ow.server.ecm.OwStandardPropertyCollection;
import com.wewebu.ow.server.ecm.bpm.OwWorkitem;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.field.OwField;
import com.wewebu.ow.server.field.OwFieldProvider;
import com.wewebu.ow.server.plug.owbpm.log.OwLog;
import com.wewebu.ow.server.plug.owbpm.plug.OwBPMNotePropertyException;
import com.wewebu.ow.server.ui.OwEventTarget;
import com.wewebu.ow.server.ui.OwView;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class OwBPMInsertNoteDialog
extends OwStandardDialog
implements OwFieldProvider {
    private static final Logger LOG = OwLog.getLogger(OwBPMInsertNoteDialog.class);
    public static final int NOTE_REGION = 11;
    public static final int INSERT_NOTE_DIALOG_REGION_MAX = 13;
    protected List m_workitems;
    protected OwSubMenuView m_MenuView;
    private String m_NotePropertyName;
    private boolean m_NotePropertyIsNecessary;
    protected OwWorkitem m_currentItem;
    protected OwFieldManager m_fieldManager;
    protected OwProperty m_noteProperty;

    public OwBPMInsertNoteDialog(List workitems_p, String notePropertyName_p, boolean notePropertyIsNecessary_p) throws OwException {
        this.m_workitems = workitems_p;
        this.m_NotePropertyName = notePropertyName_p;
        this.m_NotePropertyIsNecessary = notePropertyIsNecessary_p;
    }

    public OwBPMInsertNoteDialog(OwWorkitem workitem_p, String notePropertyName_p, boolean notePropertyIsNecessary_p) throws OwException {
        this.m_workitems = new ArrayList();
        this.m_workitems.add(workitem_p);
        this.m_NotePropertyName = notePropertyName_p;
        this.m_NotePropertyIsNecessary = notePropertyIsNecessary_p;
    }

    protected String usesFormWithAttributes() {
        return "";
    }

    protected void init() throws Exception {
        super.init();
        OwMainAppContext context = (OwMainAppContext)this.getContext();
        if (null != this.m_NotePropertyName) {
            List itemsWithNoNoteProperty;
            if (this.m_NotePropertyIsNecessary && (itemsWithNoNoteProperty = this.arePropertiesDefined()) != null && itemsWithNoNoteProperty.size() > 0) {
                throw new OwBPMNotePropertyException(itemsWithNoNoteProperty, this.getContext().localize("plug.owbpm.plug.OwBPMInsertNoteFunction.notenotdefined", "Note property had not been defined at plugin descriptor."));
            }
            this.m_fieldManager = context.createFieldManager();
            if (this.m_workitems.size() > 0) {
                try {
                    OwObject obj = (OwObject)this.m_workitems.get(0);
                    this.m_noteProperty = obj.getProperty(this.m_NotePropertyName);
                }
                catch (OwObjectNotFoundException e) {
                    this.m_noteProperty = null;
                }
            }
        }
        this.m_MenuView = new OwSubMenuView();
        this.addView((OwView)this.m_MenuView, 7, null);
        int okButtonIndex = this.m_MenuView.addFormMenuItem((OwEventTarget)this, this.getContext().localize("plug.owtask.ui.OwTaskFunctionBaseDialog.ok", "OK"), "OkDo", null);
        this.m_MenuView.setDefaultMenuItem(okButtonIndex);
        this.m_MenuView.addFormMenuItem((OwEventTarget)this, this.getContext().localize("plug.owtask.ui.OwTaskFunctionBaseDialog.cancel", "Cancel"), "CancelDo", null);
    }

    private List arePropertiesDefined() throws Exception {
        ArrayList<String> propertiesWithNoNoteProperty = new ArrayList<String>();
        for (OwWorkitem item : this.m_workitems) {
            try {
                item.getProperty(this.m_NotePropertyName);
            }
            catch (OwObjectNotFoundException e) {
                propertiesWithNoNoteProperty.add(item.getName());
            }
        }
        return propertiesWithNoNoteProperty;
    }

    public void onCancelDo(HttpServletRequest request_p, Object reason_p) throws Exception {
        this.closeDialog();
    }

    public void onOkDo(HttpServletRequest request_p, Object reason_p) throws Exception {
        this.setNote(request_p);
        this.closeDialog();
    }

    public void renderRegion(Writer w_p, int iRegion_p) throws Exception {
        switch (iRegion_p) {
            case 2: {
                this.serverSideDesignInclude("owbpm/OwInsertNote.jsp", w_p);
            }
        }
        super.renderRegion(w_p, iRegion_p);
    }

    public void renderNote(Writer w_p) throws Exception {
        if (this.m_fieldManager != null && this.m_noteProperty != null) {
            this.m_fieldManager.insertEditField(w_p, (OwField)this.m_noteProperty);
        }
    }

    public void setNote(HttpServletRequest request_p) throws Exception {
        if (this.m_fieldManager != null) {
            this.m_currentItem = null;
            try {
                for (OwWorkitem this.m_currentItem : this.m_workitems) {
                    OwStandardPropertyCollection changedProperties = new OwStandardPropertyCollection();
                    this.m_fieldManager.update(request_p, (Map)changedProperties, (Map)this.m_currentItem.getProperties(null));
                    if (changedProperties.size() <= 0) continue;
                    this.m_currentItem.setProperties((OwPropertyCollection)changedProperties);
                    this.getDocument().update((OwEventTarget)this, 15, (Object)this.m_currentItem);
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Der Vorgang konnte nicht mit einer Notiz versehen werden", (Throwable)e);
                throw new OwInvalidOperationException(this.getContext().localize1("plug.owbpm.plug.OwBPMInsertNoteDialog.note.error", "Work item (%1) could not be provided with a note.", this.m_currentItem.getName()), (Throwable)e);
            }
        }
    }

    public void unlockAll() throws Exception {
        for (OwWorkitem object : this.m_workitems) {
            object.setLock(false);
        }
    }

    public Collection getWorkitems() {
        return this.m_workitems;
    }

    public OwWorkitem getCurrentItem() {
        return this.m_currentItem;
    }

    protected void onRender(Writer w_p) throws Exception {
        if (this.m_fieldManager != null) {
            this.m_fieldManager.reset();
        }
        super.onRender(w_p);
    }

    public void detach() {
        super.detach();
        if (this.m_fieldManager != null) {
            this.m_fieldManager.detach();
        }
    }

    public OwField getField(String strFieldClassName_p) throws Exception, OwObjectNotFoundException {
        OwProperty prop = null;
        if (this.m_currentItem != null) {
            try {
                prop = (OwProperty)this.m_currentItem.getProperties(null).get((Object)strFieldClassName_p);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (prop == null) {
            throw new OwObjectNotFoundException("OwObjectPropertyView.getField: Property not found, strFieldClassName_p = " + strFieldClassName_p);
        }
        return prop;
    }

    public String getFieldProviderName() {
        String name = null;
        if (this.m_currentItem != null) {
            name = this.m_currentItem.getName();
        }
        return name;
    }

    public Object getFieldProviderSource() {
        return this.m_currentItem;
    }

    public int getFieldProviderType() {
        return 1;
    }

    public Collection getFields() throws Exception {
        OwStandardPropertyCollection result = new OwStandardPropertyCollection();
        if (this.m_currentItem != null && this.m_NotePropertyName != null) {
            OwProperty noteProp = this.m_currentItem.getProperty(this.m_NotePropertyName);
            result.put((Object)noteProp.getPropertyClass().getClassName(), (Object)noteProp);
        }
        return result.values();
    }

    public Object getSafeFieldValue(String name_p, Object defaultvalue_p) {
        Object result = defaultvalue_p;
        if (this.m_currentItem != null) {
            try {
                result = this.m_currentItem.getProperty(name_p).getValue();
            }
            catch (Exception e) {
                LOG.error((Object)("OwBPMInsertNoteDialog.getSafeFieldValue: Cannot get property value for property name: " + name_p));
            }
        }
        return result;
    }

    public void setField(String name_p, Object value_p) throws Exception, OwObjectNotFoundException {
        if (name_p != null && name_p.equalsIgnoreCase(this.m_NotePropertyName)) {
            OwProperty prop = this.m_currentItem.getProperty(name_p);
            prop.setValue(value_p);
        }
    }
}

