/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owbpm.plug;

import com.wewebu.ow.server.app.OwClientRefreshContext;
import com.wewebu.ow.server.app.OwDocumentFunction;
import com.wewebu.ow.server.app.OwMessageBox;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.bpm.OwWorkitem;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.plug.owbpm.log.OwLog;
import com.wewebu.ow.server.plug.owbpm.plug.OwBPMInsertNoteDialog;
import com.wewebu.ow.server.plug.owbpm.plug.OwBPMNotePropertyException;
import com.wewebu.ow.server.ui.OwDialog;
import com.wewebu.ow.server.ui.OwEventTarget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class OwBPMInsertNoteFunction
extends OwDocumentFunction
implements OwDialog.OwDialogListener {
    private static final Logger LOG = OwLog.getLogger(OwBPMInsertNoteFunction.class);

    public String getIcon() throws Exception {
        return this.getContext().getDesignURL() + this.getConfigNode().getSafeTextValue("icon", "/images/plug/owbpm/note.png");
    }

    public String getBigIcon() throws Exception {
        return this.getContext().getDesignURL() + this.getConfigNode().getSafeTextValue("iconbig", "/images/plug/owbpm/note_24.png");
    }

    public void onClickEvent(OwObject oObject_p, OwObject oParent_p, OwClientRefreshContext refreshCtx_p) throws Exception {
        String noteProperty = this.getNoteProperty();
        if (noteProperty == null) {
            String msg = "OwBPMInsertNoteFunction.onClickEvent: Note property had not been defined at plugin descriptor.";
            LOG.fatal((Object)msg);
            throw new OwConfigurationException(this.getContext().localize("plug.owbpm.plug.OwBPMInsertNoteFunction.notenotdefined", "Notiz Property wurde im Plugin Descriptor nicht eingestellt!"));
        }
        ((OwWorkitem)oObject_p).setLock(true);
        try {
            OwBPMInsertNoteDialog dlg = new OwBPMInsertNoteDialog((OwWorkitem)oObject_p, noteProperty, true);
            dlg.setTitle(this.getLabel(oObject_p, oParent_p));
            dlg.setInfoIcon(this.getBigIcon());
            this.getContext().openDialog((OwDialog)dlg, (OwDialog.OwDialogListener)this);
            LinkedList<OwObject> objects = new LinkedList<OwObject>();
            objects.add(oObject_p);
            this.addHistoryEvent(objects, oParent_p, 2, 1);
        }
        catch (OwBPMNotePropertyException ne) {
            this.displayMessageBox(ne);
            ((OwWorkitem)oObject_p).setLock(false);
        }
        catch (Exception e) {
            ((OwWorkitem)oObject_p).setLock(false);
        }
    }

    public void onMultiselectClickEvent(Collection objects_p, OwObject oParent_p, OwClientRefreshContext refreshCtx_p) throws Exception {
        String noteProperty = this.getNoteProperty();
        if (noteProperty == null) {
            String msg = "OwBPMInsertNoteFunction.onMultiselectClickEvent: Note property had not been defined at plugin descriptor.";
            LOG.fatal((Object)msg);
            throw new OwConfigurationException(this.getContext().localize("plug.owbpm.plug.OwBPMInsertNoteFunction.notenotdefined", "Notiz Property wurde im Plugin Descriptor nicht eingestellt!"));
        }
        for (OwWorkitem object : objects_p) {
            object.setLock(true);
        }
        try {
            OwBPMInsertNoteDialog dlg = new OwBPMInsertNoteDialog(new ArrayList(objects_p), noteProperty, true);
            dlg.setTitle(this.getLabel(null, oParent_p));
            dlg.setInfoIcon(this.getBigIcon());
            this.m_MainContext.openDialog((OwDialog)dlg, (OwDialog.OwDialogListener)this);
            this.addHistoryEvent(objects_p, oParent_p, 2, 1);
        }
        catch (OwBPMNotePropertyException ne) {
            this.displayMessageBox(ne);
            this.unlockAllWorkitems(objects_p);
        }
        catch (Exception e) {
            this.unlockAllWorkitems(objects_p);
        }
    }

    private void unlockAllWorkitems(Collection objects_p) throws Exception {
        for (OwWorkitem object : objects_p) {
            object.setLock(false);
        }
    }

    private void displayMessageBox(OwBPMNotePropertyException ne_p) throws Exception {
        List properties = ne_p.getItemsWithNoNoteProperty();
        OwMessageBox msg = new OwMessageBox(0, 2, this.getContext().localize("plug.owbpm.OwBPMInsertNoteFunction.msg.title", "Note"), this.getContext().localize("plug.owbpm.OwBPMInsertNoteFunction.msg.notice.property.missing", "Note attribute is not defined for following work items.") + properties.toString());
        this.m_MainContext.openDialog((OwDialog)msg, null);
    }

    public void onDialogClose(OwDialog dialogView_p) throws Exception {
        OwBPMInsertNoteDialog dialog = (OwBPMInsertNoteDialog)dialogView_p;
        dialog.unlockAll();
    }

    private String getNoteProperty() {
        return this.getConfigNode().getSafeTextValue("Note", null);
    }

    public void onUpdate(OwEventTarget caller_p, int code_p, Object param_p) throws Exception {
        switch (code_p) {
            case 15: {
                OwWorkitem workitem;
                if (!(caller_p instanceof OwBPMInsertNoteDialog) || (workitem = ((OwBPMInsertNoteDialog)caller_p).getCurrentItem()) == null) break;
                OwObjectCollection parents = workitem.getParents();
                OwObject parent = parents != null && parents.size() > 0 ? (OwObject)parents.get(0) : null;
                this.addHistoryEvent((OwObject)workitem, parent, 3, 1);
            }
        }
    }
}

