/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owbpm.plug;

import com.wewebu.ow.server.app.OwClientRefreshContext;
import com.wewebu.ow.server.app.OwDocumentFunction;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.ecm.OwNetwork;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.bpm.OwWorkitemRepository;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.plug.owbpm.log.OwLog;
import com.wewebu.ow.server.plug.owbpm.plug.OwBPMJspWorkflowLauncher;
import com.wewebu.ow.server.plug.owbpm.plug.OwBPMStandardWorkflowLauncher;
import com.wewebu.ow.server.plug.owbpm.plug.OwBPMWorkflowLauncher;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;

public class OwBPMLaunchProcessorFunction
extends OwDocumentFunction {
    private static final String JSP_PAGE_ELEMENT_NAME = "JspForm";
    private static final Logger LOG = OwLog.getLogger(OwBPMLaunchProcessorFunction.class);
    private static final String BPM_WORKITEM_REPOSITORY_INTERFACE = "com.wewebu.ow.server.ecm.bpm.OwWorkitemRepository";
    protected OwWorkitemRepository m_bpmRepository = null;
    protected OwBPMWorkflowLauncherFactory m_workflowLauncherFactory = null;

    public void init(OwXMLUtil node_p, OwMainAppContext context_p) throws Exception {
        this.m_workflowLauncherFactory = this.createWorkflowLauncherFactory(node_p);
        super.init(node_p, context_p);
        OwNetwork network = context_p.getNetwork();
        this.m_bpmRepository = null;
        if (!network.hasInterface(BPM_WORKITEM_REPOSITORY_INTERFACE)) {
            String msg = "OwBPMLaunchProcessorFunction.init : The ECM adapter does not offer an interface for work items repsitories. This document function will be disabled!";
            LOG.warn((Object)msg);
        } else {
            this.m_bpmRepository = (OwWorkitemRepository)network.getInterface(BPM_WORKITEM_REPOSITORY_INTERFACE, null);
            if (!this.m_bpmRepository.canLaunch()) {
                String msg = "OwBPMLaunchProcessorFunction.init : The configured work item repository does not support the launching workflows. This document function will be disabled!";
                LOG.warn((Object)msg);
                this.m_bpmRepository = null;
            }
        }
    }

    protected OwBPMWorkflowLauncherFactory createWorkflowLauncherFactory(OwXMLUtil node_p) {
        OwBPMWorkflowLauncherFactory launcherFactory = null;
        String jspForm = node_p.getSafeTextValue(JSP_PAGE_ELEMENT_NAME, null);
        launcherFactory = jspForm != null ? new OwJSPWorkflowLauncherFactory() : new OwStandardWorkflowLauncherFactory();
        return launcherFactory;
    }

    public boolean isEnabled(OwObject object_p, OwObject parent_p, int context_p) throws Exception {
        if (this.m_bpmRepository != null) {
            return super.isEnabled(object_p, parent_p, context_p);
        }
        return false;
    }

    public final void onClickEvent(OwObject object_p, OwObject parent_p, OwClientRefreshContext refreshCtx_p) throws Exception {
        if (!this.isEnabled(object_p, parent_p, 2)) {
            LOG.debug((Object)"OwBPMLaunchProcessorFunction.onClickEvent():No workflow can be started for the given object!");
            throw new OwInvalidOperationException(this.getContext().localize("owbpm.OwBPMLaunchProcessorFunction.invalidObject", "No workflow can be started for the given object(s)!"));
        }
        ArrayList<OwObject> objects = new ArrayList<OwObject>();
        objects.add(object_p);
        this.onMultiselectClickEvent(objects, parent_p, refreshCtx_p);
    }

    public void onMultiselectClickEvent(Collection objects_p, OwObject parent_p, OwClientRefreshContext refreshCtx_p) throws Exception {
        if (!this.isEnabled(objects_p, parent_p, 2)) {
            LOG.debug((Object)"OwBPMLaunchProcessorFunction.onMultiselectClickEvent():No workflow can be started for the given objects!");
            throw new OwInvalidOperationException(this.getContext().localize("owbpm.OwBPMLaunchProcessorFunction.invalidObject", "No workflow can be started for the given object(s)!"));
        }
        OwBPMWorkflowLauncher launcher = this.createLauncher(objects_p);
        launcher.launch(refreshCtx_p);
        this.addHistoryEvent(objects_p, parent_p, 1, 1);
    }

    protected OwWorkitemRepository getWorkitemRepository() {
        return this.m_bpmRepository;
    }

    protected OwBPMWorkflowLauncher createLauncher(Collection targetObjects_p) throws Exception {
        return this.m_workflowLauncherFactory.createLauncher(this.getWorkitemRepository(), targetObjects_p, this.getContext(), this.getConfigNode());
    }

    public String getIcon() throws Exception {
        return this.getContext().getDesignURL() + this.getConfigNode().getSafeTextValue("icon", this.m_workflowLauncherFactory.getDefaultIcon());
    }

    public String getBigIcon() throws Exception {
        return this.getContext().getDesignURL() + this.getConfigNode().getSafeTextValue("iconbig", this.m_workflowLauncherFactory.getDefaulBigIcon());
    }

    protected class OwJSPWorkflowLauncherFactory
    implements OwBPMWorkflowLauncherFactory {
        protected OwJSPWorkflowLauncherFactory() {
        }

        @Override
        public OwBPMWorkflowLauncher createLauncher(OwWorkitemRepository repository_p, Collection targetObjects_p, OwMainAppContext context_p, OwXMLUtil configNode_p) {
            return new OwBPMJspWorkflowLauncher(repository_p, targetObjects_p, context_p, configNode_p);
        }

        @Override
        public String getDefaulBigIcon() {
            return "/images/plug/owbpm/gear_new_form_24.png";
        }

        @Override
        public String getDefaultIcon() {
            return "/images/plug/owbpm/gear_new_form.png";
        }
    }

    protected class OwStandardWorkflowLauncherFactory
    implements OwBPMWorkflowLauncherFactory {
        protected OwStandardWorkflowLauncherFactory() {
        }

        @Override
        public OwBPMWorkflowLauncher createLauncher(OwWorkitemRepository repository_p, Collection targetObjects_p, OwMainAppContext context_p, OwXMLUtil configNode_p) {
            return new OwBPMStandardWorkflowLauncher(repository_p, targetObjects_p, context_p, configNode_p);
        }

        @Override
        public String getDefaulBigIcon() {
            return "/images/plug/owbpm/gear_new_24.png";
        }

        @Override
        public String getDefaultIcon() {
            return "/images/plug/owbpm/gear_new.png";
        }
    }

    protected static interface OwBPMWorkflowLauncherFactory {
        public OwBPMWorkflowLauncher createLauncher(OwWorkitemRepository var1, Collection var2, OwMainAppContext var3, OwXMLUtil var4);

        public String getDefaultIcon();

        public String getDefaulBigIcon();
    }
}

