/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owbpm.plug;

import com.wewebu.ow.server.app.OwClientRefreshContext;
import com.wewebu.ow.server.app.OwDocumentFunction;
import com.wewebu.ow.server.app.OwMessageBox;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.bpm.OwWorkitem;
import com.wewebu.ow.server.ecm.bpm.OwWorkitemContainer;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.plug.owbpm.log.OwLog;
import com.wewebu.ow.server.plug.owbpm.plug.OwBPMNotePropertyException;
import com.wewebu.ow.server.plug.owbpm.plug.OwBPMReassignDialog;
import com.wewebu.ow.server.ui.OwDialog;
import com.wewebu.ow.server.ui.OwEventTarget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class OwBPMReassignFunction
extends OwDocumentFunction
implements OwDialog.OwDialogListener {
    private static final Logger LOG = OwLog.getLogger(OwBPMReassignFunction.class);

    public String getIcon() throws Exception {
        return this.getContext().getDesignURL() + this.getConfigNode().getSafeTextValue("icon", "/images/plug/owbpm/reassign.png");
    }

    public String getBigIcon() throws Exception {
        return this.getContext().getDesignURL() + this.getConfigNode().getSafeTextValue("iconbig", "/images/plug/owbpm/reassign_24.png");
    }

    public void onClickEvent(OwObject oObject_p, OwObject oParent_p, OwClientRefreshContext refreshCtx_p) throws Exception {
        OwWorkitem workitem = (OwWorkitem)oObject_p;
        String noteProperty = this.getNoteProperty();
        if (!workitem.canReassignToUserContainer(2) && !workitem.canReassignToPublicContainer(2)) {
            throw new OwInvalidOperationException(this.getContext().localize("plug.owbpm.plug.OwBPMReassignFunction.notenabled", "You cannot forward this work item."));
        }
        workitem.setLock(true);
        try {
            OwBPMReassignDialog dlg = new OwBPMReassignDialog(workitem, (OwWorkitemContainer)oParent_p, refreshCtx_p, noteProperty);
            dlg.setTitle(this.getLabel(oObject_p, oParent_p));
            dlg.setInfoIcon(this.getBigIcon());
            this.getContext().openDialog((OwDialog)dlg, (OwDialog.OwDialogListener)this);
            LinkedList<OwWorkitem> workitems = new LinkedList<OwWorkitem>();
            workitems.add(workitem);
            this.addHistoryEvent(workitems, oParent_p, 2, 1);
        }
        catch (OwBPMNotePropertyException ne) {
            this.displayMessageBox(ne);
            workitem.setLock(false);
        }
        catch (Exception e) {
            workitem.setLock(false);
        }
    }

    public void onMultiselectClickEvent(Collection objects_p, OwObject oParent_p, OwClientRefreshContext refreshCtx_p) throws Exception {
        String noteProperty = this.getNoteProperty();
        if (noteProperty == null) {
            LOG.warn((Object)"OwBPMReassignFunction.onMultiselectClickEvent: Note property had not been defined in plugin descriptor.");
        }
        ArrayList<OwWorkitem> enabledWorkitems = new ArrayList<OwWorkitem>();
        for (OwWorkitem object : objects_p) {
            if (!object.canReassignToUserContainer(2) && !object.canReassignToPublicContainer(2)) continue;
            enabledWorkitems.add(object);
        }
        if (enabledWorkitems.isEmpty()) {
            throw new OwInvalidOperationException(this.getContext().localize("plug.owbpm.plug.OwBPMReassignFunction.any.notenabled", "You cannot forward any of the selected work items."));
        }
        for (OwWorkitem object : enabledWorkitems) {
            object.setLock(true);
        }
        try {
            OwBPMReassignDialog dlg = new OwBPMReassignDialog(enabledWorkitems, (OwWorkitemContainer)oParent_p, refreshCtx_p, noteProperty);
            dlg.setTitle(this.getLabel(null, oParent_p));
            dlg.setInfoIcon(this.getBigIcon());
            this.m_MainContext.openDialog((OwDialog)dlg, (OwDialog.OwDialogListener)this);
            this.addHistoryEvent(enabledWorkitems, oParent_p, 2, 1);
        }
        catch (OwBPMNotePropertyException ne) {
            this.displayMessageBox(ne);
            this.unlockAllWorkitems(enabledWorkitems);
        }
        catch (Exception e) {
            this.unlockAllWorkitems(enabledWorkitems);
        }
    }

    public boolean isEnabled(OwObject oObject_p, OwObject oParent_p, int iContext_p) throws Exception {
        if (!super.isEnabled(oObject_p, oParent_p, iContext_p)) {
            return false;
        }
        return ((OwWorkitem)oObject_p).canReassignToUserContainer(iContext_p) || ((OwWorkitem)oObject_p).canReassignToPublicContainer(iContext_p);
    }

    private void unlockAllWorkitems(Collection objects_p) throws Exception {
        for (OwWorkitem object : objects_p) {
            object.setLock(false);
        }
    }

    private void displayMessageBox(OwBPMNotePropertyException ne_p) {
        List properties = ne_p.getItemsWithNoNoteProperty();
        OwMessageBox msg = new OwMessageBox(0, 2, this.getContext().localize("plug.owbpm.OwBPMReassignFunction.msg.title", "Note"), this.getContext().localize("plug.owbpm.OwBPMReassignFunction.msg.notice.property.missing", "Note property had not been defined for following work items:") + properties.toString());
        try {
            this.m_MainContext.openDialog((OwDialog)msg, null);
        }
        catch (Exception e) {
            LOG.error((Object)"Exception opening dialog", (Throwable)e);
        }
    }

    public void onDialogClose(OwDialog dialogView_p) throws Exception {
        OwBPMReassignDialog dialog = (OwBPMReassignDialog)dialogView_p;
        dialog.unlockAll();
    }

    private String getNoteProperty() {
        return this.getConfigNode().getSafeTextValue("Note", null);
    }

    public void onUpdate(OwEventTarget caller_p, int code_p, Object param_p) throws Exception {
        OwWorkitem workItem = this.getCurrentWorkitem(caller_p);
        if (workItem != null) {
            OwObject parent = this.getParent(workItem);
            switch (code_p) {
                case 15: {
                    this.addHistoryEvent((OwObject)workItem, parent, 3, 1);
                    break;
                }
                case 17: {
                    this.addHistoryEvent((OwObject)workItem, parent, 11, 1);
                }
            }
        }
    }

    private OwObject getParent(OwWorkitem workItem_p) throws Exception {
        OwObjectCollection parents = workItem_p.getParents();
        OwObject parent = parents != null && parents.size() > 0 ? (OwObject)parents.get(0) : null;
        return parent;
    }

    private OwWorkitem getCurrentWorkitem(OwEventTarget caller_p) {
        OwWorkitem workItem = null;
        if (caller_p != null && caller_p instanceof OwBPMReassignDialog) {
            workItem = ((OwBPMReassignDialog)caller_p).getCurrentItem();
        }
        return workItem;
    }
}

