/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owbpm.plug;

import com.wewebu.ow.server.app.OwClientRefreshContext;
import com.wewebu.ow.server.app.OwEditablePropertyDate;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.ecm.bpm.OwWorkitem;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.plug.owbpm.log.OwLog;
import com.wewebu.ow.server.plug.owbpm.plug.OwBPMInsertNoteDialog;
import com.wewebu.ow.server.ui.OwEventTarget;
import com.wewebu.ow.server.util.OwDateTimeUtil;
import java.io.Writer;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class OwBPMResubmitDialog
extends OwBPMInsertNoteDialog {
    private static final Logger LOG = OwLog.getLogger(OwBPMResubmitDialog.class);
    public static final int KEY_RESUBMIT_DATE = 100;
    private OwClientRefreshContext m_refreshCtx;
    private OwEditablePropertyDate m_reassignDate;
    private String m_errorEditField;

    public OwBPMResubmitDialog(List workitems_p, String noteProperty_p, OwClientRefreshContext refreshCtx_p) throws OwException {
        super(workitems_p, noteProperty_p, false);
        this.m_refreshCtx = refreshCtx_p;
    }

    public OwBPMResubmitDialog(OwWorkitem workitem_p, String noteProperty_p, OwClientRefreshContext refreshCtx_p) throws OwException {
        super(workitem_p, noteProperty_p, false);
        this.m_refreshCtx = refreshCtx_p;
    }

    @Override
    protected void init() throws Exception {
        super.init();
        this.m_reassignDate = new OwEditablePropertyDate((OwMainAppContext)this.getContext());
        Date resubmitdate = ((OwWorkitem)this.m_workitems.get(0)).getResubmitDate(2);
        if (resubmitdate != null) {
            this.m_reassignDate.setValue((Object)resubmitdate);
        } else {
            this.m_reassignDate.setValue((Object)OwDateTimeUtil.offsetDay((Date)new Date(), (int)1));
        }
    }

    @Override
    public void onOkDo(HttpServletRequest request_p, Object reason_p) throws Exception {
        try {
            this.setNote(request_p);
        }
        catch (OwException e) {
            LOG.warn((Object)"Set note Exception", (Throwable)e);
        }
        if (this.m_reassignDate.update(this.getContext().getLocale(), request_p)) {
            this.m_errorEditField = this.m_reassignDate.getSafePropertyError(this.getContext().getLocale());
            if (this.m_errorEditField == null || this.m_errorEditField.length() == 0) {
                this.setSubmitDate();
                this.closeDialog();
            }
        }
        if (null != this.m_refreshCtx) {
            this.m_refreshCtx.onClientRefreshContextUpdate(3, null);
        }
        this.getDocument().update((OwEventTarget)this, 15, null);
    }

    private void setSubmitDate() throws Exception {
        OwWorkitem item2 = null;
        for (OwWorkitem item2 : this.m_workitems) {
            try {
                Date reassignDate = (Date)this.m_reassignDate.getValue();
                item2.resubmit(reassignDate);
            }
            catch (Exception e) {
                LOG.error((Object)"Der Vorgang konnte nicht auf Wiedervorlage gesetzt werden!", (Throwable)e);
                throw new OwInvalidOperationException(this.getContext().localize1("plug.owbpm.plug.OwBPMResubmitDialog.resubmit.error", "Work item (%1) cannot be resubmitted.", item2.getName()), (Throwable)e);
            }
        }
    }

    @Override
    public void renderRegion(Writer w_p, int iRegion_p) throws Exception {
        switch (iRegion_p) {
            case 2: {
                this.serverSideDesignInclude("owbpm/OwResubmit.jsp", w_p);
                break;
            }
            case 100: {
                this.m_reassignDate.render(this.getContext().getLocale(), w_p);
                break;
            }
            default: {
                super.renderRegion(w_p, iRegion_p);
            }
        }
    }

    public String getErrorEditField() {
        return this.m_errorEditField;
    }
}

