/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owbpm.plug;

import com.wewebu.ow.server.app.OwClientRefreshContext;
import com.wewebu.ow.server.app.OwDocumentFunction;
import com.wewebu.ow.server.app.OwMessageBox;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.bpm.OwWorkitem;
import com.wewebu.ow.server.plug.owbpm.log.OwLog;
import com.wewebu.ow.server.plug.owbpm.plug.OwBPMNotePropertyException;
import com.wewebu.ow.server.plug.owbpm.plug.OwBPMResubmitDialog;
import com.wewebu.ow.server.ui.OwDialog;
import com.wewebu.ow.server.ui.OwEventTarget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;

public class OwBPMResubmitFunction
extends OwDocumentFunction
implements OwDialog.OwDialogListener {
    private static final Logger LOG = OwLog.getLogger(OwBPMResubmitFunction.class);

    public String getIcon() throws Exception {
        return this.getContext().getDesignURL() + this.getConfigNode().getSafeTextValue("icon", "/images/plug/owbpm/resubmit.png");
    }

    public String getBigIcon() throws Exception {
        return this.getContext().getDesignURL() + this.getConfigNode().getSafeTextValue("iconbig", "/images/plug/owbpm/resubmit_24.png");
    }

    public boolean isEnabled(OwObject oObject_p, OwObject oParent_p, int iContext_p) throws Exception {
        if (!super.isEnabled(oObject_p, oParent_p, iContext_p)) {
            return false;
        }
        return ((OwWorkitem)oObject_p).canResubmit(iContext_p);
    }

    public void onClickEvent(OwObject oObject_p, OwObject oParent_p, OwClientRefreshContext refreshCtx_p) throws Exception {
        OwWorkitem workitem = (OwWorkitem)oObject_p;
        String noteProperty = this.getNoteProperty();
        if (noteProperty == null) {
            LOG.warn((Object)"OwBPMResubmitFunction.onClickEvent: Note property had not been defined in plugin descriptor.");
        }
        if (!workitem.canResubmit(2)) {
            String errMessage = this.getContext().localize("plug.owbpm.plug.OwBPMResubmitFunction.notenabled", "Resubmission is not available for this work item.");
            this.getContext().postMessage(errMessage);
            return;
        }
        workitem.setLock(true);
        try {
            OwBPMResubmitDialog dlg = new OwBPMResubmitDialog(workitem, noteProperty, refreshCtx_p);
            dlg.setTitle(this.getLabel(oObject_p, oParent_p));
            dlg.setInfoIcon(this.getBigIcon());
            this.getContext().openDialog((OwDialog)dlg, (OwDialog.OwDialogListener)this);
        }
        catch (OwBPMNotePropertyException ne) {
            this.displayMessageBox(ne);
            workitem.setLock(false);
        }
        catch (Exception e) {
            workitem.setLock(false);
        }
    }

    public void onMultiselectClickEvent(Collection objects_p, OwObject oParent_p, OwClientRefreshContext refreshCtx_p) throws Exception {
        String noteProperty = this.getNoteProperty();
        ArrayList<OwWorkitem> enabledWorkitems = new ArrayList<OwWorkitem>();
        for (OwWorkitem object : objects_p) {
            if (!object.canResubmit(2)) continue;
            enabledWorkitems.add(object);
        }
        if (enabledWorkitems.isEmpty()) {
            String errorMessage = this.getContext().localize("plug.owbpm.plug.OwBPMResubmitFunction.any.notenabled", "Resubmission is not available for any of the selected work items.");
            this.getContext().postMessage(errorMessage);
            return;
        }
        for (OwWorkitem object : enabledWorkitems) {
            object.setLock(true);
        }
        try {
            OwBPMResubmitDialog dlg = new OwBPMResubmitDialog(enabledWorkitems, noteProperty, refreshCtx_p);
            dlg.setTitle(this.getLabel(null, oParent_p));
            dlg.setInfoIcon(this.getBigIcon());
            this.m_MainContext.openDialog((OwDialog)dlg, (OwDialog.OwDialogListener)this);
        }
        catch (OwBPMNotePropertyException ne) {
            this.displayMessageBox(ne);
            this.unlockAllWorkitems(enabledWorkitems);
        }
        catch (Exception e) {
            this.unlockAllWorkitems(enabledWorkitems);
            LOG.error((Object)"Exception...", (Throwable)e);
            throw e;
        }
    }

    private void unlockAllWorkitems(Collection objects_p) throws Exception {
        for (OwWorkitem object : objects_p) {
            object.setLock(false);
        }
    }

    private void displayMessageBox(OwBPMNotePropertyException ne_p) throws Exception {
        List properties = ne_p.getItemsWithNoNoteProperty();
        OwMessageBox msg = new OwMessageBox(0, 2, this.getContext().localize("plug.owbpm.OwBPMResubmitFunction.msg.title", "Note"), this.getContext().localize("plug.owbpm.OwBPMResubmitFunction.msg.notice.property.missing", "Note property is not defined for following work items.") + properties.toString());
        this.m_MainContext.openDialog((OwDialog)msg, null);
    }

    public void onDialogClose(OwDialog dialogView_p) throws Exception {
        OwBPMResubmitDialog dialog = (OwBPMResubmitDialog)dialogView_p;
        dialog.unlockAll();
        this.addHistoryEvent(dialog.getWorkitems(), null, 2, 1);
    }

    private String getNoteProperty() {
        return this.getConfigNode().getSafeTextValue("Note", null);
    }

    public void onUpdate(OwEventTarget caller_p, int code_p, Object param_p) throws Exception {
        switch (code_p) {
            case 15: {
                OwWorkitem workItem;
                if (!(caller_p instanceof OwBPMResubmitDialog) || (workItem = ((OwBPMResubmitDialog)caller_p).getCurrentItem()) == null) break;
                OwObjectCollection parents = workItem.getParents();
                OwObject parent = parents != null && parents.size() > 0 ? (OwObject)parents.get(0) : null;
                this.addHistoryEvent((OwObject)workItem, parent, 3, 1);
            }
        }
    }
}

