/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owbpm.plug;

import com.wewebu.ow.server.app.OwClientRefreshContext;
import com.wewebu.ow.server.app.OwDocumentFunction;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.bpm.OwWorkitem;
import com.wewebu.ow.server.plug.owbpm.log.OwLog;
import com.wewebu.ow.server.util.OwHTMLHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.apache.log4j.Logger;

public class OwBPMResubmitResetFunction
extends OwDocumentFunction {
    private static final Logger LOG = OwLog.getLogger(OwBPMResubmitResetFunction.class);
    private static final Date DATE_IN_THE_PAST = new Date(0L);

    public String getIcon() throws Exception {
        return this.getContext().getDesignURL() + this.getConfigNode().getSafeTextValue("icon", "/images/plug/owbpm/resubmit_reset.png");
    }

    public String getBigIcon() throws Exception {
        return this.getContext().getDesignURL() + this.getConfigNode().getSafeTextValue("iconbig", "/images/plug/owbpm/resubmit_reset_24.png");
    }

    public boolean isEnabled(OwObject oObject_p, OwObject oParent_p, int iContext_p) throws Exception {
        if (!super.isEnabled(oObject_p, oParent_p, iContext_p)) {
            return false;
        }
        if (!((OwWorkitem)oObject_p).canResubmit(iContext_p)) {
            return false;
        }
        Date resubmitdate = ((OwWorkitem)oObject_p).getResubmitDate(2);
        if (resubmitdate == null) {
            return false;
        }
        return resubmitdate.getTime() > new Date().getTime();
    }

    public void onClickEvent(OwObject oObject_p, OwObject oParent_p, OwClientRefreshContext refreshCtx_p) throws Exception {
        ArrayList<OwObject> workitems = new ArrayList<OwObject>();
        workitems.add(oObject_p);
        this.onMultiselectClickEvent(workitems, oParent_p, refreshCtx_p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMultiselectClickEvent(Collection objects_p, OwObject oParent_p, OwClientRefreshContext refreshCtx_p) throws Exception {
        this.addHistoryEvent(objects_p, oParent_p, 1, 1);
        ArrayList<OwWorkitem> enabledWorkitems = new ArrayList<OwWorkitem>();
        for (OwWorkitem object : objects_p) {
            if (this.isEnabled((OwObject)object, oParent_p, 2)) {
                enabledWorkitems.add(object);
                continue;
            }
            LOG.debug((Object)("OwBPMResubmitResetFunction.onMultiselectClickEvent: Reset Resubmissiondate is not enabled for " + object.getName()));
        }
        if (enabledWorkitems.isEmpty()) {
            String errMessage = this.getContext().localize("plug.owbpm.plug.OwBPMResubmitResetFunction.any.notenabled", "Resubmission reset function cannot be executed to any of the selected work items.");
            this.getContext().postMessage(errMessage);
            return;
        }
        for (OwWorkitem object : enabledWorkitems) {
            object.setLock(true);
        }
        try {
            for (OwWorkitem object : enabledWorkitems) {
                object.resubmit(DATE_IN_THE_PAST);
                this.addHistoryEvent((OwObject)object, oParent_p, 3, 1);
            }
            if (null != refreshCtx_p) {
                refreshCtx_p.onClientRefreshContextUpdate(3, enabledWorkitems);
            }
            this.m_MainContext.postMessage(this.m_MainContext.localize("plug.OwBPMResubmitResetFunction.resetmessage", "Resubmission was reset for the following processes."));
            for (OwWorkitem wItem : objects_p) {
                this.m_MainContext.postMessage(" - " + OwHTMLHelper.encodeToSecureHTML((String)wItem.getName()));
            }
        }
        finally {
            for (OwWorkitem object : enabledWorkitems) {
                object.setLock(false);
            }
        }
    }
}

