/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owbpm.plug;

import com.wewebu.ow.server.app.OwClientRefreshContext;
import com.wewebu.ow.server.app.OwDocumentFunction;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.bpm.OwWorkitem;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;

public class OwBPMReturnToSourceFunction
extends OwDocumentFunction {
    public String getIcon() throws Exception {
        return this.getContext().getDesignURL() + this.getConfigNode().getSafeTextValue("icon", "/images/plug/owbpm/returntosource.png");
    }

    public String getBigIcon() throws Exception {
        return this.getContext().getDesignURL() + this.getConfigNode().getSafeTextValue("iconbig", "/images/plug/owbpm/returntosource_24.png");
    }

    public void onClickEvent(OwObject oObject_p, OwObject oParent_p, OwClientRefreshContext refreshCtx_p) throws Exception {
        OwWorkitem object = (OwWorkitem)oObject_p;
        if (!object.canReturnToSource(2)) {
            throw new OwInvalidOperationException(this.getContext().localize("plug.owbpm.plug.OwBPMReturnToSourceFunction.notenabled", "Reassign function is not available for this work item."));
        }
        object.setLock(true);
        object.returnToSource();
        object.setLock(false);
        if (null != refreshCtx_p) {
            refreshCtx_p.onClientRefreshContextUpdate(3, null);
        }
        LinkedList<OwWorkitem> enabledWorkitems = new LinkedList<OwWorkitem>();
        enabledWorkitems.add(object);
        this.addHistoryEvent(enabledWorkitems, oParent_p, 1, 1);
    }

    public void onMultiselectClickEvent(Collection objects_p, OwObject oParent_p, OwClientRefreshContext refreshCtx_p) throws Exception {
        ArrayList<OwWorkitem> enabledWorkitems = new ArrayList<OwWorkitem>();
        for (OwWorkitem object : objects_p) {
            if (!object.canReturnToSource(2)) continue;
            enabledWorkitems.add(object);
        }
        if (enabledWorkitems.isEmpty()) {
            throw new OwInvalidOperationException(this.getContext().localize("plug.owbpm.plug.OwBPMReturnToSourceFunction.any.notenabled", "Reassign function is not available for any of the selected work items."));
        }
        for (OwWorkitem object : enabledWorkitems) {
            object.setLock(true);
            object.returnToSource();
            object.setLock(false);
        }
        if (null != refreshCtx_p) {
            refreshCtx_p.onClientRefreshContextUpdate(3, null);
        }
        this.addHistoryEvent(enabledWorkitems, oParent_p, 1, 1);
    }

    public boolean isEnabled(OwObject oObject_p, OwObject oParent_p, int iContext_p) throws Exception {
        if (!super.isEnabled(oObject_p, oParent_p, iContext_p)) {
            return false;
        }
        return ((OwWorkitem)oObject_p).canReturnToSource(iContext_p);
    }
}

