/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.alfresco.bpm;

import com.wewebu.ow.server.ecm.OwProperty;
import com.wewebu.ow.server.ecm.OwPropertyClass;
import com.wewebu.ow.server.ecm.OwPropertyCollection;
import com.wewebu.ow.server.ecm.OwStandardPropertyCollection;
import com.wewebu.ow.server.ecm.bpm.OwWorkflowDescription;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMLaunchableWorkitemContainer;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMRepository;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMWorkItem;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMWorkflowDescription;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.log.OwLog;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.AlfrescoRESTFulFactory;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.OwRestException;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.StartWorkflowResource;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.WorkflowStartResult;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.beans.TaskInstance;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.beans.WorkflowInstance;
import com.wewebu.ow.server.exceptions.OwException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.json.JSONObject;
import org.restlet.ext.json.JsonRepresentation;
import org.restlet.resource.ResourceException;

public class OwAlfrescoBPMLaunchableWorkItem
extends OwAlfrescoBPMWorkItem {
    private static final Logger LOG = OwLog.getLogger(OwAlfrescoBPMLaunchableWorkItem.class);
    private OwWorkflowDescription workflowDescription;

    protected OwAlfrescoBPMLaunchableWorkItem(TaskInstance taskInstance, OwAlfrescoBPMLaunchableWorkitemContainer container, Collection attachmentobjects, OwAlfrescoBPMWorkflowDescription workflowDescription, OwAlfrescoBPMRepository bpmRepository) throws OwException {
        super(taskInstance, container, bpmRepository);
        this.attachmentobjects = new ArrayList();
        if (null != attachmentobjects) {
            this.attachmentobjects.addAll(attachmentobjects);
        }
        this.workflowDescription = workflowDescription;
    }

    @Override
    public void dispatch() throws Exception {
        AlfrescoRESTFulFactory restfulFactory = this.bpmRepository.getRestFulFactory();
        StartWorkflowResource resource = restfulFactory.startWorkflowResource(this.workflowDescription.getId());
        try {
            Map<String, Object> parameters = this.prepareParameters();
            String currentUserName = this.bpmRepository.getNetwork().getCredentials().getAuthInfo("USER");
            parameters.put("bpm:assignee", currentUserName);
            JSONObject jsonObject = new JSONObject(parameters);
            LOG.log((Priority)Level.WARN, (Object)jsonObject);
            WorkflowStartResult result = resource.start(new JsonRepresentation(jsonObject));
            WorkflowInstance workflowInstance = new WorkflowInstance();
            workflowInstance.setId(result.data.getWorkflowInstanceId());
            this.taskInstance.setWorkflowInstance(workflowInstance);
            String bpmPackage = result.data.getBpmPackage();
            OwProperty bpmPackageProp = this.getProperty("bpm:package");
            bpmPackageProp.setValue((Object)bpmPackage);
            OwStandardPropertyCollection props = new OwStandardPropertyCollection();
            props.put((Object)"bpm:package", (Object)bpmPackageProp);
            this.setProperties((OwPropertyCollection)props);
        }
        catch (ResourceException re) {
            LOG.error((Object)resource.getClientResource().getResponse().getEntityAsText());
            throw new OwRestException("Could not start workflow.", re);
        }
        finally {
            resource.getClientResource().release();
        }
        this.saveAttachments();
    }

    @Override
    public boolean canDispatch(int iContext_p) throws Exception {
        return true;
    }

    @Override
    public boolean getLock(int iContext_p) throws Exception {
        return true;
    }

    @Override
    protected void save() {
    }

    @Override
    public void setProperties(OwPropertyCollection properties_p) throws Exception {
        super.setProperties(properties_p);
    }

    @Override
    protected void loadAttachments() {
    }

    @Override
    public boolean canReassignToUserContainer(int iContext_p) throws Exception {
        return false;
    }

    @Override
    protected Object loadPropertyValue(String strPropertyName_p, OwPropertyClass propertyClass) throws Exception {
        Object nativeValue = super.loadPropertyValue(strPropertyName_p, propertyClass);
        if (null == nativeValue) {
            nativeValue = propertyClass.getDefaultValue();
        }
        return nativeValue;
    }
}

