/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.alfresco.bpm;

import com.wewebu.ow.server.ecm.OwBatch;
import com.wewebu.ow.server.ecm.OwNetwork;
import com.wewebu.ow.server.ecm.OwNetworkContext;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectClass;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwResource;
import com.wewebu.ow.server.ecm.bpm.OwWorkflowDescription;
import com.wewebu.ow.server.ecm.bpm.OwWorkitem;
import com.wewebu.ow.server.ecm.bpm.OwWorkitemContainer;
import com.wewebu.ow.server.ecm.bpm.OwWorkitemRepository;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMLaunchableWorkitemContainer;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMUserQueueContainer;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMWorkflowDescription;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.log.OwLog;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.AlfrescoRESTFulFactory;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.OwRestException;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.WorkflowDefinitions;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.WorkflowDefinitionsResource;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.beans.WorkflowDefinition;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.util.WorkflowDescriptionNameComparator;
import com.wewebu.ow.server.event.OwEventManager;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwNotSupportedException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.field.OwFieldDefinition;
import com.wewebu.ow.server.field.OwSearchNode;
import com.wewebu.ow.server.field.OwSort;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.restlet.resource.ResourceException;

public class OwAlfrescoBPMRepository
implements OwWorkitemRepository {
    private static final Logger LOG = OwLog.getLogger(OwAlfrescoBPMRepository.class);
    private static final String BASE_URL = "BaseURL";
    private OwNetwork network;
    private OwXMLUtil config;
    private String baseURL;
    private AlfrescoRESTFulFactory restFulFactory;

    public OwAlfrescoBPMRepository(OwNetwork network_p, OwXMLUtil bpmConfig_p) throws OwConfigurationException {
        this.network = network_p;
        this.config = bpmConfig_p;
        this.init();
    }

    private void init() throws OwConfigurationException {
        this.baseURL = this.config.getSafeTextValue(BASE_URL, null);
        if (null == this.baseURL) {
            throw new OwConfigurationException("Missing BaseURL configuration.");
        }
        try {
            this.restFulFactory = new AlfrescoRESTFulFactory(this.baseURL, this.network);
        }
        catch (Exception e) {
            throw new OwConfigurationException("Could not create a RESTful factory instance.", (Throwable)e);
        }
    }

    public void refreshStaticClassdescriptions() throws Exception {
    }

    public boolean canRefreshStaticClassdescriptions() throws Exception {
        return false;
    }

    public OwObjectCollection doSearch(OwSearchNode searchCriteria_p, OwSort sortCriteria_p, Collection propertyNames_p, int iMaxSize_p, int iVersionSelection_p) throws Exception {
        return null;
    }

    public OwObject getObjectFromDMSID(String strDMSID_p, boolean fRefresh_p) throws Exception {
        return null;
    }

    public OwObject getObjectFromPath(String strPath_p, boolean fRefresh_p) throws Exception {
        return null;
    }

    public OwObjectClass getObjectClass(String strClassName_p, OwResource resource_p) throws Exception {
        return null;
    }

    public Map getObjectClassNames(int[] iTypes_p, boolean fExcludeHiddenAndNonInstantiable_p, boolean fRootOnly_p, OwResource resource_p) throws Exception {
        return null;
    }

    public OwResource getResource(String strID_p) throws Exception {
        return null;
    }

    public Iterator getResourceIDs() throws Exception {
        return null;
    }

    public OwEventManager getEventManager() {
        return null;
    }

    public String getDMSPrefix() {
        return null;
    }

    public void releaseResources() throws Exception {
    }

    public boolean canBatch() {
        return false;
    }

    public OwBatch openBatch() throws OwException {
        return null;
    }

    public void closeBatch(OwBatch batch_p) throws OwException {
    }

    public OwFieldDefinition getFieldDefinition(String strFieldDefinitionName_p, String strResourceName_p) throws Exception, OwObjectNotFoundException {
        return null;
    }

    public Collection getWildCardDefinitions(String strFieldDefinitionName_p, String strResourceName_p, int iOp_p) throws Exception {
        return null;
    }

    public Collection getWorkitemContainerIDs(boolean fRefresh_p, int iType_p) throws Exception {
        ArrayList<String> retNames = new ArrayList<String>();
        switch (iType_p) {
            case 8226: {
                retNames.add("Inbox");
            }
        }
        LOG.warn((Object)("Unknown type definition provided will return empty Collection, unknown value = " + iType_p));
        return retNames;
    }

    public OwWorkitemContainer getWorkitemContainer(String sID_p, int iType_p) throws Exception {
        switch (iType_p) {
            case 8226: {
                return new OwAlfrescoBPMUserQueueContainer(this.network, this, sID_p);
            }
        }
        String msg = "Object not found, Type = " + iType_p + ", ID = " + sID_p;
        LOG.error((Object)msg);
        throw new OwObjectNotFoundException(msg);
    }

    public String getWorkitemContainerName(String sID_p, int iType_p) throws Exception {
        return null;
    }

    public boolean hasContainer(int iType_p) throws Exception {
        return false;
    }

    public OwWorkitemRepository.OwProxyInfo createProxy() throws Exception, OwNotSupportedException {
        return null;
    }

    public void setProxies(Collection proxies_p, String absentpersonID_p) throws Exception, OwNotSupportedException {
    }

    public Collection getProxies(String absentpersonID_p) throws Exception, OwNotSupportedException {
        return null;
    }

    public boolean canProxy() {
        return true;
    }

    public Collection getLaunchableWorkflowDescriptions(Collection attachmentobjects_p) throws Exception {
        List<OwAlfrescoBPMWorkflowDescription> result = this.getDefaultWorkflowDescriptions();
        Collections.sort(result, new WorkflowDescriptionNameComparator());
        return result;
    }

    private List<OwAlfrescoBPMWorkflowDescription> getDefaultWorkflowDescriptions() throws OwRestException {
        WorkflowDefinitionsResource res = this.restFulFactory.workflowDefinitionsResource();
        try {
            WorkflowDefinitions wdefinitions = res.list();
            ArrayList<OwAlfrescoBPMWorkflowDescription> result = new ArrayList<OwAlfrescoBPMWorkflowDescription>();
            for (WorkflowDefinition definition : wdefinitions.data) {
                result.add(new OwAlfrescoBPMWorkflowDescription(definition, this));
            }
            ArrayList<OwAlfrescoBPMWorkflowDescription> arrayList = result;
            return arrayList;
        }
        catch (ResourceException resEx) {
            LOG.error((Object)res.getClientResource().getResponse().getEntityAsText());
            throw new OwRestException("Could not load workflow descriptions.", resEx);
        }
        finally {
            res.getClientResource().release();
        }
    }

    public OwWorkitem createLaunchableItem(OwWorkflowDescription workflowDescription_p, Collection attachmentobjects_p) throws Exception {
        OwAlfrescoBPMLaunchableWorkitemContainer workitemContainer = new OwAlfrescoBPMLaunchableWorkitemContainer(this.network, this);
        OwAlfrescoBPMWorkflowDescription alfrescoWFDescription = (OwAlfrescoBPMWorkflowDescription)workflowDescription_p;
        alfrescoWFDescription.load();
        return workitemContainer.createLaunchableWorkItem(alfrescoWFDescription, attachmentobjects_p);
    }

    public boolean canLaunch() {
        return true;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public OwNetworkContext getContext() {
        return this.network.getContext();
    }

    public AlfrescoRESTFulFactory getRestFulFactory() {
        return this.restFulFactory;
    }

    public OwNetwork getNetwork() {
        return this.network;
    }
}

