/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.alfresco.bpm;

import com.wewebu.ow.server.ecm.OwContentCollection;
import com.wewebu.ow.server.ecm.OwNetwork;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectClass;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwPermissionCollection;
import com.wewebu.ow.server.ecm.OwProperty;
import com.wewebu.ow.server.ecm.OwPropertyClass;
import com.wewebu.ow.server.ecm.OwPropertyCollection;
import com.wewebu.ow.server.ecm.OwResource;
import com.wewebu.ow.server.ecm.OwStandardProperty;
import com.wewebu.ow.server.ecm.OwStandardPropertyClass;
import com.wewebu.ow.server.ecm.OwStandardPropertyCollection;
import com.wewebu.ow.server.ecm.OwUserInfo;
import com.wewebu.ow.server.ecm.OwVersion;
import com.wewebu.ow.server.ecm.OwVersionSeries;
import com.wewebu.ow.server.ecm.bpm.OwWorkitem;
import com.wewebu.ow.server.ecm.bpm.OwWorkitemProcessorInfo;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.IfOwAlfrescoBPMWporkitemContainer;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMProcessorInfo;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMProperty;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMRepository;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMWorkItemObjectClass;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.classes.OwAlfrescoBPMObjectClass;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.log.OwLog;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.AlfrescoRESTFulFactory;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.OwRestException;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.TaskInstanceDetails;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.TaskInstanceEndResource;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.TaskInstanceResource;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.WorkflowInstanceResource;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.beans.TaskInstance;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.beans.WorkflowInstance;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.field.OwField;
import com.wewebu.ow.server.field.OwSearchNode;
import com.wewebu.ow.server.field.OwSearchTemplate;
import com.wewebu.ow.server.field.OwSort;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.OwString1;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.json.JSONObject;
import org.restlet.ext.json.JsonRepresentation;
import org.restlet.resource.ResourceException;

public class OwAlfrescoBPMWorkItem
implements OwWorkitem {
    private static final Logger LOG = OwLog.getLogger(OwAlfrescoBPMWorkItem.class);
    protected TaskInstance taskInstance;
    protected IfOwAlfrescoBPMWporkitemContainer container;
    protected OwAlfrescoBPMObjectClass objectClass;
    protected OwAlfrescoBPMRepository bpmRepository;
    protected Map<String, OwProperty> properties;
    protected Collection attachmentobjects;
    private transient boolean lock;

    public OwAlfrescoBPMWorkItem(TaskInstance taskInstance, IfOwAlfrescoBPMWporkitemContainer container, OwAlfrescoBPMRepository bpmRepository) throws OwException {
        this.taskInstance = taskInstance;
        this.container = container;
        this.bpmRepository = bpmRepository;
        try {
            OwNetwork network = container.getNetwork();
            OwObjectClass nativeClass = network.getObjectClass("D:" + this.taskInstance.getName(), null);
            this.objectClass = new OwAlfrescoBPMWorkItemObjectClass(nativeClass);
        }
        catch (Exception e) {
            throw new OwServerException("Could not get class for task instance!", (Throwable)e);
        }
        this.properties = new HashMap<String, OwProperty>();
    }

    public String getClassName() {
        return this.getObjectClass().getClassName();
    }

    public OwObjectClass getObjectClass() {
        return this.objectClass;
    }

    public OwObjectCollection getParents() throws Exception {
        return null;
    }

    public OwObjectCollection getChilds(int[] iObjectTypes_p, Collection propertyNames_p, OwSort sort_p, int iMaxSize_p, int iVersionSelection_p, OwSearchNode filterCriteria_p) throws Exception {
        return null;
    }

    public boolean hasChilds(int[] iObjectTypes_p, int iContext_p) throws Exception {
        return false;
    }

    public int getChildCount(int[] iObjectTypes_p, int iContext_p) throws Exception {
        return 0;
    }

    public void changeClass(String strNewClassName_p, OwPropertyCollection properties_p, OwPermissionCollection permissions_p) throws Exception {
    }

    public boolean canChangeClass() throws Exception {
        return false;
    }

    public boolean canFilterChilds() throws Exception {
        return false;
    }

    public Collection getFilterProperties(Collection propertynames_p) throws Exception {
        return null;
    }

    public OwVersionSeries getVersionSeries() throws Exception {
        return null;
    }

    public boolean hasVersionSeries() throws Exception {
        return false;
    }

    public OwVersion getVersion() throws Exception {
        return null;
    }

    public OwProperty getProperty(String strPropertyName_p) throws Exception {
        OwProperty property;
        if ("OW_ATTACHMENTS".equals(strPropertyName_p)) {
            Object[] array = null;
            if (null == this.attachmentobjects) {
                this.loadAttachments();
            }
            array = this.attachmentobjects.toArray();
            return new OwStandardProperty((Object)array, this.getObjectClass().getPropertyClass(strPropertyName_p));
        }
        if ("OW_TASK_TITLE".endsWith(strPropertyName_p)) {
            String title = this.taskInstance.getTitle();
            return new OwStandardProperty((Object)title, this.getObjectClass().getPropertyClass(strPropertyName_p));
        }
        String propertyClassName = this.getObjectClass().getPropertyClass(strPropertyName_p).getClassName();
        if (!this.properties.containsKey(propertyClassName)) {
            this.loadProperty(propertyClassName);
        }
        if (null == (property = this.properties.get(propertyClassName))) {
            throw new OwObjectNotFoundException("Property not found " + strPropertyName_p);
        }
        return property;
    }

    protected void loadAttachments() throws Exception {
        OwObject attachmentFolder = this.getAttachmentsFolder();
        OwObjectCollection existingAttachments = attachmentFolder.getChilds(new int[]{8193, 4097}, null, null, 100, 0, null);
        this.attachmentobjects = new ArrayList();
        this.attachmentobjects.addAll(existingAttachments);
    }

    private OwObject getAttachmentsFolder() throws Exception {
        OwProperty bpmPackage = this.getProperty("bpm:package");
        String bpmPackagePath = (String)bpmPackage.getValue();
        OwNetwork network = this.bpmRepository.getNetwork();
        String resourceId = network.getResource(null).getID();
        String dmsId = "cmis," + resourceId + "," + bpmPackagePath;
        OwObject attachmentFolder = network.getObjectFromDMSID(dmsId, true);
        return attachmentFolder;
    }

    private void loadProperty(String propertyClassName) throws OwException {
        try {
            OwPropertyClass propertyClass = this.getObjectClass().getPropertyClass(propertyClassName);
            Object nativeValue = this.loadPropertyValue(propertyClassName, propertyClass);
            OwAlfrescoBPMProperty property = new OwAlfrescoBPMProperty(nativeValue, propertyClass);
            this.properties.put(propertyClassName, property);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            LOG.error((Object)("Could not get property: " + propertyClassName), (Throwable)e);
            throw new OwServerException("Could not load property " + propertyClassName, (Throwable)e);
        }
    }

    protected Object loadPropertyValue(String strPropertyName_p, OwPropertyClass propertyClass) throws Exception {
        String translatedPropertyName = strPropertyName_p.replace(':', '_');
        Object nativeValue = null;
        Map<String, Object> taskProperties = this.taskInstance.getProperties();
        if (taskProperties.containsKey(translatedPropertyName)) {
            nativeValue = taskProperties.get(translatedPropertyName);
        } else {
            String translatedDotSplitName;
            String[] dotSplitPropertyName = strPropertyName_p.split("\\.");
            if (dotSplitPropertyName.length == 2 && taskProperties.containsKey(translatedDotSplitName = dotSplitPropertyName[1].replace(':', '_'))) {
                nativeValue = taskProperties.get(translatedDotSplitName);
            }
        }
        return nativeValue;
    }

    public OwPropertyCollection getProperties(Collection propertyNames_p) throws Exception {
        if (propertyNames_p == null) {
            OwObjectClass clazz = this.getObjectClass();
            propertyNames_p = clazz.getPropertyClassNames();
        }
        OwStandardPropertyCollection result = new OwStandardPropertyCollection();
        for (String propertyName : propertyNames_p) {
            OwProperty property = this.getProperty(propertyName);
            result.put((Object)propertyName, (Object)property);
        }
        return result;
    }

    public OwPropertyCollection getClonedProperties(Collection propertyNames_p) throws Exception {
        return OwStandardPropertyClass.getClonedProperties((OwObject)this, (Collection)propertyNames_p);
    }

    public void setProperties(OwPropertyCollection properties_p) throws Exception {
        Collection values = properties_p.values();
        for (OwProperty owProperty : values) {
            this.storeProperty(owProperty);
        }
        this.save();
    }

    private void storeProperty(OwProperty owProperty) throws Exception {
        String propertyClassName = owProperty.getPropertyClass().getClassName();
        if ("OW_ATTACHMENTS".equals(propertyClassName)) {
            Object[] array = (Object[])owProperty.getValue();
            if (null == array) {
                this.attachmentobjects = null;
            } else {
                this.attachmentobjects.clear();
                this.attachmentobjects.addAll(Arrays.asList(array));
            }
            return;
        }
        if ("OW_TASK_TITLE".equals(propertyClassName)) {
            return;
        }
        this.properties.put(propertyClassName, owProperty);
    }

    protected void save() throws Exception {
        AlfrescoRESTFulFactory restfulFactory = this.bpmRepository.getRestFulFactory();
        TaskInstanceResource resource = restfulFactory.taskInstanceResource(this.getID());
        try {
            Map<String, Object> parameters = this.prepareParameters();
            JSONObject jsonObject = new JSONObject(parameters);
            LOG.log((Priority)Level.INFO, (Object)jsonObject);
            TaskInstanceDetails updatedTaskInstance = resource.save(new JsonRepresentation(jsonObject));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("OwAlfrescoBPMWrokItem.save(): Props done, task-Id = " + updatedTaskInstance.data.getId()));
            }
            this.saveAttachments();
        }
        catch (ResourceException re) {
            LOG.error((Object)resource.getClientResource().getResponse().getEntityAsText());
            throw new OwRestException("Could not save workitem.", re);
        }
        finally {
            resource.getClientResource().release();
        }
    }

    protected void saveAttachments() throws Exception {
        if (null != this.attachmentobjects) {
            OwObject attachmentsFolder = this.getAttachmentsFolder();
            OwObjectCollection existingAttachments = attachmentsFolder.getChilds(new int[]{8193, 4097}, null, null, 100, 0, null);
            ArrayList attachmentsToDelete = new ArrayList(existingAttachments);
            attachmentsToDelete.removeAll(this.attachmentobjects);
            if (!attachmentsToDelete.isEmpty()) {
                for (Object element : attachmentsToDelete) {
                    OwObject owObject = (OwObject)element;
                    attachmentsFolder.removeReference(owObject);
                }
            }
            ArrayList attachmentsToBeAdded = new ArrayList(this.attachmentobjects);
            attachmentsToBeAdded.removeAll((Collection<?>)existingAttachments);
            if (!attachmentsToBeAdded.isEmpty()) {
                for (Object element : attachmentsToBeAdded) {
                    OwObject owObject = (OwObject)element;
                    attachmentsFolder.add(owObject);
                }
            }
        }
    }

    public void setProperties(OwPropertyCollection properties_p, Object mode_p) throws Exception {
        this.setProperties(properties_p);
    }

    public boolean canSetProperties(int iContext_p) throws Exception {
        return true;
    }

    public boolean canGetProperties(int iContext_p) throws Exception {
        return false;
    }

    public boolean canLock() throws Exception {
        return false;
    }

    public boolean setLock(boolean fLock_p) throws Exception {
        this.lock = fLock_p;
        return this.lock;
    }

    public boolean getLock(int iContext_p) throws Exception {
        return this.lock;
    }

    public boolean getMyLock(int iContext_p) throws Exception {
        return false;
    }

    public String getLockUserID(int iContext_p) throws Exception {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() throws Exception {
        String workflowInstanceId = this.taskInstance.getWorkflowInstance().getId();
        AlfrescoRESTFulFactory restFulFactory = this.bpmRepository.getRestFulFactory();
        WorkflowInstanceResource resource = restFulFactory.workflowInstance(workflowInstanceId);
        try {
            resource.delete();
        }
        finally {
            resource.getClientResource().release();
        }
    }

    public boolean canDelete(int iContext_p) throws Exception {
        return true;
    }

    public void removeReference(OwObject oObject_p) throws Exception {
    }

    public boolean canRemoveReference(OwObject oObject_p, int iContext_p) throws Exception {
        return false;
    }

    public void add(OwObject oObject_p) throws Exception {
    }

    public boolean canAdd(OwObject oObject_p, int iContext_p) throws Exception {
        return false;
    }

    public void move(OwObject oObject_p, OwObject oldParent_p) throws Exception {
    }

    public boolean canMove(OwObject oObject_p, OwObject oldParent_p, int iContext_p) throws Exception {
        return false;
    }

    public OwSearchTemplate getSearchTemplate() throws Exception {
        return null;
    }

    public Collection getColumnInfoList() throws Exception {
        return null;
    }

    public OwResource getResource() throws Exception {
        return null;
    }

    public OwPermissionCollection getPermissions() throws Exception {
        return null;
    }

    public OwPermissionCollection getClonedPermissions() throws Exception {
        return null;
    }

    public boolean canGetPermissions() throws Exception {
        return false;
    }

    public boolean canSetPermissions() throws Exception {
        return false;
    }

    public void setPermissions(OwPermissionCollection permissions_p) throws Exception {
    }

    public OwContentCollection getContentCollection() throws Exception {
        return null;
    }

    public void setContentCollection(OwContentCollection content_p) throws Exception {
    }

    public boolean canSetContent(int iContentType_p, int iContext_p) throws Exception {
        return false;
    }

    public boolean canGetContent(int iContentType_p, int iContext_p) throws Exception {
        return false;
    }

    public void refreshProperties() throws Exception {
    }

    public void refreshProperties(Collection props_p) throws Exception {
    }

    public Object getNativeObject() throws Exception {
        return null;
    }

    public String getPath() throws Exception {
        return null;
    }

    public String getResourceID() throws Exception {
        return null;
    }

    public OwObject getInstance() throws Exception {
        return this;
    }

    public String getName() {
        try {
            String title = (String)this.getProperty("OW_TASK_TITLE").getValue();
            String description = (String)this.getProperty("bpm:description").getValue();
            String name = String.format("%s (%s)", title, description);
            return name;
        }
        catch (Exception e) {
            return "[undef]";
        }
    }

    public String getID() {
        return this.taskInstance.getId();
    }

    public int getType() {
        return 16385;
    }

    public String getDMSID() throws Exception {
        return this.taskInstance.getId();
    }

    public int getPageCount() throws Exception {
        return 0;
    }

    public String getMIMEType() throws Exception {
        return this.container.createContaineeMIMEType(this);
    }

    public String getMIMEParameter() throws Exception {
        return this.container.createContaineeMIMEParameter(this);
    }

    public boolean hasContent(int iContext_p) throws Exception {
        return false;
    }

    public OwField getField(String strFieldClassName_p) throws Exception, OwObjectNotFoundException {
        return null;
    }

    public void setField(String sName_p, Object value_p) throws Exception, OwObjectNotFoundException {
    }

    public Object getSafeFieldValue(String sName_p, Object defaultvalue_p) {
        return null;
    }

    public Collection getFields() throws Exception {
        return null;
    }

    public int getFieldProviderType() {
        return 0;
    }

    public Object getFieldProviderSource() {
        return null;
    }

    public String getFieldProviderName() {
        return null;
    }

    public OwWorkitemProcessorInfo getStepProcessorInfo() throws OwObjectNotFoundException {
        String strJspPage = "";
        try {
            strJspPage = this.getProperty("owdbpm:jspStepProcessor").getValue().toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (strJspPage.length() == 0) {
            return new OwAlfrescoBPMProcessorInfo(this);
        }
        return new OwAlfrescoBPMProcessorInfo(this, strJspPage);
    }

    public void setResponse(String strResponse_p) throws Exception {
    }

    public boolean canResponse() {
        return false;
    }

    public String getResponse() throws Exception {
        return null;
    }

    public Collection getResponses() throws Exception {
        return null;
    }

    public void forcedelete() throws Exception {
    }

    public boolean canForcedelete(int iContext_p) throws Exception {
        return false;
    }

    public void dispatch() throws Exception {
        AlfrescoRESTFulFactory restfulFactory = this.bpmRepository.getRestFulFactory();
        TaskInstanceEndResource resource = restfulFactory.taskInstanceEndResource(this.getID());
        try {
            resource.end();
        }
        catch (ResourceException re) {
            LOG.error((Object)resource.getClientResource().getResponse().getEntityAsText());
            throw new OwRestException("Could not end task.", re);
        }
        finally {
            resource.getClientResource().release();
        }
    }

    public boolean canDispatch(int iContext_p) throws Exception {
        return true;
    }

    public void returnToSource() throws Exception {
    }

    public boolean canReturnToSource(int iContext_p) throws Exception {
        return false;
    }

    public void reassignToPublicContainer(String containername_p, boolean delegateFlag_p) throws Exception {
    }

    public void reassignToUserContainer(String participant_p, boolean delegateFlag_p) throws Exception {
        if (delegateFlag_p) {
            throw new OwInvalidOperationException("Task delegation is not implemented yet.");
        }
        OwUserInfo toUser = this.bpmRepository.getNetwork().getUserFromID(participant_p);
        OwProperty cmOwner = this.getProperty("P:cm:ownable.cm:owner");
        cmOwner.setValue((Object)toUser.getUserName());
        OwStandardPropertyCollection newProperties = new OwStandardPropertyCollection();
        newProperties.put((Object)cmOwner.getPropertyClass(), (Object)cmOwner);
        this.setProperties((OwPropertyCollection)newProperties);
    }

    public boolean canReassignToPublicContainer(int iContext_p) throws Exception {
        return false;
    }

    public boolean canReassignToUserContainer(int iContext_p) throws Exception {
        return this.taskInstance.isReassignable();
    }

    public void resubmit(Date date_p) throws Exception {
        if (!this.canResubmit(2)) {
            throw new OwConfigurationException("This item does not support resubmission.");
        }
        try {
            OwStandardPropertyCollection properties = new OwStandardPropertyCollection();
            OwProperty resubmitProperty = this.getProperty("owdbpm:resubmissionDate");
            resubmitProperty.setValue((Object)date_p);
            properties.put((Object)resubmitProperty.getPropertyClass().getClassName(), (Object)resubmitProperty);
            this.setProperties((OwPropertyCollection)properties);
        }
        catch (OwObjectNotFoundException e) {
            LOG.error((Object)("No exposed resubmit property defined: owdbpm:resubmissionDate in workitem: " + this.getName()), (Throwable)e);
            throw new OwConfigurationException((OwString)new OwString1("ecmimpl.fncm.bpm.resubmissioninvalid", "The work item allows no resubmission. Probably the queue is not configured with this property (%1).", "owdbpm:resubmissionDate"), (Throwable)e);
        }
    }

    public boolean canResubmit(int iContext_p) throws Exception {
        try {
            OwProperty resubmitProp = this.getProperty("owdbpm:resubmissionDate");
            return !resubmitProp.isReadOnly(2);
        }
        catch (OwObjectNotFoundException e) {
            return false;
        }
    }

    public Date getResubmitDate(int iContext_p) throws Exception {
        try {
            OwProperty resubmitProperty = this.getProperty("owdbpm:resubmissionDate");
            Date resdate = (Date)resubmitProperty.getValue();
            if (resdate == null || resdate.getTime() <= new Date().getTime()) {
                return null;
            }
            return resdate;
        }
        catch (OwObjectNotFoundException e) {
            return null;
        }
    }

    public String toString() {
        return this.taskInstance.toString();
    }

    protected String shrinkPropertyName(String longPropertyName) {
        String[] dotSplitPropertyName = longPropertyName.split("\\.");
        if (dotSplitPropertyName.length == 2) {
            return dotSplitPropertyName[1].replace(':', '_');
        }
        return longPropertyName;
    }

    protected Map<String, Object> prepareParameters() throws Exception {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        Set<String> propertyNames = this.properties.keySet();
        for (String propName : propertyNames) {
            OwProperty property = this.properties.get(propName);
            boolean isUpdatable = !property.isReadOnly(2) && !property.getPropertyClass().isReadOnly(2) && !property.getPropertyClass().isSystemProperty();
            boolean isCmOwner = property.getPropertyClass().getClassName().equals("cm:owner");
            if (!isCmOwner && !isUpdatable) continue;
            String translatedPropName = this.shrinkPropertyName(propName);
            Object value = property.getNativeObject();
            parameters.put(translatedPropName, value);
        }
        return parameters;
    }

    public String getWorkflowInstanceId() {
        WorkflowInstance workflowInstance = this.taskInstance.getWorkflowInstance();
        if (null != workflowInstance) {
            return workflowInstance.getId();
        }
        return null;
    }
}

