/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.alfresco.bpm;

import com.wewebu.ow.server.ecm.bpm.OwWorkflowDescription;
import com.wewebu.ow.server.ecm.bpm.OwWorkitemProcessorInfo;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMRepository;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.log.OwLog;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.AlfrescoRESTFulFactory;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.OwRestException;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.WorkflowDefinitionDetails;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.WorkflowDefinitionDetailsResource;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.beans.WorkflowDefinition;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import org.apache.log4j.Logger;
import org.restlet.resource.ResourceException;

public class OwAlfrescoBPMWorkflowDescription
implements OwWorkflowDescription {
    private static final Logger LOG = OwLog.getLogger(OwAlfrescoBPMWorkflowDescription.class);
    private WorkflowDefinition wfDefinition;
    private OwAlfrescoBPMRepository bpmRepository;

    public OwAlfrescoBPMWorkflowDescription(WorkflowDefinition wfDefinition, OwAlfrescoBPMRepository bpmRepository) {
        this.wfDefinition = wfDefinition;
        this.bpmRepository = bpmRepository;
    }

    public OwWorkitemProcessorInfo getStepProcessorInfo() throws OwObjectNotFoundException {
        return null;
    }

    public String getId() {
        return this.wfDefinition.getId();
    }

    public String getName() {
        return this.wfDefinition.getTitle();
    }

    public String toString() {
        return this.wfDefinition.toString();
    }

    public String getStartTaskDefinitionType() {
        return this.wfDefinition.getStartTaskDefinitionType();
    }

    public void load() throws OwException {
        AlfrescoRESTFulFactory restfulFactory = this.bpmRepository.getRestFulFactory();
        WorkflowDefinitionDetailsResource res = restfulFactory.workflowDefinitionDetailsResource(this.getId());
        try {
            WorkflowDefinitionDetails details = res.get();
            this.wfDefinition = details.data;
        }
        catch (ResourceException resEx) {
            LOG.error((Object)res.getClientResource().getResponse().getEntityAsText());
            throw new OwRestException("Could not load WorkflowDescription details.", resEx);
        }
        finally {
            res.getClientResource().release();
        }
    }
}

