/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.alfresco.bpm;

import com.wewebu.ow.server.ecm.OwNetwork;
import com.wewebu.ow.server.ecm.OwNetworkContext;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwStandardObjectCollection;
import com.wewebu.ow.server.ecm.OwStatusContextException;
import com.wewebu.ow.server.ecm.bpm.OwWorkitem;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMBaseContainer;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMRepository;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.OwAlfrescoBPMWorkItem;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.log.OwLog;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.field.OwFieldColumnInfo;
import com.wewebu.ow.server.field.OwFieldDefinition;
import com.wewebu.ow.server.field.OwSearchNode;
import com.wewebu.ow.server.field.OwSort;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class OwAlfrescoBPMWorkitemContainer
extends OwAlfrescoBPMBaseContainer {
    private static final Logger LOG = OwLog.getLogger(OwAlfrescoBPMWorkitemContainer.class);
    public static final String ID_QUEUE_INBOX = "Inbox";
    protected String id;

    public OwAlfrescoBPMWorkitemContainer(OwNetwork network, OwAlfrescoBPMRepository bpmRepository, String sID_p) {
        super(network, bpmRepository);
        this.bpmRepository = bpmRepository;
        this.id = sID_p;
    }

    @Override
    public String createContaineeMIMEType(OwAlfrescoBPMWorkItem item) {
        return "ow_workitem/item";
    }

    @Override
    public String createContaineeMIMEParameter(OwAlfrescoBPMWorkItem item) {
        return "";
    }

    protected OwNetworkContext getBPMRepositoryContext() {
        return this.bpmRepository.getContext();
    }

    public String getName() {
        return this.id;
    }

    public String getID() {
        return this.id;
    }

    @Override
    public OwWorkitem pull(OwSort sort_p, Set exclude_p) throws Exception, OwObjectNotFoundException, OwServerException {
        OwObjectCollection children = this.getChilds(new int[]{16384}, null, sort_p, 1, 0, null);
        if (children.isEmpty()) {
            String message = this.getNetwork().getContext().localize("plug.owbpm.OwBPMPullFunction.pullfailed", "There is no work item to edit.");
            LOG.error((Object)message);
            throw new OwObjectNotFoundException(message);
        }
        return (OwWorkitem)children.get(0);
    }

    @Override
    public boolean canPull(int iContext_p) throws Exception, OwStatusContextException {
        return true;
    }

    @Override
    public Collection getFilterProperties(Collection columnsInfo_p) throws Exception {
        ArrayList<OwFieldDefinition> filterProperties = new ArrayList<OwFieldDefinition>();
        for (Object objColumnInfo : columnsInfo_p) {
            OwFieldColumnInfo columnInfo = (OwFieldColumnInfo)objColumnInfo;
            String propertyName = columnInfo.getPropertyName();
            if (!propertyName.endsWith("bpm:dueDate")) continue;
            OwFieldDefinition fieldDefinition = this.network.getFieldDefinition(propertyName, null);
            filterProperties.add(fieldDefinition);
        }
        return filterProperties;
    }

    public boolean canResubmit() throws Exception {
        return true;
    }

    public OwObjectCollection getChilds(int[] iObjectTypes_p, Collection propertyNames_p, OwSort sort_p, int iMaxSize_p, int iVersionSelection_p, OwSearchNode filterCriteria_p) throws Exception {
        OwStandardObjectCollection result;
        block9: {
            Date now;
            int fType;
            block8: {
                HashSet<Integer> types = new HashSet<Integer>();
                for (int i = 0; i < iObjectTypes_p.length; ++i) {
                    types.add(iObjectTypes_p[i]);
                }
                result = new OwStandardObjectCollection();
                for (Integer type : types) {
                    switch (type) {
                        case 16384: 
                        case 16385: {
                            result.addAll(this.getChildren(filterCriteria_p, iMaxSize_p));
                        }
                    }
                }
                if (null != sort_p) {
                    result.sort(sort_p);
                }
                if ((fType = this.getFilterType()) != 3) break block8;
                now = new Date();
                OwStandardObjectCollection copy = new OwStandardObjectCollection();
                copy.addAll((Collection)result);
                for (Object object : copy) {
                    OwWorkitem item = (OwWorkitem)object;
                    Date resubmitDate = item.getResubmitDate(2);
                    if (null == resubmitDate || !resubmitDate.after(now)) continue;
                    result.remove((Object)item);
                }
                break block9;
            }
            if (fType != 1) break block9;
            now = new Date();
            OwStandardObjectCollection copy = new OwStandardObjectCollection();
            copy.addAll((Collection)result);
            for (Object object : copy) {
                OwWorkitem item = (OwWorkitem)object;
                Date resubmitDate = item.getResubmitDate(2);
                if (null != resubmitDate && !resubmitDate.before(now)) continue;
                result.remove((Object)item);
            }
        }
        return result;
    }

    public int getChildCount(int[] iObjectTypes_p, int iContext_p) throws Exception {
        HashSet<Integer> types = new HashSet<Integer>();
        for (int i = 0; i < iObjectTypes_p.length; ++i) {
            types.add(iObjectTypes_p[i]);
        }
        int count = 0;
        for (Integer type : types) {
            switch (type) {
                case 16384: 
                case 16385: {
                    count += this.getChildren(null, -1).size();
                }
            }
        }
        return count;
    }

    protected abstract List<OwAlfrescoBPMWorkItem> getChildren(OwSearchNode var1, int var2) throws Exception;
}

