/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest;

import com.wewebu.ow.server.ecm.OwCredentials;
import com.wewebu.ow.server.ecm.OwNetwork;
import com.wewebu.ow.server.ecm.OwNetworkContext;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.OwRestException;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.StartWorkflowResource;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.TaskInstanceEndResource;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.TaskInstanceResource;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.TaskInstancesResource;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.WorkflowDefinitionDetailsResource;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.WorkflowDefinitionsResource;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.WorkflowInstanceResource;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.beans.WorkflowStatus;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.converters.NativeValueConverter;
import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.converters.NativeValueConverterFactoryRest;
import com.wewebu.ow.server.field.OwFieldDefinition;
import com.wewebu.ow.server.field.OwSearchCriteria;
import com.wewebu.ow.server.field.OwSearchNode;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Uniform;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Form;
import org.restlet.data.Language;
import org.restlet.data.Metadata;
import org.restlet.data.Parameter;
import org.restlet.data.Preference;
import org.restlet.resource.ClientResource;

public class AlfrescoRESTFulFactory {
    private String baseURL;
    private OwNetwork network;
    private NativeValueConverterFactoryRest converterFactory;
    private ArrayList<Preference<Language>> acceptedLanguages;

    public AlfrescoRESTFulFactory(String baseURL, OwNetwork network) {
        this.baseURL = baseURL;
        this.network = network;
        this.converterFactory = new NativeValueConverterFactoryRest();
        OwNetworkContext ctx = this.network.getContext();
        Locale currentLocale = ctx.getLocale();
        Language language = Language.valueOf((String)currentLocale.getLanguage());
        Preference currentLanguage = new Preference((Metadata)language);
        this.acceptedLanguages = new ArrayList();
        this.acceptedLanguages.add((Preference<Language>)currentLanguage);
    }

    public WorkflowDefinitionsResource workflowDefinitionsResource() throws OwRestException {
        return this.createResourceFor(this.baseURL + "/service/api/workflow-definitions", WorkflowDefinitionsResource.class);
    }

    public WorkflowDefinitionDetailsResource workflowDefinitionDetailsResource(String wfDefinitionId) throws OwRestException {
        String wfDefinitionIdEncoded;
        try {
            wfDefinitionIdEncoded = URLEncoder.encode(wfDefinitionId, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new OwRestException("Could not encode the workflow definition ID!", e);
        }
        String uri = String.format("%s/service/api/workflow-definitions/%s", this.baseURL, wfDefinitionIdEncoded);
        return this.createResourceFor(uri, WorkflowDefinitionDetailsResource.class);
    }

    public StartWorkflowResource startWorkflowResource(String definitionId) throws OwRestException {
        String definitionIdEncoded = null;
        try {
            definitionIdEncoded = URLEncoder.encode(definitionId, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new OwRestException("Could not encode the workflow definition ID!", e);
        }
        String resourceUri = String.format("%s/service/ow/api/workflow-definitions/%s/start", this.baseURL, definitionIdEncoded);
        return this.createResourceFor(resourceUri, StartWorkflowResource.class);
    }

    public TaskInstancesResource taskInstancesResource(String owner, WorkflowStatus status, OwSearchNode filterCriteria_p, int iMaxSize_p) throws OwRestException {
        String resourceURI;
        Form form = new Form();
        form.add((Object)new Parameter("authority", owner));
        form.add((Object)new Parameter("state", status.toString()));
        if (iMaxSize_p >= 0) {
            form.add((Object)new Parameter("maxItems", Integer.toString(iMaxSize_p)));
        }
        try {
            if (null != filterCriteria_p) {
                if (filterCriteria_p.getOperator() != 1) {
                    throw new OwRestException("Only simple filters combined with the AND operator are supported for the moment.");
                }
                block9: for (Object objSearchNode : filterCriteria_p.getChilds()) {
                    Date dateValue;
                    OwSearchNode searchNode = (OwSearchNode)objSearchNode;
                    OwSearchCriteria criteria = searchNode.getCriteria();
                    OwFieldDefinition fieldDefinition = criteria.getFieldDefinition();
                    String propClassName = fieldDefinition.getClassName();
                    int operator = criteria.getOperator();
                    if (!propClassName.endsWith("bpm:dueDate") || null == (dateValue = (Date)criteria.getValue())) continue;
                    NativeValueConverter converter = this.converterFactory.converterFor(fieldDefinition);
                    String date = (String)converter.fromJava(dateValue);
                    switch (operator) {
                        case 10: 
                        case 14: {
                            form.add((Object)new Parameter("dueBefore", date));
                            continue block9;
                        }
                        case 8: 
                        case 12: {
                            form.add((Object)new Parameter("dueAfter", date));
                            continue block9;
                        }
                    }
                    throw new OwRestException("This operator is not yet supported for this property.");
                }
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new OwRestException("Could not process search filter.", e);
        }
        try {
            resourceURI = String.format("%s/service/api/task-instances?%s", this.baseURL, form.encode());
        }
        catch (IOException e) {
            throw new OwRestException("Could not encode query parameters.", e);
        }
        TaskInstancesResource result = this.createResourceFor(resourceURI, TaskInstancesResource.class);
        return result;
    }

    public TaskInstancesResource taskInstancesForWorkflowResource(String workflowId) throws OwRestException {
        String resourceURI = String.format("%s/service/api/workflow-instances/%s/task-instances", this.baseURL, workflowId);
        return this.createResourceFor(resourceURI, TaskInstancesResource.class);
    }

    public WorkflowInstanceResource workflowInstance(String workflowInstanceId) throws OwRestException {
        String resourceURI = String.format("%s/service/api/workflow-instances/%s?forced=true", this.baseURL, workflowInstanceId);
        return this.createResourceFor(resourceURI, WorkflowInstanceResource.class);
    }

    public TaskInstanceResource taskInstanceResource(String taskInstanceId) throws OwRestException {
        String taskInstanceIdEncoded = null;
        try {
            taskInstanceIdEncoded = URLEncoder.encode(taskInstanceId, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new OwRestException("Could not encode the workflow definition ID!", e);
        }
        String resourceUri = String.format("%s/service/api/task-instances/%s", this.baseURL, taskInstanceIdEncoded);
        return this.createResourceFor(resourceUri, TaskInstanceResource.class);
    }

    public TaskInstanceEndResource taskInstanceEndResource(String taskInstanceId) throws OwRestException {
        String taskInstanceIdEncoded = null;
        try {
            taskInstanceIdEncoded = URLEncoder.encode(taskInstanceId, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new OwRestException("Could not encode the workflow definition ID!", e);
        }
        String resourceUri = String.format("%s/service/api/workflow/task/end/%s", this.baseURL, taskInstanceIdEncoded);
        return this.createResourceFor(resourceUri, TaskInstanceEndResource.class);
    }

    private String getPasswd() throws OwRestException {
        try {
            OwCredentials credentials = this.network.getCredentials();
            return credentials.getAuthInfo("Password");
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new OwRestException("Could not get user password!", e);
        }
    }

    private String getUserName() throws OwRestException {
        try {
            OwCredentials credentials = this.network.getCredentials();
            return credentials.getAuthInfo("USER");
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new OwRestException("Could not get user ID!", e);
        }
    }

    private <T> T createResourceFor(String resourceURI, Class<T> wrappedClass) throws OwRestException {
        ClientResource cr = new ClientResource(resourceURI);
        cr.setChallengeResponse(ChallengeScheme.HTTP_BASIC, this.getUserName(), this.getPasswd());
        cr.getConverterService().setEnabled(true);
        Object resource = cr.wrap(wrappedClass);
        final Uniform originalNext = cr.getNext();
        cr.setNext(new Uniform(){

            public void handle(Request request, Response response) {
                request.getClientInfo().setAcceptedLanguages((List)AlfrescoRESTFulFactory.this.acceptedLanguages);
                if (null != originalNext) {
                    originalNext.handle(request, response);
                }
            }
        });
        cr.getClientInfo().setAcceptedLanguages(this.acceptedLanguages);
        return (T)resource;
    }
}

