/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.converters;

import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.converters.NativeValueConverter;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwServerException;
import java.util.ArrayList;

public class ArrayAgregateConverter
implements NativeValueConverter {
    private NativeValueConverter singleValueConverter;

    public ArrayAgregateConverter(NativeValueConverter singleValueConverter) {
        this.singleValueConverter = singleValueConverter;
    }

    @Override
    public Object fromNative(Object nativeValue) throws OwException {
        Object[] arrayValue;
        if (null == nativeValue) {
            return null;
        }
        if (!nativeValue.getClass().isArray()) {
            if (String.class == nativeValue.getClass() && 0 == ((String)nativeValue).length()) {
                return null;
            }
            throw new OwServerException("The native value must be of Array type.");
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object nativeObject : arrayValue = (Object[])nativeValue) {
            Object javaObject = this.singleValueConverter.fromNative(nativeObject);
            result.add(javaObject);
        }
        return result.toArray();
    }

    @Override
    public Object fromJava(Object javaValue) throws OwException {
        Object[] arrayValue;
        if (null == javaValue) {
            return null;
        }
        if (!javaValue.getClass().isArray()) {
            throw new OwServerException("The java value must be of Array type.");
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object javaObject : arrayValue = (Object[])javaValue) {
            Object nativeObject = this.singleValueConverter.fromJava(javaObject);
            result.add(nativeObject);
        }
        return result.toArray();
    }
}

