/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.converters;

import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.converters.NativeValueConverter;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwServerException;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class DateNativeValueConverter
implements NativeValueConverter {
    @Override
    public Object fromNative(Object nativeValue) throws OwException {
        try {
            String strNative = (String)nativeValue;
            XMLGregorianCalendar xmlDate = DatatypeFactory.newInstance().newXMLGregorianCalendar(strNative);
            return xmlDate.toGregorianCalendar().getTime();
        }
        catch (DatatypeConfigurationException e) {
            throw new OwServerException("Could not get java value from native value " + nativeValue, (Throwable)e);
        }
    }

    @Override
    public Object fromJava(Object javaValue) throws OwException {
        try {
            Date dateValue = (Date)javaValue;
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(dateValue);
            XMLGregorianCalendar xmlDate = DatatypeFactory.newInstance().newXMLGregorianCalendar(cal);
            return xmlDate.toXMLFormat();
        }
        catch (DatatypeConfigurationException e) {
            throw new OwServerException("Could not get native value from java value " + javaValue, (Throwable)e);
        }
    }
}

