/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.converters;

import com.wewebu.ow.server.ecmimpl.alfresco.bpm.rest.converters.NativeValueConverter;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.field.OwFieldDefinition;

public class DefaultNativeValueConverter
implements NativeValueConverter {
    private OwFieldDefinition propertyClass;

    public DefaultNativeValueConverter(OwFieldDefinition propertyClass) {
        this.propertyClass = propertyClass;
    }

    @Override
    public Object fromNative(Object nativeValue) throws OwException {
        if (null == nativeValue) {
            return null;
        }
        Object value = nativeValue;
        try {
            Class<?> propertyJavaClass = Class.forName(this.propertyClass.getJavaClassName());
            Class<?> propertyValueClass = nativeValue.getClass();
            if ((!propertyJavaClass.isAssignableFrom(propertyValueClass) || this.propertyClass.isArray()) && String.class.isAssignableFrom(propertyValueClass) && !this.propertyClass.isArray()) {
                value = this.propertyClass.getValueFromString((String)nativeValue);
            }
            return value;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new OwServerException("Could not convert native value to java value.", (Throwable)e);
        }
    }

    @Override
    public Object fromJava(Object javaValue) {
        if (null != javaValue) {
            return javaValue.toString();
        }
        return null;
    }
}

