/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.utils.resolver.implementations;

import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.utils.IdResolver;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverException;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverSpi;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ResolverFragment
extends ResourceResolverSpi {
    static Logger log = Logger.getLogger(ResolverFragment.class.getName());

    public boolean engineIsThreadSafe() {
        return true;
    }

    public XMLSignatureInput engineResolve(Attr attr, String string2) throws ResourceResolverException {
        Object object;
        String string3 = attr.getNodeValue();
        Document document = attr.getOwnerElement().getOwnerDocument();
        Node node = null;
        if (string3.equals("")) {
            log.log(Level.FINE, "ResolverFragment with empty URI (means complete document)");
            node = document;
        } else {
            object = string3.substring(1);
            node = IdResolver.getElementById(document, (String)object);
            if (node == null) {
                Object[] objectArray = new Object[]{object};
                throw new ResourceResolverException("signature.Verification.MissingID", objectArray, attr, string2);
            }
            log.log(Level.FINE, "Try to catch an Element with ID " + (String)object + " and Element was " + node);
        }
        object = new XMLSignatureInput(node);
        ((XMLSignatureInput)object).setExcludeComments(true);
        ((XMLSignatureInput)object).setMIMEType("text/xml");
        ((XMLSignatureInput)object).setSourceURI(string2 != null ? string2.concat(attr.getNodeValue()) : attr.getNodeValue());
        return object;
    }

    public boolean engineCanResolve(Attr attr, String string2) {
        if (attr == null) {
            log.log(Level.FINE, "Quick fail for null uri");
            return false;
        }
        String string3 = attr.getNodeValue();
        if (string3.equals("") || string3.charAt(0) == '#' && (string3.charAt(1) != 'x' || !string3.startsWith("#xpointer("))) {
            log.log(Level.FINE, "State I can resolve reference: \"" + string3 + "\"");
            return true;
        }
        log.log(Level.FINE, "Do not seem to be able to resolve reference: \"" + string3 + "\"");
        return false;
    }
}

