/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.wsdl.document;

import com.sun.xml.rpc.wsdl.document.Binding;
import com.sun.xml.rpc.wsdl.document.Documentation;
import com.sun.xml.rpc.wsdl.document.Import;
import com.sun.xml.rpc.wsdl.document.Message;
import com.sun.xml.rpc.wsdl.document.PortType;
import com.sun.xml.rpc.wsdl.document.Service;
import com.sun.xml.rpc.wsdl.document.Types;
import com.sun.xml.rpc.wsdl.document.WSDLConstants;
import com.sun.xml.rpc.wsdl.document.WSDLDocumentVisitor;
import com.sun.xml.rpc.wsdl.framework.AbstractDocument;
import com.sun.xml.rpc.wsdl.framework.Defining;
import com.sun.xml.rpc.wsdl.framework.DuplicateEntityException;
import com.sun.xml.rpc.wsdl.framework.Entity;
import com.sun.xml.rpc.wsdl.framework.EntityAction;
import com.sun.xml.rpc.wsdl.framework.ExtensibilityHelper;
import com.sun.xml.rpc.wsdl.framework.Extensible;
import com.sun.xml.rpc.wsdl.framework.Extension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;

public class Definitions
extends Entity
implements Defining,
Extensible {
    private AbstractDocument _document;
    private ExtensibilityHelper _helper;
    private Documentation _documentation;
    private String _name;
    private String _targetNsURI;
    private Types _types;
    private List _messages;
    private List _portTypes;
    private List _bindings;
    private List _services;
    private List _imports;
    private Set _importedNamespaces;

    public Definitions(AbstractDocument document) {
        this._document = document;
        this._bindings = new ArrayList();
        this._imports = new ArrayList();
        this._messages = new ArrayList();
        this._portTypes = new ArrayList();
        this._services = new ArrayList();
        this._importedNamespaces = new HashSet();
        this._helper = new ExtensibilityHelper();
    }

    public String getName() {
        return this._name;
    }

    public void setName(String s) {
        this._name = s;
    }

    public String getTargetNamespaceURI() {
        return this._targetNsURI;
    }

    public void setTargetNamespaceURI(String s) {
        this._targetNsURI = s;
    }

    public void setTypes(Types t) {
        this._types = t;
    }

    public Types getTypes() {
        return this._types;
    }

    public void add(Message m) {
        try {
            this._document.define(m);
        }
        catch (DuplicateEntityException e) {
            return;
        }
        this._messages.add(m);
    }

    public void add(PortType p) {
        try {
            this._document.define(p);
        }
        catch (DuplicateEntityException e) {
            return;
        }
        this._portTypes.add(p);
    }

    public void add(Binding b) {
        try {
            this._document.define(b);
        }
        catch (DuplicateEntityException e) {
            return;
        }
        this._bindings.add(b);
    }

    public void add(Service s) {
        try {
            this._document.define(s);
        }
        catch (DuplicateEntityException e) {
            return;
        }
        this._services.add(s);
    }

    public void addServiceOveride(Service s) {
        this._services.add(s);
    }

    public void add(Import i) {
        if (this._importedNamespaces.contains(i.getNamespace())) {
            throw new DuplicateEntityException(i, i.getNamespace());
        }
        this._imports.add(i);
    }

    public Iterator imports() {
        return this._imports.iterator();
    }

    public Iterator messages() {
        return this._messages.iterator();
    }

    public Iterator portTypes() {
        return this._portTypes.iterator();
    }

    public Iterator bindings() {
        return this._bindings.iterator();
    }

    public Iterator services() {
        return this._services.iterator();
    }

    public QName getElementName() {
        return WSDLConstants.QNAME_DEFINITIONS;
    }

    public Documentation getDocumentation() {
        return this._documentation;
    }

    public void setDocumentation(Documentation d) {
        this._documentation = d;
    }

    public void addExtension(Extension e) {
        this._helper.addExtension(e);
    }

    public Iterator extensions() {
        return this._helper.extensions();
    }

    public void withAllSubEntitiesDo(EntityAction action) {
        if (this._types != null) {
            action.perform(this._types);
        }
        Iterator iter = this._messages.iterator();
        while (iter.hasNext()) {
            action.perform((Entity)iter.next());
        }
        iter = this._portTypes.iterator();
        while (iter.hasNext()) {
            action.perform((Entity)iter.next());
        }
        iter = this._bindings.iterator();
        while (iter.hasNext()) {
            action.perform((Entity)iter.next());
        }
        iter = this._services.iterator();
        while (iter.hasNext()) {
            action.perform((Entity)iter.next());
        }
        iter = this._imports.iterator();
        while (iter.hasNext()) {
            action.perform((Entity)iter.next());
        }
        this._helper.withAllSubEntitiesDo(action);
    }

    public void accept(WSDLDocumentVisitor visitor) throws Exception {
        visitor.preVisit(this);
        Iterator iter = this._imports.iterator();
        while (iter.hasNext()) {
            ((Import)iter.next()).accept(visitor);
        }
        if (this._types != null) {
            this._types.accept(visitor);
        }
        iter = this._messages.iterator();
        while (iter.hasNext()) {
            ((Message)iter.next()).accept(visitor);
        }
        iter = this._portTypes.iterator();
        while (iter.hasNext()) {
            ((PortType)iter.next()).accept(visitor);
        }
        iter = this._bindings.iterator();
        while (iter.hasNext()) {
            ((Binding)iter.next()).accept(visitor);
        }
        iter = this._services.iterator();
        while (iter.hasNext()) {
            ((Service)iter.next()).accept(visitor);
        }
        this._helper.accept(visitor);
        visitor.postVisit(this);
    }

    public void validateThis() {
    }
}

