/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.gmbal.generic;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.glassfish.gmbal.generic.Graph;
import org.glassfish.gmbal.generic.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassAnalyzer {
    private static final Graph.Finder<Class<?>> finder = new Graph.Finder<Class<?>>(){

        @Override
        public List<Class<?>> evaluate(Class<?> arg) {
            ArrayList result = new ArrayList();
            Class<?> sclass = arg.getSuperclass();
            if (sclass != null) {
                result.add(sclass);
            }
            for (Class<?> cls : arg.getInterfaces()) {
                result.add(cls);
            }
            return result;
        }
    };
    private List<Class<?>> classInheritance;
    private String contents = null;

    private ClassAnalyzer(Graph<Class<?>> gr) {
        ArrayList result = new ArrayList(gr.getPostorderList());
        Collections.reverse(result);
        this.classInheritance = result;
    }

    public ClassAnalyzer(Class<?> cls) {
        this(new Graph(cls, finder));
    }

    public ClassAnalyzer(List<Class<?>> classes) {
        this(new Graph((Class<?>)((Object)classes), finder));
    }

    public List<Class<?>> findClasses(Predicate<Class> pred) {
        ArrayList result = new ArrayList();
        for (Class<?> c : this.classInheritance) {
            if (!pred.evaluate(c)) continue;
            result.add(c);
        }
        return result;
    }

    public List<Method> findMethods(Predicate<Method> pred) {
        ArrayList<Method> result = new ArrayList<Method>();
        for (Class<?> c : this.classInheritance) {
            for (Method m : c.getDeclaredMethods()) {
                if (!pred.evaluate(m)) continue;
                result.add(m);
            }
        }
        return result;
    }

    public synchronized String toString() {
        if (this.contents == null) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            sb.append("ClassAnalyzer[");
            for (Class<?> cls : this.classInheritance) {
                if (first) {
                    first = false;
                } else {
                    sb.append(" ");
                }
                sb.append(cls.getName());
            }
            sb.append("]");
            this.contents = sb.toString();
        }
        return this.contents;
    }
}

