/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import java.security.InvalidAlgorithmParameterException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.crypto.dsig.spec.XPathFilterParameterSpec;
import org.jcp.xml.dsig.internal.dom.ApacheTransform;
import org.jcp.xml.dsig.internal.dom.DOMUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public final class DOMXPathTransform
extends ApacheTransform {
    public void init(TransformParameterSpec transformParameterSpec) throws InvalidAlgorithmParameterException {
        if (transformParameterSpec == null) {
            throw new InvalidAlgorithmParameterException("params are required");
        }
        if (!(transformParameterSpec instanceof XPathFilterParameterSpec)) {
            throw new InvalidAlgorithmParameterException("params must be of type XPathFilterParameterSpec");
        }
        this.params = transformParameterSpec;
    }

    public void init(XMLStructure xMLStructure, XMLCryptoContext xMLCryptoContext) throws InvalidAlgorithmParameterException {
        super.init(xMLStructure, xMLCryptoContext);
        this.unmarshalParams(DOMUtils.getFirstChildElement(this.transformElem));
    }

    private void unmarshalParams(Element element) {
        String string2 = element.getFirstChild().getNodeValue();
        NamedNodeMap namedNodeMap = element.getAttributes();
        if (namedNodeMap != null) {
            int n = namedNodeMap.getLength();
            HashMap<String, String> hashMap = new HashMap<String, String>(n);
            for (int i = 0; i < n; ++i) {
                Attr attr = (Attr)namedNodeMap.item(i);
                String string3 = attr.getPrefix();
                if (string3 == null || !string3.equals("xmlns")) continue;
                hashMap.put(attr.getLocalName(), attr.getValue());
            }
            this.params = new XPathFilterParameterSpec(string2, hashMap);
        } else {
            this.params = new XPathFilterParameterSpec(string2);
        }
    }

    public void marshalParams(XMLStructure xMLStructure, XMLCryptoContext xMLCryptoContext) throws MarshalException {
        super.marshalParams(xMLStructure, xMLCryptoContext);
        XPathFilterParameterSpec xPathFilterParameterSpec = (XPathFilterParameterSpec)this.getParameterSpec();
        Element element = DOMUtils.createElement(this.ownerDoc, "XPath", "http://www.w3.org/2000/09/xmldsig#", DOMUtils.getSignaturePrefix(xMLCryptoContext));
        element.appendChild(this.ownerDoc.createTextNode(xPathFilterParameterSpec.getXPath()));
        Iterator iterator = xPathFilterParameterSpec.getNamespaceMap().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + (String)entry.getKey(), (String)entry.getValue());
        }
        this.transformElem.appendChild(element);
    }
}

