/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class Utils {
    private Utils() {
    }

    public static byte[] readBytesFromStream(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
            if (n >= 1024) continue;
            break;
        }
        return byteArrayOutputStream.toByteArray();
    }

    static Set toNodeSet(Iterator iterator) {
        HashSet<Node> hashSet = new HashSet<Node>();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            hashSet.add(node);
            if (node.getNodeType() != 1) continue;
            NamedNodeMap namedNodeMap = node.getAttributes();
            int n = namedNodeMap.getLength();
            for (int i = 0; i < n; ++i) {
                hashSet.add(namedNodeMap.item(i));
            }
        }
        return hashSet;
    }

    public static String parseIdFromSameDocumentURI(String string2) {
        if (string2.length() == 0) {
            return null;
        }
        String string3 = string2.substring(1);
        if (string3 != null && string3.startsWith("xpointer(id(")) {
            int n = string3.indexOf(39);
            int n2 = string3.indexOf(39, n + 1);
            string3 = string3.substring(n + 1, n2);
        }
        return string3;
    }

    public static boolean sameDocumentURI(String string2) {
        return string2 != null && (string2.length() == 0 || string2.charAt(0) == '#');
    }
}

