/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.wom.impl.parser;

import java.io.IOException;
import java.util.Stack;
import org.jvnet.wom.impl.WSDLDefinitionsImpl;
import org.jvnet.wom.impl.parser.ParserContext;
import org.jvnet.wom.impl.parser.Patch;
import org.jvnet.wom.impl.parser.WSDLDocumentImpl;
import org.jvnet.wom.impl.parser.handler.Definitions;
import org.jvnet.wom.impl.parser.handler.WSDLContentHandler;
import org.jvnet.wom.impl.util.Uri;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.LocatorImpl;

public class WSDLContentHandlerEx
extends WSDLContentHandler {
    public WSDLDefinitionsImpl currentWSDL;
    private String documentSystemId;
    private final Stack<String> elementNames = new Stack();
    private final WSDLContentHandlerEx referer;
    public WSDLDocumentImpl document;
    public ParserContext parser;

    public WSDLContentHandlerEx(ParserContext parser) {
        this(parser, null);
    }

    private WSDLContentHandlerEx(ParserContext parser, WSDLContentHandlerEx referer) {
        this.referer = referer;
        this.parser = parser;
    }

    public void addPatcher(Patch patcher) {
        this.parser.patcherManager.addPatcher(patcher);
    }

    public void addErrorChecker(Patch patcher) {
        this.parser.patcherManager.addErrorChecker(patcher);
    }

    public void reportError(String msg, Locator loc) throws SAXException {
        this.parser.patcherManager.reportError(msg, loc);
    }

    public void reportError(String msg) throws SAXException {
        this.reportError(msg, this.getLocator());
    }

    private InputSource resolveRelativeURL(String namespaceURI, String relativeUri) throws SAXException {
        try {
            InputSource is;
            EntityResolver er;
            String baseUri = this.getLocator().getSystemId();
            if (baseUri == null) {
                baseUri = this.documentSystemId;
            }
            String systemId = null;
            if (relativeUri != null) {
                systemId = Uri.resolve(baseUri, relativeUri);
            }
            if ((er = this.parser.getEntityResolver()) != null && (is = er.resolveEntity(namespaceURI, systemId)) != null) {
                return is;
            }
            if (systemId != null) {
                return new InputSource(systemId);
            }
            return null;
        }
        catch (IOException e) {
            SAXParseException se = new SAXParseException(e.getMessage(), this.getLocator(), e);
            this.parser.errorHandler.error(se);
            return null;
        }
    }

    public void importWSDL(String ns, String wsdlLocation) throws SAXException {
        WSDLContentHandlerEx newRuntime = new WSDLContentHandlerEx(this.parser, this);
        InputSource source = this.resolveRelativeURL(ns, wsdlLocation);
        if (source != null) {
            newRuntime.parseEntity(source, ns, this.getLocator());
        }
    }

    public boolean hasAlreadyBeenRead() {
        if (this.documentSystemId != null && this.documentSystemId.startsWith("file:///")) {
            this.documentSystemId = "file:/" + this.documentSystemId.substring(8);
        }
        assert (this.document == null);
        this.document = new WSDLDocumentImpl(this.currentWSDL, this.documentSystemId);
        WSDLDocumentImpl existing = this.parser.parsedDocuments.get(this.document);
        if (existing == null) {
            this.parser.parsedDocuments.put(this.document, this.document);
            this.currentWSDL.setOwnerDocument(this.document);
        } else {
            this.document = existing;
        }
        assert (this.document != null);
        if (this.referer != null) {
            assert (this.referer.document != null) : "referer " + this.referer.documentSystemId + " has docIdentity==null";
            this.referer.document.references.add(this.document);
            this.document.referers.add(this.referer.document);
        }
        return existing != null;
    }

    public void parseEntity(InputSource source, String expectedNamespace, Locator importLocation) throws SAXException {
        this.documentSystemId = source.getSystemId();
        try {
            Definitions s = new Definitions(this, expectedNamespace);
            this.setRootHandler(s);
            try {
                this.parser.parser.parse(source, (ContentHandler)this, this.getErrorHandler(), this.parser.getEntityResolver());
            }
            catch (IOException e) {
                SAXParseException se = new SAXParseException(e.toString(), importLocation, e);
                this.parser.errorHandler.fatalError(se);
                throw se;
            }
        }
        catch (SAXException e) {
            this.parser.setErrorFlag();
            throw e;
        }
    }

    public String getAnnotationContextElementName() {
        return (String)this.elementNames.get(this.elementNames.size() - 2);
    }

    public Locator copyLocator() {
        return new LocatorImpl(this.getLocator());
    }

    public ErrorHandler getErrorHandler() {
        return this.parser.errorHandler;
    }

    public void onEnterElementConsumed(String uri, String localName, String qname, Attributes atts) throws SAXException {
        super.onEnterElementConsumed(uri, localName, qname, atts);
        this.elementNames.push(localName);
    }

    public void onLeaveElementConsumed(String uri, String localName, String qname) throws SAXException {
        super.onLeaveElementConsumed(uri, localName, qname);
        this.elementNames.pop();
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        super.startPrefixMapping(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        super.endPrefixMapping(prefix);
    }

    public boolean parseBoolean(String v) {
        if (v == null) {
            return false;
        }
        return (v = v.trim()).equals("true") || v.equals("1");
    }
}

