/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ooa;

import com.wewebu.ooa.cmis.OwCMISConnection;
import com.wewebu.ooa.cmis.OwCMISSimpleURLBuilder;
import com.wewebu.ooa.cmis.OwCMISURLBuilder;
import com.wewebu.ooa.descriptor.OwActionDescriptor;
import com.wewebu.ooa.descriptor.OwOpenAirInstallDescriptor;
import java.io.File;

public class OwOpenAirAlfrescoLocator {
    private static final String OPEN_AIR_TRACES_FOLDER = "oat";
    private File alfrescoInstallDir;
    private OwCMISURLBuilder alfrescoCMISURLBuilder = null;
    private String cmisUser;
    private String cmisPassword;

    public OwOpenAirAlfrescoLocator(File alfrescoInstallDir_p) {
        this(alfrescoInstallDir_p, "http://localhost:8080/alfresco/cmis/", "admin", "admin");
    }

    public OwOpenAirAlfrescoLocator(File alfrescoInstallDir_p, String simpleMainServiceURL_p, String cmisUser_p, String cmisPassword_p) {
        this(alfrescoInstallDir_p, new OwCMISSimpleURLBuilder(simpleMainServiceURL_p));
        this.cmisUser = cmisUser_p;
        this.cmisPassword = cmisPassword_p;
    }

    public OwOpenAirAlfrescoLocator(File alfrescoInstallDir_p, OwCMISURLBuilder alfrescoCMISURLBuilder_p) {
        this.alfrescoInstallDir = alfrescoInstallDir_p;
        this.alfrescoCMISURLBuilder = alfrescoCMISURLBuilder_p;
    }

    public String getCmisUser() {
        return this.cmisUser;
    }

    public String getCmisPassword() {
        return this.cmisPassword;
    }

    public File getAlfrescoInstallDir() {
        return this.alfrescoInstallDir;
    }

    public File findTraceFolder() {
        File tracesFolder = new File(this.alfrescoInstallDir, OPEN_AIR_TRACES_FOLDER);
        return tracesFolder;
    }

    public File findTraceFolder(OwOpenAirInstallDescriptor openAirDescriptor_p) {
        String name = openAirDescriptor_p.getName();
        File descriptorTracesFolder = new File(this.findTraceFolder(), name);
        return descriptorTracesFolder;
    }

    public File findTraceFolder(OwActionDescriptor actionDescriptor_p) {
        String actionTraceName = actionDescriptor_p.getIndexedTraceName();
        File openAirFolder = this.findTraceFolder(actionDescriptor_p.getOpenAirDescriptor());
        File actionTraceFolder = new File(openAirFolder, actionTraceName.replaceAll("\\.", "_"));
        return actionTraceFolder;
    }

    public OwCMISURLBuilder getCMISURLBuilder() {
        return this.alfrescoCMISURLBuilder;
    }

    public OwCMISConnection newCMISConnection() {
        OwCMISConnection connection = new OwCMISConnection(this.cmisUser, this.cmisPassword, this.alfrescoCMISURLBuilder);
        return connection;
    }
}

