/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ooa.ace;

import com.wewebu.ooa.OwInstallAction;
import com.wewebu.ooa.OwOpenAirAlfrescoLocator;
import com.wewebu.ooa.ace.OwBatchScript;
import com.wewebu.ooa.ace.OwOpenAirComunity3xxInstaller;
import com.wewebu.ooa.ace.OwStartAlfresco3xAction;
import com.wewebu.ooa.ace.OwStopAlfresco3xAction;
import com.wewebu.ooa.descriptor.OwStartAlfrescoDescriptor;
import com.wewebu.ooa.descriptor.OwStopAlfrescoDescriptor;
import java.io.File;
import org.apache.log4j.Logger;

public class OwOpenAirComunity32xInstaller
extends OwOpenAirComunity3xxInstaller {
    private static final Logger logger = Logger.getLogger("OwOpenAirComunity32xInstaller");
    private static final String ALFRESCO_BAT = "alfresco.bat";
    private static final String ALFRESCO_BAT_PATH = "/alfresco.bat";

    public String getInstallerDescription() {
        return "Workdesk Human Resources application installer @ Alfresco Community Edition 3.2.x & 3.3.x";
    }

    public boolean matchesAlfresco(OwOpenAirAlfrescoLocator alfrescoLocator_p) {
        String[][] versions = new String[][]{{"3", "2", null, null}, {"3", "3", null, null}};
        return this.matchesAlfrescoVersion(alfrescoLocator_p, versions);
    }

    protected Logger getLogger() {
        return logger;
    }

    protected OwInstallAction createAction(OwOpenAirAlfrescoLocator alfrescoLocator_p, OwStartAlfrescoDescriptor startAlfrescoDescriptor_p) {
        OwBatchScript startScript = null;
        if (!this.isWindowsHostOS()) {
            throw new UnsupportedOperationException("Unsupported action for OS " + System.getProperty("os.name"));
        }
        File alfrescoDir = alfrescoLocator_p.getAlfrescoInstallDir();
        String startScriptPath = alfrescoDir.getAbsolutePath() + ALFRESCO_BAT_PATH;
        startScript = new OwBatchScript(ALFRESCO_BAT, alfrescoDir, startScriptPath, "start", "nouser");
        return new OwStartAlfresco3xAction(startAlfrescoDescriptor_p, alfrescoLocator_p, startScript);
    }

    protected OwInstallAction createAction(OwOpenAirAlfrescoLocator alfrescoLocator_p, OwStopAlfrescoDescriptor stopAlfrescoDescriptor_p) {
        OwBatchScript stopScript = null;
        if (!this.isWindowsHostOS()) {
            throw new UnsupportedOperationException("Unsupported action for OS " + System.getProperty("os.name"));
        }
        File alfrescoDir = alfrescoLocator_p.getAlfrescoInstallDir();
        String stopScriptPath = alfrescoDir.getAbsolutePath() + ALFRESCO_BAT_PATH;
        stopScript = new OwBatchScript(ALFRESCO_BAT, alfrescoDir, stopScriptPath, "stop", "nouser");
        return new OwStopAlfresco3xAction(stopAlfrescoDescriptor_p, alfrescoLocator_p, stopScript);
    }
}

