/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ooa.data;

import com.wewebu.ooa.OwOAException;
import com.wewebu.ooa.data.OwData;
import com.wewebu.ooa.data.OwDataCollection;
import com.wewebu.ooa.data.OwDataSource;
import com.wewebu.ooa.data.OwFieldValueInterpreter;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OwDataContext {
    private OwDataContext parentContext;
    private Map<String, OwDataContext> objectScope = new HashMap<String, OwDataContext>();
    private Object thisValue;
    private String id;

    public OwDataContext(OwDataContext parentContext_p, Object thisValue_p) {
        this.parentContext = parentContext_p;
        this.thisValue = thisValue_p;
    }

    public OwDataContext(OwDataContext parentContext_p, OwData thisValue_p) {
        this.parentContext = parentContext_p;
        this.thisValue = thisValue_p;
        this.id = thisValue_p.getId();
        Map<String, String> fields = thisValue_p.getFields();
        Set<Map.Entry<String, String>> fieldEntries = fields.entrySet();
        for (Map.Entry<String, String> fieldEntry : fieldEntries) {
            this.objectScope.put(fieldEntry.getKey(), new OwDataContext(this, fieldEntry.getValue()));
        }
        for (OwDataSource source : thisValue_p.getSources()) {
            OwDataContext context = source.defineContext(this);
            if (context == null) continue;
            this.objectScope.put(context.getId(), context);
        }
    }

    public OwDataContext(OwDataContext parentContext_p, OwDataCollection thisValue_p) {
        this.parentContext = parentContext_p;
        this.thisValue = thisValue_p;
        this.id = thisValue_p.getId();
        for (OwDataSource source : thisValue_p.getSources()) {
            OwDataContext context = source.defineContext(this);
            if (context == null) continue;
            this.objectScope.put(context.getId(), context);
        }
    }

    public Object getValue() {
        return this.thisValue;
    }

    public String getId() {
        return this.id;
    }

    public OwDataContext getContext(String id_p) {
        if (this.id != null && this.id.equals(id_p)) {
            return this;
        }
        OwDataContext context = this.objectScope.get(id_p);
        if (context == null && this.parentContext != null) {
            context = this.parentContext.getContext(id_p);
        }
        return context;
    }

    public List<String> interpret(List<String> values_p) throws OwOAException {
        LinkedList<String> iValues = new LinkedList<String>();
        for (String value : values_p) {
            String iValue = this.interpret(value);
            iValues.add(iValue);
        }
        return iValues;
    }

    public String interpret(String value_p) throws OwOAException {
        return new OwFieldValueInterpreter(this).interpret(value_p);
    }
}

