/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ooa.data;

import com.wewebu.ooa.OwOAException;
import com.wewebu.ooa.data.OwDataContext;

public class OwFieldValueInterpreter {
    private OwDataContext context;

    public OwFieldValueInterpreter(OwDataContext context_p) {
        this.context = context_p;
    }

    protected String interpret(String statement_p, OwDataContext context_p) throws OwOAException {
        String[] ids = statement_p.split("\\.");
        OwDataContext context = context_p;
        for (int i = 0; i < ids.length && context != null; context = context.getContext(ids[i]), ++i) {
        }
        if (context == null) {
            throw new OwOAException("Could not interpret " + statement_p);
        }
        String valueString = context.getValue().toString();
        return context.interpret(valueString);
    }

    public String interpret(String value_p) throws OwOAException {
        StringBuilder placeholderBuilder = new StringBuilder();
        StringBuilder currentStatement = null;
        int valueLength = value_p.length();
        boolean inStatement = false;
        for (int i = 0; i < valueLength; ++i) {
            char c = value_p.charAt(i);
            if ('{' == c) {
                inStatement = true;
                currentStatement = new StringBuilder();
                continue;
            }
            if ('}' == c) {
                inStatement = false;
                String interpretedValue = this.interpret(currentStatement.toString(), this.context);
                if (interpretedValue != null) {
                    placeholderBuilder.append(interpretedValue);
                    continue;
                }
                placeholderBuilder.append("{");
                placeholderBuilder.append(currentStatement.toString());
                placeholderBuilder.append("}");
                continue;
            }
            if (inStatement) {
                currentStatement.append(c);
                continue;
            }
            placeholderBuilder.append(c);
        }
        return placeholderBuilder.toString();
    }
}

