/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ooa.databatch;

import com.wewebu.ooa.OwOAException;
import com.wewebu.ooa.OwOAMultiError;
import com.wewebu.ooa.data.OwData;
import com.wewebu.ooa.data.OwDataContext;
import com.wewebu.ooa.data.OwDataSource;
import com.wewebu.ooa.databatch.OwDataJob;
import com.wewebu.ooa.databatch.OwDataVisitor;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OwDataBatch
implements OwDataJob {
    private String forEachId = null;
    private String dataId = null;
    private int fork;
    private List<OwDataJob> jobs = new LinkedList<OwDataJob>();

    public OwDataBatch(String forEachId_p, String dataId_p, int fork_p) {
        this.fork = Math.max(fork_p, 1);
        this.forEachId = forEachId_p;
        this.dataId = dataId_p;
    }

    public List<OwDataJob> getJobs() {
        return this.jobs;
    }

    public void add(OwDataJob job_p) {
        this.jobs.add(job_p);
    }

    public String getForEachId() {
        return this.forEachId;
    }

    public String getDataId() {
        return this.dataId;
    }

    private void executeAllJobs(OwDataVisitor visitor_p, OwDataContext context_p) throws OwOAException {
        for (OwDataJob job : this.jobs) {
            job.execute(visitor_p, context_p);
        }
    }

    @Override
    public void execute(OwDataVisitor visitor_p, OwDataContext context_p) throws OwOAException {
        if (visitor_p.intercept(this)) {
            String forEachId = this.getForEachId();
            OwDataContext context = context_p.getContext(forEachId);
            if (context != null) {
                int i;
                OwDataSource source = (OwDataSource)context.getValue();
                OwForkExecutor[] executors = new OwForkExecutor[this.fork];
                OwForkKiller killer = new OwForkKiller(executors);
                Thread[] threads = new Thread[this.fork];
                for (i = 0; i < executors.length; ++i) {
                    executors[i] = new OwForkExecutor(visitor_p, killer);
                    threads[i] = new Thread(executors[i]);
                }
                for (i = 0; i < threads.length; ++i) {
                    threads[i].start();
                }
                Iterator<OwData> iterator = source.iterator(context_p);
                int count = 1;
                while (iterator.hasNext()) {
                    OwData data = iterator.next();
                    OwData reference = new OwData(this.getDataId(), data);
                    OwDataContext refContext = new OwDataContext(context, reference);
                    int executorIndex = count % this.fork;
                    executors[executorIndex].push(refContext);
                    ++count;
                }
                for (int i2 = 0; i2 < executors.length; ++i2) {
                    executors[i2].stop();
                }
                OwOAMultiError multiError = null;
                for (int i3 = 0; i3 < threads.length; ++i3) {
                    try {
                        threads[i3].join();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        try {
                            threads[i3].join();
                        }
                        catch (InterruptedException e1) {
                            e1.printStackTrace();
                        }
                    }
                    Throwable error = executors[i3].getError();
                    if (error == null) continue;
                    if (multiError == null) {
                        multiError = new OwOAMultiError("Data batch thread(s) error!");
                    }
                    multiError.add(error);
                }
                if (multiError != null) {
                    throw multiError;
                }
            } else {
                this.executeAllJobs(visitor_p, context_p);
            }
        }
    }

    private class OwForkExecutor
    implements Runnable {
        private LinkedList<OwDataContext> contextFifo = new LinkedList();
        private OwDataVisitor visitor;
        private OwOAException oaException;
        private Throwable throwable;
        private boolean run = true;
        private boolean forceStop = false;
        private OwForkKiller killer;

        public OwForkExecutor(OwDataVisitor visitor_p, OwForkKiller killer_p) {
            this.visitor = visitor_p;
            this.killer = killer_p;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void push(OwDataContext refContext_p) throws OwOAException {
            LinkedList<OwDataContext> linkedList = this.contextFifo;
            synchronized (linkedList) {
                if (!this.run) {
                    throw new OwOAException("Concurrent stop and run executor access!");
                }
                this.contextFifo.offer(refContext_p);
            }
        }

        public synchronized void stop() {
            this.run = false;
        }

        public synchronized void forceStop() {
            this.forceStop = true;
        }

        public Throwable getError() {
            if (this.oaException != null) {
                return this.oaException;
            }
            return this.throwable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean loopOn() {
            if (this.forceStop) {
                return false;
            }
            LinkedList<OwDataContext> linkedList = this.contextFifo;
            synchronized (linkedList) {
                if (!this.run && this.contextFifo.isEmpty()) {
                    return false;
                }
            }
            return this.oaException == null && this.throwable == null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.loopOn()) {
                OwDataContext context = null;
                LinkedList<OwDataContext> linkedList = this.contextFifo;
                synchronized (linkedList) {
                    context = this.contextFifo.poll();
                }
                if (context != null) {
                    try {
                        OwDataBatch.this.executeAllJobs(this.visitor, context);
                    }
                    catch (OwOAException e) {
                        this.oaException = e;
                        this.killer.killAll();
                    }
                    catch (Throwable t) {
                        this.throwable = t;
                        this.killer.killAll();
                    }
                    continue;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private class OwForkKiller {
        private OwForkExecutor[] executors;

        public OwForkKiller(OwForkExecutor[] executors_p) {
            this.executors = executors_p;
        }

        public synchronized void killAll() {
            for (OwForkExecutor executor : this.executors) {
                executor.forceStop();
            }
        }
    }
}

