/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ooa.databatch;

import com.wewebu.ooa.OwOAException;
import com.wewebu.ooa.cmis.OwCMISConnection;
import com.wewebu.ooa.cmis.OwCMISPropertyNames;
import com.wewebu.ooa.data.OwDataContext;
import com.wewebu.ooa.databatch.OwValuesData;
import java.util.LinkedList;
import java.util.List;
import org.oasis_open.docs.ns.cmis.core._200908.CmisObjectType;
import org.oasis_open.docs.ns.cmis.core._200908.CmisPropertyId;
import org.oasis_open.docs.ns.cmis.core._200908.EnumIncludeRelationships;
import org.oasis_open.docs.ns.cmis.core._200908.ObjectFactory;
import org.oasis_open.docs.ns.cmis.messaging._200908.CmisRepositoryEntryType;
import org.oasis_open.docs.ns.cmis.ws._200908.ObjectServicePort;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OwIdValues
implements OwValuesData {
    private List<String> values = new LinkedList<String>();

    @Override
    public void addStringValueData(String data_p) throws OwOAException {
        this.values.add(data_p);
    }

    @Override
    public CmisPropertyId createCMISProperty(OwCMISConnection connection_p, CmisRepositoryEntryType repository_p, OwDataContext context_p) throws OwOAException {
        ObjectFactory cmisFactory = new ObjectFactory();
        CmisPropertyId property = cmisFactory.createCmisPropertyId();
        List<String> iValues = context_p.interpret(this.values);
        property.getValue().addAll(this.convertPathToIds(iValues, connection_p, repository_p));
        return property;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<? extends String> convertPathToIds(List<String> paths_p, OwCMISConnection connection_p, CmisRepositoryEntryType repository_p) {
        LinkedList<String> ids = new LinkedList<String>();
        try {
            ObjectServicePort objectServicePort = connection_p.getObjectServicePort();
            for (String path : paths_p) {
                try {
                    CmisObjectType cmisSourceObject = objectServicePort.getObjectByPath(repository_p.getRepositoryId(), path, OwCMISPropertyNames.OBJECT_ID.getId(), Boolean.TRUE, EnumIncludeRelationships.NONE, null, Boolean.FALSE, Boolean.FALSE, null);
                    String sourceObjectId = OwCMISPropertyNames.OBJECT_ID.getIdValue(cmisSourceObject);
                    ids.add(sourceObjectId);
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot convert path " + path + " to id !", e);
                    return ids;
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot convert paths to id!", e);
        }
    }

    @Override
    public List<String> toString(OwDataContext context_p) throws OwOAException {
        return context_p.interpret(this.values);
    }
}

