/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.owdummy;

import com.wewebu.ow.server.ecm.OwResource;
import com.wewebu.ow.server.ecm.OwUserInfo;
import com.wewebu.ow.server.ecmimpl.OwAbstractCredentials;
import com.wewebu.ow.server.ecmimpl.owdummy.OwDummyUserInfo;
import com.wewebu.ow.server.ecmimpl.owdummy.log.OwLog;
import com.wewebu.ow.server.exceptions.OwAuthenticationException;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.util.ldap.OwLdapConnector;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;

public class OwDummyCredentials
extends OwAbstractCredentials {
    private static final Logger LOG = OwLog.getLogger(OwDummyCredentials.class);
    OwLdapConnector m_ldapConn;
    OwDummyUserInfo m_Info;

    public OwDummyCredentials(String userName_p, String password_p, Node authenticationNode_p) throws OwAuthenticationException, OwConfigurationException, OwInvalidOperationException {
        super(userName_p, password_p);
        this.m_ldapConn = new OwLdapConnector(authenticationNode_p);
        try {
            this.m_ldapConn.authenticate(userName_p, password_p);
        }
        catch (OwAuthenticationException e1) {
            throw new OwAuthenticationException("Your login information is invalid. Please make sure that name and password are correct.", (Throwable)e1);
        }
        catch (OwConfigurationException e) {
            String msg = "Exception trying to connect to LDAP, possible cause: Wrong configuration of the bootstrap.xml file (Authentication node).";
            LOG.error((Object)msg, (Throwable)e);
            throw new OwConfigurationException(msg, (Throwable)e);
        }
        this.m_Info = new OwDummyUserInfo(userName_p);
        String fullName = this.m_ldapConn.getUserLongName();
        this.m_Info.setStrLongUserName(fullName);
        String userId = this.m_ldapConn.getUserId();
        this.m_Info.setUserId(userId);
        Collection roleNames = this.m_ldapConn.getShortGroupNames();
        this.m_Info.setRoleNames(roleNames);
    }

    public OwDummyCredentials(String strUserName_p) {
        this.m_Info = new OwDummyUserInfo(strUserName_p);
        this.m_Info.setStrLongUserName(strUserName_p);
        this.m_Info.setUserId(strUserName_p);
        LinkedList<String> roles = new LinkedList<String>();
        roles.add("#Authenticated-Users");
        if (strUserName_p.startsWith("Admin") || strUserName_p.startsWith("admin")) {
            roles.add("Users");
            roles.add("Mitarbeiter");
            roles.add("Administrators");
            roles.add("Application_A");
            roles.add("Versicherungen");
            roles.add("Application_B");
            roles.add("Banken");
            roles.add("Guest");
            roles.add("Gast");
        }
        if (strUserName_p.equalsIgnoreCase("a")) {
            roles.add("Users");
            roles.add("Mitarbeiter");
            roles.add("Application_A");
            roles.add("Versicherungen");
        }
        if (strUserName_p.equalsIgnoreCase("b")) {
            roles.add("Users");
            roles.add("Mitarbeiter");
            roles.add("Application_B");
            roles.add("Banken");
        }
        if (strUserName_p.equalsIgnoreCase("Guest")) {
            roles.add("Guest");
            roles.add("Gast");
        }
        this.m_Info.setRoleNames(roles);
    }

    public OwUserInfo getUserInfo() throws Exception {
        return this.m_Info;
    }

    public void invalidate() throws Exception {
    }

    public String getSecurityToken(OwResource resource_p) {
        return "";
    }

    public boolean isContainerBasedAuthenticated() throws OwException {
        return false;
    }
}

