/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.owdummy;

import com.wewebu.ow.server.conf.OwBaseUserInfo;
import com.wewebu.ow.server.ecm.OwAttributeBagsSupport;
import com.wewebu.ow.server.ecm.OwBatch;
import com.wewebu.ow.server.ecm.OwContentCollection;
import com.wewebu.ow.server.ecm.OwCredentials;
import com.wewebu.ow.server.ecm.OwFileObject;
import com.wewebu.ow.server.ecm.OwNetwork;
import com.wewebu.ow.server.ecm.OwNetworkContext;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectClass;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwObjectLink;
import com.wewebu.ow.server.ecm.OwObjectSkeleton;
import com.wewebu.ow.server.ecm.OwPermissionCollection;
import com.wewebu.ow.server.ecm.OwProperty;
import com.wewebu.ow.server.ecm.OwPropertyClass;
import com.wewebu.ow.server.ecm.OwPropertyCollection;
import com.wewebu.ow.server.ecm.OwRepository;
import com.wewebu.ow.server.ecm.OwRepositoryContext;
import com.wewebu.ow.server.ecm.OwResource;
import com.wewebu.ow.server.ecm.OwStandardObjectCollection;
import com.wewebu.ow.server.ecm.OwStandardSearchTemplate;
import com.wewebu.ow.server.ecm.OwTransientBagsSupport;
import com.wewebu.ow.server.ecm.OwUserInfo;
import com.wewebu.ow.server.ecm.OwVirtualFolderObject;
import com.wewebu.ow.server.ecm.OwVirtualFolderObjectFactory;
import com.wewebu.ow.server.ecm.ui.OwUIAccessRightsModul;
import com.wewebu.ow.server.ecm.ui.OwUILoginModul;
import com.wewebu.ow.server.ecm.ui.OwUIUserSelectModul;
import com.wewebu.ow.server.ecmimpl.owdummy.OwDummyCredentials;
import com.wewebu.ow.server.ecmimpl.owdummy.OwDummyFileObject;
import com.wewebu.ow.server.ecmimpl.owdummy.OwDummyObjectFactory;
import com.wewebu.ow.server.ecmimpl.owdummy.OwDummyObjectLinkClass;
import com.wewebu.ow.server.ecmimpl.owdummy.OwDummyResource;
import com.wewebu.ow.server.ecmimpl.owdummy.OwDummyUserInfo;
import com.wewebu.ow.server.ecmimpl.owdummy.OwDummyWorkitemRepository;
import com.wewebu.ow.server.ecmimpl.owdummy.log.OwLog;
import com.wewebu.ow.server.ecmimpl.owdummy.ui.OwDummyLoginUISubModul;
import com.wewebu.ow.server.ecmimpl.owdummy.ui.OwDummyUIUserSelectModul;
import com.wewebu.ow.server.event.OwEvent;
import com.wewebu.ow.server.event.OwEventManager;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.exceptions.OwNotSupportedException;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.field.OwFieldDefinition;
import com.wewebu.ow.server.field.OwSearchNode;
import com.wewebu.ow.server.field.OwSearchSQLOperator;
import com.wewebu.ow.server.field.OwSearchTemplate;
import com.wewebu.ow.server.field.OwSort;
import com.wewebu.ow.server.field.OwStandardWildCardDefinition;
import com.wewebu.ow.server.history.OwStandardHistoryObjectCreateEvent;
import com.wewebu.ow.server.role.OwRoleManager;
import com.wewebu.ow.server.util.OwMimeTypes;
import com.wewebu.ow.server.util.OwStandardXMLUtil;
import com.wewebu.ow.server.util.OwStreamUtil;
import com.wewebu.ow.server.util.OwString;
import com.wewebu.ow.server.util.OwString1;
import com.wewebu.ow.server.util.OwXMLDOMUtil;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class OwDummyNetwork
implements OwNetwork {
    private static final Logger LOG = OwLog.getLogger(OwDummyNetwork.class);
    public static final String DMS_PREFIX = "owdm";
    private OwEventManager m_eventManager;
    public static final String VIRTUAL_FOLDER_PREFIX = "owvf";
    public static final String OBJECT_CATEGORY_PREFERENCES = "/WEB-INF/dummy/owpreferences";
    private OwNetworkContext m_Context;
    private OwXMLUtil m_networkSettings;
    private OwResource m_defaultResource = new OwDummyResource();
    protected String m_preferencesFolder = "/WEB-INF/dummy/owpreferences";
    protected static final HashMap m_ObjectClassesMap = new HashMap();
    protected static final HashMap m_jndiPropertyNames;
    private OwCredentials m_credentials;
    private static final String BAGS_APPLICATION_KEY = "OwDummyNetworkAttributeBags";
    private OwObject m_cachedLastObject;
    private OwLikeWildCardDefinitions m_likewildcarddefinitions;
    private List m_retList;
    protected OwAttributeBagsSupport m_bagsSupport = null;

    public OwXMLUtil getConfigNode() {
        return this.m_networkSettings;
    }

    public Locale getLocale() {
        return this.getContext().getLocale();
    }

    public OwNetworkContext getContext() {
        return this.m_Context;
    }

    protected HashMap getObjectClassMap() throws Exception {
        return m_ObjectClassesMap;
    }

    public Object getInterface(String strInterfaceName_p, Object oObject_p) throws Exception {
        if (strInterfaceName_p.equals("com.wewebu.ow.server.ecm.bpm.OwWorkitemRepository")) {
            return this.getBpmRepository();
        }
        String msg = "OwDummyNetwork.getInterface: Interfacename = " + strInterfaceName_p + ", expected = \"com.wewebu.ow.server.ecm.bpm.OwWorkitemRepository\" ";
        LOG.error((Object)msg);
        throw new OwObjectNotFoundException(msg);
    }

    private Object getBpmRepository() {
        return new OwDummyWorkitemRepository(this);
    }

    public boolean hasInterface(String strInterfaceName_p) {
        return strInterfaceName_p.equals("com.wewebu.ow.server.ecm.bpm.OwWorkitemRepository");
    }

    public void init(OwNetworkContext context_p, OwXMLUtil networkSettings_p) throws Exception {
        this.m_retList = new ArrayList();
        this.m_Context = context_p;
        this.m_networkSettings = networkSettings_p;
        this.attributeBagSupportSetup();
        this.m_preferencesFolder = this.m_networkSettings.getSafeTextValue("UserDefinedPreferencesFolder", OBJECT_CATEGORY_PREFERENCES);
    }

    public void setRoleManager(OwRoleManager roleManager_p) {
    }

    public void setEventManager(OwEventManager eventManager_p) {
        this.m_eventManager = eventManager_p;
    }

    public OwEventManager getEventManager() {
        return this.m_eventManager;
    }

    public void refreshStaticClassdescriptions() throws Exception {
        throw new OwNotSupportedException("OwDummyNetwork.refreshStaticClassdescriptions: Not implemented.");
    }

    public boolean canRefreshStaticClassdescriptions() throws Exception {
        return true;
    }

    public OwCredentials getCredentials() throws Exception {
        return this.m_credentials;
    }

    public OwUserInfo getUserFromID(String strID_p) throws Exception {
        if (null == strID_p) {
            throw new OwObjectNotFoundException("OwDummyNetwork.getUserFromID: The Id of the searched User is null.");
        }
        return new OwDummyUserInfo(strID_p);
    }

    public String getRoleDisplayName(String strRoleName_p) throws Exception {
        return strRoleName_p;
    }

    public void doLogin(String strUserName_p, String strPassword_p) throws Exception {
        Node authenticationNode = this.getConfigNode().getSubNode("Authentication");
        if (authenticationNode == null) {
            String msg = "OwDummyNetwork.doLogin: Please verify your owbootstrap.xml, how the authentication should happend (node Authentication).";
            LOG.fatal((Object)msg);
            throw new OwConfigurationException(msg);
        }
        String authenticationMode = authenticationNode.getAttributes().getNamedItem("mode").getNodeValue();
        if (authenticationMode != null && authenticationMode.equalsIgnoreCase("LDAP")) {
            this.m_credentials = new OwDummyCredentials(strUserName_p, strPassword_p, authenticationNode);
        } else {
            if (strUserName_p == null || strUserName_p.equals("")) {
                strUserName_p = "guest";
            }
            this.m_credentials = new OwDummyCredentials(strUserName_p);
        }
        this.m_Context.onLogin((OwBaseUserInfo)this.m_credentials.getUserInfo());
        this.getEventManager().addEvent(5, "login", 1);
    }

    public OwUILoginModul getLoginSubModul() throws Exception {
        OwDummyLoginUISubModul LoginSubModul = new OwDummyLoginUISubModul();
        LoginSubModul.init(this);
        return LoginSubModul;
    }

    public void logout() throws Exception {
        this.getEventManager().addEvent(5, "logoff", 1);
        this.m_credentials = null;
    }

    public void loginDefault(String strUser_p, String strPassword_p) throws Exception {
        this.doLogin(strUser_p, strPassword_p);
    }

    public OwUIAccessRightsModul getEditAccessRightsSubModul(OwObject object_p) throws Exception {
        return null;
    }

    public boolean canEditAccessRights(OwObject object_p) throws Exception {
        return false;
    }

    public OwUIUserSelectModul getUserSelectSubModul(String strID_p, int[] types_p) throws Exception {
        OwDummyUIUserSelectModul userDlg = new OwDummyUIUserSelectModul(strID_p, types_p);
        userDlg.init(this);
        return userDlg;
    }

    public boolean canUserSelect() throws Exception {
        return true;
    }

    public Collection getApplicationObjects(int iTyp_p, String strName_p, boolean fForceUserSpecificObject_p) throws Exception {
        switch (iTyp_p) {
            case 4: {
                return this.getObjects(strName_p, fForceUserSpecificObject_p, -1);
            }
            case 3: {
                OwStandardObjectCollection objects = this.getObjects(strName_p, fForceUserSpecificObject_p, -1);
                this.m_retList.clear();
                Iterator it = objects.iterator();
                while (it.hasNext()) {
                    OwSearchTemplate searchTemplate = this.createSearchTemplate((OwObject)it.next());
                    if (this.m_retList.contains(searchTemplate)) continue;
                    this.m_retList.add(searchTemplate);
                }
                return this.m_retList;
            }
            case 1: {
                return this.getObjects(strName_p == null ? "other" : strName_p, false, -1);
            }
        }
        String msg = "OwDummyNetwork.getApplicationObjects: Unsupported ApplicationObject, Name = " + strName_p + ", Type = " + iTyp_p;
        LOG.error((Object)msg);
        throw new OwNotSupportedException(msg);
    }

    private OwStandardObjectCollection getObjects(String strCategory_p, boolean fForceUserSpecificObject_p, int iMaxSize_p) throws Exception {
        File SiteFolder;
        File[] siteFiles;
        OwStandardObjectCollection Objects = new OwStandardObjectCollection();
        String strFilePath = this.m_Context.getBasePath() + "/WEB-INF/dummy/" + strCategory_p;
        if (fForceUserSpecificObject_p) {
            strFilePath = strFilePath + "/" + this.getCredentials().getUserInfo().getUserID();
            strFilePath = strFilePath + "_";
        }
        if ((siteFiles = (SiteFolder = new File(strFilePath)).listFiles()) != null && siteFiles.length > 0) {
            int len = siteFiles.length;
            if (iMaxSize_p != -1 && len > iMaxSize_p) {
                len = iMaxSize_p;
                Objects.setAttribute("ow_complete", (Object)Boolean.FALSE);
            }
            for (int i = 0; i < len; ++i) {
                File file = siteFiles[i];
                if (file.isHidden()) continue;
                OwFileObject object = OwDummyObjectFactory.getInstance().create(this, file);
                Objects.add((Object)object);
            }
        }
        Objects.setAttribute("ow_size", (Object)Objects.size());
        return Objects;
    }

    private OwObject createVirtualFolder(String strName_p, String strDmsIDPart_p) throws Exception {
        FileInputStream in = new FileInputStream(new File(this.m_Context.getBasePath() + "/WEB-INF/dummy/" + strName_p + ".xml"));
        Document doc = OwXMLDOMUtil.getDocumentFromInputStream((InputStream)in);
        return this.createVirtualFolder(doc.getFirstChild(), strName_p, strDmsIDPart_p);
    }

    protected OwObject createVirtualFolder(Node xmlVirtualFolderDescriptionNode_p, String strName_p, String strDmsIDPart_p) throws Exception {
        OwStandardXMLUtil description = new OwStandardXMLUtil(xmlVirtualFolderDescriptionNode_p);
        String strVirtualFolderClassName = description.getSafeTextValue("ClassName", "com.wewebu.ow.server.ecm.OwStandardVirtualFolderObjectFactory");
        Class<?> virtualFolderClass = Class.forName(strVirtualFolderClassName);
        OwVirtualFolderObjectFactory retObject = (OwVirtualFolderObjectFactory)virtualFolderClass.newInstance();
        Node rootNode = description.getSubNode("root");
        retObject.init(this.getContext(), (OwRepository)this, DMS_PREFIX + "," + VIRTUAL_FOLDER_PREFIX + "," + strName_p, strName_p, rootNode);
        return retObject.getInstance(strDmsIDPart_p);
    }

    private Map getAttributeBagMap() {
        HashMap ret = (HashMap)this.getContext().getApplicationAttribute(BAGS_APPLICATION_KEY);
        if (null == ret) {
            ret = new HashMap();
            this.getContext().setApplicationAttribute(BAGS_APPLICATION_KEY, ret);
        }
        return ret;
    }

    public Object getApplicationObject(int iTyp_p, String strName_p, boolean fForceUserSpecificObject_p, boolean fCreateIfNotExist_p) throws Exception {
        return this.getApplicationObject(iTyp_p, strName_p, null, fForceUserSpecificObject_p, fCreateIfNotExist_p);
    }

    public Object getApplicationObject(int iTyp_p, String strName_p, Object param_p, boolean fForceUserSpecificObject_p, boolean fCreateIfNotExist_p) throws Exception {
        switch (iTyp_p) {
            case 7: {
                if (!fForceUserSpecificObject_p) {
                    String msg = "OwFNCMNetwork.getApplicationObject: Attribute Bags are always user specific, set fForceUserSpecificObject_p = true";
                    LOG.debug((Object)msg);
                    throw new OwObjectNotFoundException(msg);
                }
                return this.m_bagsSupport.getUserKeyAttributeBagWriteable(this.getContext(), strName_p, (String)param_p);
            }
            case 1: {
                return this.createVirtualFolder(strName_p, null);
            }
            case 2: {
                return this.getFileObject(this.m_Context.getBasePath() + this.m_preferencesFolder + "/", strName_p, fForceUserSpecificObject_p, "text/xml", fCreateIfNotExist_p);
            }
            case 4: {
                OwObject xmlObject = this.getFileObject(this.m_Context.getBasePath() + "/WEB-INF/dummy/", strName_p, fForceUserSpecificObject_p, "text/xml", fCreateIfNotExist_p);
                InputStream in = xmlObject.getContentCollection().getContentElement(1, 1).getContentStream(null);
                return OwXMLDOMUtil.getDocumentFromInputStream((InputStream)in);
            }
            case 3: {
                OwObject owObject = this.getFileObject(this.m_Context.getBasePath() + "/WEB-INF/dummy/", strName_p, fForceUserSpecificObject_p, "text/xml", fCreateIfNotExist_p);
                OwStandardSearchTemplate searchTemplate = new OwStandardSearchTemplate(this.getContext(), owObject);
                if (!this.m_retList.contains(searchTemplate)) {
                    this.m_retList.add(searchTemplate);
                }
                return searchTemplate;
            }
        }
        String msg = "OwDummyNetwork.getApplicationObject: ApplicationObject = " + strName_p + ", Type = " + iTyp_p;
        LOG.error((Object)msg);
        throw new OwObjectNotFoundException(msg);
    }

    private OwObject getFileObject(String strBasePath_p, String strName_p, boolean fForceUserSpecificObject_p, String strMimeType_p, boolean fCreateIfNotExist_p) throws Exception {
        if (fForceUserSpecificObject_p) {
            strBasePath_p = strBasePath_p + this.getCredentials().getUserInfo().getUserID();
            strBasePath_p = strBasePath_p + "_";
        }
        strBasePath_p = strBasePath_p + strName_p;
        String strExt = OwMimeTypes.getExtensionFromMime((String)strMimeType_p);
        if (strExt != null) {
            strBasePath_p = strBasePath_p + "." + strExt;
        }
        File folder = new File(strBasePath_p);
        OwFileObject fileObject = OwDummyObjectFactory.getInstance().create(this, folder);
        if (!fileObject.canGetContent(1, 2) && !fCreateIfNotExist_p) {
            throw new OwObjectNotFoundException("OwDummyNetwork.getFileObject: Cannot get content, strBasePath_p = " + strBasePath_p);
        }
        return fileObject;
    }

    private OwObject parseObjectFromDMSID(StringTokenizer tokens, boolean fRefresh) throws Exception {
        tokens.nextToken();
        String strTypePrefix = tokens.nextToken();
        if (strTypePrefix.equals(VIRTUAL_FOLDER_PREFIX)) {
            String strName = tokens.nextToken();
            String strDmsIDPart = tokens.nextToken();
            this.m_cachedLastObject = this.createVirtualFolder(strName, strDmsIDPart);
        } else if (strTypePrefix.equals("awl")) {
            String linkClass = tokens.nextToken();
            OwObject source = this.parseObjectFromDMSID(tokens, fRefresh);
            OwObject target = this.parseObjectFromDMSID(tokens, fRefresh);
            OwObjectCollection links = source.getChilds(new int[]{12291}, null, null, -1, 0, null);
            Iterator linksIt = links.iterator();
            OwObjectLink theLink = null;
            while (linksIt.hasNext()) {
                OwObjectLink link = (OwObjectLink)linksIt.next();
                if (!link.getSource().getDMSID().equals(source.getDMSID()) || !link.getTarget().getDMSID().equals(target.getDMSID()) || !link.getObjectClass().getClassName().equals(linkClass)) continue;
                theLink = link;
                break;
            }
            if (theLink == null) {
                throw new OwObjectNotFoundException("OwDummyNetwork.parseObjectFromDMSID: invalid link " + source.getDMSID() + " -> " + target.getDMSID() + " of type " + linkClass);
            }
            this.m_cachedLastObject = theLink;
        } else if (strTypePrefix.equals("owfi")) {
            String strFilePath = tokens.nextToken();
            if (strFilePath.startsWith("/")) {
                strFilePath = this.getArchiveBaseDir() + strFilePath;
            }
            this.m_cachedLastObject = OwDummyObjectFactory.getInstance().create(this, new File(strFilePath));
            if (!((OwFileObject)this.m_cachedLastObject).exists()) {
                this.m_cachedLastObject = null;
                throw new OwObjectNotFoundException("OwDummyNetwork.parseObjectFromDMSID: PATH does not exist  " + strFilePath);
            }
        } else {
            throw new OwObjectNotFoundException("OwDummyNetwork.parseObjectFromDMSID: Unknown object type, @ " + strTypePrefix);
        }
        return this.m_cachedLastObject;
    }

    public OwObject getObjectFromDMSID(String strDMSID_p, boolean fRefresh_p) throws Exception {
        if (!fRefresh_p && null != this.m_cachedLastObject && this.m_cachedLastObject.getDMSID().equals(strDMSID_p)) {
            return this.m_cachedLastObject;
        }
        if (!strDMSID_p.startsWith(DMS_PREFIX) && !strDMSID_p.startsWith(VIRTUAL_FOLDER_PREFIX)) {
            String msg = "OwDummyNetwork.getObjectFromDMSID: Wrong DMSID DMS_PREFIX or VIRTUAL_FOLDER_PREFIX, DMSID = " + strDMSID_p;
            LOG.error((Object)msg);
            throw new OwObjectNotFoundException(msg);
        }
        StringTokenizer tokens = new StringTokenizer(strDMSID_p, ",");
        try {
            return this.parseObjectFromDMSID(tokens, fRefresh_p);
        }
        catch (Exception e) {
            LOG.error((Object)("Could not retrieve objec tfor DMSID " + strDMSID_p));
            throw e;
        }
    }

    public String getArchiveBaseDir() {
        return OwString.replaceAll((String)(this.m_Context.getBasePath() + "/WEB-INF"), (String)"\\", (String)"/");
    }

    public OwObjectCollection doSearch(OwSearchNode searchNode_p, OwSort sortCriteria_p, Collection propertyNames_p, int iMaxSize_p, int iVersionSelection_p) throws Exception {
        this.getEventManager().addEvent(5, "search", 1);
        StringWriter sql = new StringWriter();
        OwSearchSQLOperator op1 = new OwSearchSQLOperator(2);
        sql.write("\r\n DATE_MODE_MS_ACCESS");
        op1.createSQLSearchCriteria(searchNode_p.findSearchNode(1), (Writer)sql);
        OwSearchSQLOperator op2 = new OwSearchSQLOperator(3);
        sql.write("\r\n DATE_MODE_FNCM");
        op2.createSQLSearchCriteria(searchNode_p.findSearchNode(1), (Writer)sql);
        OwSearchSQLOperator op3 = new OwSearchSQLOperator(1);
        sql.write("\r\n DATE_MODE_FNIM");
        op3.createSQLSearchCriteria(searchNode_p.findSearchNode(1), (Writer)sql);
        OwSearchSQLOperator op4 = new OwSearchSQLOperator(7);
        sql.write("\r\n DATE_MODE_DEFAULT");
        op4.createSQLSearchCriteria(searchNode_p.findSearchNode(1), (Writer)sql);
        OwSearchSQLOperator op5 = new OwSearchSQLOperator(5);
        sql.write("\r\n DATE_MODE_MSSQL");
        op5.createSQLSearchCriteria(searchNode_p.findSearchNode(1), (Writer)sql);
        OwSearchSQLOperator op6 = new OwSearchSQLOperator(4);
        sql.write("\r\n DATE_MODE_ORACLE");
        op6.createSQLSearchCriteria(searchNode_p.findSearchNode(1), (Writer)sql);
        OwStandardObjectCollection RetList = this.getObjects("dummyarchiv", false, iMaxSize_p);
        RetList.setAttribute("ow_sql", (Object)sql.toString());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("OwDummyNetwork.doSearch: SQL = " + sql.toString()));
        }
        if (null != sortCriteria_p) {
            RetList.sort(sortCriteria_p);
        }
        return RetList;
    }

    public String createNewObject(OwResource resource_p, String strObjectClassName_p, OwPropertyCollection properties_p, OwPermissionCollection permissions_p, OwContentCollection content_p, OwObject parent_p, String strMimeType_p, String strMimeParameter_p) throws Exception {
        if (!properties_p.containsKey((Object)"ow_Filename")) {
            throw new OwInvalidOperationException("OwDummyNetwork.createNewObject: Missing name property.");
        }
        String strNewName = (String)((OwProperty)properties_p.get((Object)"ow_Filename")).getValue();
        if (null == strNewName || 0 == strNewName.length()) {
            throw new OwInvalidOperationException("Name property empty.");
        }
        OwResource resource = null;
        if (parent_p != null) {
            resource = parent_p.getResource();
        }
        OwObjectClass objClass = this.getObjectClass(strObjectClassName_p, resource);
        if (parent_p instanceof OwVirtualFolderObject) {
            ((OwVirtualFolderObject)parent_p).setFiledObjectProperties(objClass, properties_p);
            parent_p = null;
        }
        String strFileName = strNewName;
        if (strMimeType_p != null && strMimeType_p.length() > 0) {
            strFileName = strFileName + "." + OwMimeTypes.getExtensionFromMime((String)strMimeType_p);
        }
        File newFile = null;
        newFile = parent_p != null ? new File(((OwFileObject)parent_p).getFileObject(), strFileName) : new File(this.m_Context.getBasePath() + "/WEB-INF/dummy/" + strFileName);
        if (newFile.exists()) {
            this.getEventManager().addEvent(6, "newobject", 2);
            throw new OwInvalidOperationException(this.getContext().localize("owdummy.OwDummyNetwork.existsalready", "There already exists a file with this name:") + strNewName);
        }
        if (objClass.getType() == 8193) {
            newFile.mkdir();
        } else if (content_p != null) {
            if (content_p.getPageCount() >= 1) {
                InputStream in = content_p.getContentElement(1, 1).getContentStream(null);
                FileOutputStream out = new FileOutputStream(newFile);
                OwStreamUtil.upload((InputStream)in, (OutputStream)out, (boolean)true);
            } else {
                newFile.createNewFile();
            }
        } else {
            newFile.createNewFile();
        }
        String dmsid = OwDummyFileObject.getDMSID(this.getArchiveBaseDir(), newFile);
        this.getEventManager().addEvent(6, "newobject", (OwEvent)new OwStandardHistoryObjectCreateEvent(strObjectClassName_p, dmsid, properties_p), 1);
        return dmsid;
    }

    public String createNewObject(boolean fPromote_p, Object mode_p, OwResource resource_p, String strObjectClassName_p, OwPropertyCollection properties_p, OwPermissionCollection permissions_p, OwContentCollection content_p, OwObject parent_p, String strMimeType_p, String strMimeParameter_p) throws Exception {
        return this.createNewObject(resource_p, strObjectClassName_p, properties_p, permissions_p, content_p, parent_p, strMimeType_p, strMimeParameter_p);
    }

    public String createNewObject(boolean fPromote_p, Object mode_p, OwResource resource_p, String strObjectClassName_p, OwPropertyCollection properties_p, OwPermissionCollection permissions_p, OwContentCollection content_p, OwObject parent_p, String strMimeType_p, String strMimeParameter_p, boolean fKeepCheckedOut_p) throws Exception {
        if (fKeepCheckedOut_p) {
            throw new OwNotSupportedException("The DCTM adapter can not yet create new objects and keep them checked out.");
        }
        return this.createNewObject(fPromote_p, mode_p, resource_p, strObjectClassName_p, properties_p, permissions_p, content_p, parent_p, strMimeType_p, strMimeParameter_p);
    }

    public boolean canCreateNewObject(OwResource resource_p, OwObject parent_p, int iContext_p) throws Exception {
        return true;
    }

    public String createObjectCopy(OwObject obj_p, OwPropertyCollection properties_p, OwPermissionCollection permissions_p, OwObject parent_p, int[] childTypes_p) throws Exception {
        this.getEventManager().addEvent(6, "copyobject", 1);
        return null;
    }

    public boolean canCreateObjectCopy(OwObject parent_p, int[] childTypes_p, int iContext_p) throws Exception {
        return false;
    }

    public OwObjectClass getObjectClass(String strClassName_p, OwResource resource_p) throws Exception {
        OwObjectClass objectClassDescription = (OwObjectClass)this.getObjectClassMap().get(strClassName_p);
        if (null == objectClassDescription) {
            String msg = "OwDummyNetwork.getObjectClass: Object class description not found, classname = " + strClassName_p;
            LOG.error((Object)msg);
            throw new OwObjectNotFoundException(msg);
        }
        return objectClassDescription;
    }

    public Map getObjectClassNames(int[] iTypes_p, boolean fExcludeHiddenAndNonInstantiable_p, boolean fRootOnly_p, OwResource resource_p) throws Exception {
        HashMap<String, String> retList = new HashMap<String, String>();
        boolean returnObjectTypeDocument = false;
        boolean returnObjectTypeFolder = false;
        if (iTypes_p == null) {
            returnObjectTypeDocument = true;
            returnObjectTypeFolder = true;
        } else {
            block4: for (int i = 0; i < iTypes_p.length; ++i) {
                switch (iTypes_p[i]) {
                    case 4097: {
                        returnObjectTypeDocument = true;
                        continue block4;
                    }
                    case 8193: {
                        returnObjectTypeFolder = true;
                    }
                }
            }
        }
        if (returnObjectTypeDocument) {
            retList.put(OwDummyFileObject.m_FileClassDescription.getClassName(), OwDummyFileObject.m_FileClassDescription.getDisplayName(this.getLocale()));
        }
        if (returnObjectTypeFolder) {
            retList.put(OwDummyFileObject.m_DirectoryClassDescription.getClassName(), OwDummyFileObject.m_DirectoryClassDescription.getDisplayName(this.getLocale()));
        }
        return retList;
    }

    public OwPropertyClass getUnsafePropertyClass(String strClassName_p, OwResource resource_p) throws Exception {
        HashMap ObjClassMap = this.getObjectClassMap();
        for (OwObjectClass ObjClass : ObjClassMap.values()) {
            try {
                OwPropertyClass PropClass = ObjClass.getPropertyClass(strClassName_p);
                if (PropClass == null) continue;
                return PropClass;
            }
            catch (OwObjectNotFoundException e) {
                LOG.debug((Object)("\t" + ObjClass.getClassName() + " - " + strClassName_p));
            }
        }
        String msg = "OwDummyNetwork.getUnsafePropertyClass: Class description not found, ClassName = " + strClassName_p;
        LOG.debug((Object)msg);
        throw new OwObjectNotFoundException(msg);
    }

    private OwSearchTemplate createSearchTemplate(OwObject obj_p) throws Exception {
        OwStandardSearchTemplate SearchTemplate = new OwStandardSearchTemplate(this.getContext(), obj_p);
        return SearchTemplate;
    }

    public OwResource getResource(String strID_p) throws Exception {
        return this.m_defaultResource;
    }

    public Iterator getResourceIDs() throws Exception {
        LinkedList<String> collection = new LinkedList<String>();
        collection.add(this.m_defaultResource.getID());
        return collection.iterator();
    }

    public OwObject getObjectFromPath(String strPath_p, boolean fRefresh_p) throws Exception {
        return OwDummyObjectFactory.getInstance().create(this, new File(this.m_Context.getBasePath() + "/WEB-INF/dummy/dummyarchiv" + strPath_p));
    }

    public boolean canDo(OwObject obj_p, int iFunctionCode_p, int iContext_p) throws Exception {
        return true;
    }

    public OwFieldDefinition getFieldDefinition(String strFieldDefinitionName_p, String strResourceName_p) throws Exception, OwObjectNotFoundException {
        return this.getUnsafePropertyClass(strFieldDefinitionName_p, this.getResource(strResourceName_p));
    }

    public String getDMSPrefix() {
        return DMS_PREFIX;
    }

    public void releaseResources() throws Exception {
    }

    protected void attributeBagSupportSetup() {
        this.m_bagsSupport = new OwTransientBagsSupport();
    }

    public Collection getWildCardDefinitions(String strFieldDefinitionName_p, String strResourceName_p, int iOp_p) throws Exception {
        switch (iOp_p) {
            case 6: 
            case 7: {
                if (this.m_likewildcarddefinitions == null) {
                    this.m_likewildcarddefinitions = new OwLikeWildCardDefinitions((OwRepositoryContext)this.getContext());
                }
                return this.m_likewildcarddefinitions.getDefinitions();
            }
        }
        return null;
    }

    public boolean canBatch() {
        return false;
    }

    public void closeBatch(OwBatch batch_p) throws OwInvalidOperationException {
        throw new OwInvalidOperationException("can not batch");
    }

    public OwBatch openBatch() throws OwInvalidOperationException {
        throw new OwInvalidOperationException("can not batch");
    }

    public OwObjectSkeleton createObjectSkeleton(OwObjectClass objectclass_p, OwResource resource_p) throws Exception {
        return new OwObjectSkeleton((OwNetwork)this, objectclass_p);
    }

    static {
        m_ObjectClassesMap.put(OwDummyFileObject.m_FileClassDescription.getClassName(), OwDummyFileObject.m_FileClassDescription);
        m_ObjectClassesMap.put(OwDummyFileObject.m_DirectoryClassDescription.getClassName(), OwDummyFileObject.m_DirectoryClassDescription);
        m_ObjectClassesMap.put(OwDummyObjectLinkClass.getDefaultInstance().getClassName(), OwDummyObjectLinkClass.getDefaultInstance());
        m_jndiPropertyNames = new HashMap();
        m_jndiPropertyNames.put("ProviderUrl", "java.naming.provider.url");
        m_jndiPropertyNames.put("factoryInitial", "java.naming.factory.initial");
        m_jndiPropertyNames.put("authenticationMode", "java.naming.security.authentication");
        m_jndiPropertyNames.put("ldapClientPrincipal", "java.naming.security.principal");
        m_jndiPropertyNames.put("ldapClientCredentials", "java.naming.security.credentials");
    }

    private static class OwLikeWildCardDefinitions {
        private Vector m_definitions = new Vector();

        public OwLikeWildCardDefinitions(OwRepositoryContext context_p) {
            this.m_definitions.add(new OwStandardWildCardDefinition("#", context_p.getClientWildCard(1), 1, new OwString1("ecmimpl.OwDummyNetwork.WILD_CARD_TYPE_MULTI_CHAR", "(%1) replaces any characters")));
            this.m_definitions.add(new OwStandardWildCardDefinition("~", context_p.getClientWildCard(2), 2, new OwString1("ecmimpl.OwDummyNetwork.WILD_CARD_TYPE_SINGLE_CHAR", "(%1) replaces any character.")));
        }

        public Collection getDefinitions() {
            return this.m_definitions;
        }
    }
}

