/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.owdummy;

import com.wewebu.ow.server.ecm.OwContentCollection;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectClass;
import com.wewebu.ow.server.ecm.OwObjectCollection;
import com.wewebu.ow.server.ecm.OwObjectLink;
import com.wewebu.ow.server.ecm.OwObjectLinkRelation;
import com.wewebu.ow.server.ecm.OwObjectReference;
import com.wewebu.ow.server.ecm.OwPermissionCollection;
import com.wewebu.ow.server.ecm.OwProperty;
import com.wewebu.ow.server.ecm.OwPropertyClass;
import com.wewebu.ow.server.ecm.OwPropertyCollection;
import com.wewebu.ow.server.ecm.OwResource;
import com.wewebu.ow.server.ecm.OwStandardObjectCollection;
import com.wewebu.ow.server.ecm.OwStandardProperty;
import com.wewebu.ow.server.ecm.OwStandardPropertyClass;
import com.wewebu.ow.server.ecm.OwStandardPropertyCollection;
import com.wewebu.ow.server.ecm.OwVersion;
import com.wewebu.ow.server.ecm.OwVersionSeries;
import com.wewebu.ow.server.ecm.OwVirtualLinkPropertyClasses;
import com.wewebu.ow.server.ecmimpl.owdummy.OwDummyObjectLinkClass;
import com.wewebu.ow.server.ecmimpl.owdummy.log.OwLog;
import com.wewebu.ow.server.exceptions.OwObjectNotFoundException;
import com.wewebu.ow.server.field.OwField;
import com.wewebu.ow.server.field.OwFieldDefinition;
import com.wewebu.ow.server.field.OwSearchNode;
import com.wewebu.ow.server.field.OwSearchTemplate;
import com.wewebu.ow.server.field.OwSort;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.log4j.Logger;

public class OwDummyObjectLink
implements OwObjectLink {
    private static final Logger LOG = OwLog.getLogger(OwDummyObjectLink.class);
    public static final String LINKS_PREFIX = "awl";
    private OwObjectClass linkClass;
    private Map<String, OwProperty> propertyMap;

    public OwDummyObjectLink(OwObject source, OwObject target) {
        this(OwDummyObjectLinkClass.getDefaultInstance().getClassName(), OwDummyObjectLinkClass.getDefaultInstance(), source, target);
    }

    public OwDummyObjectLink(String name, OwObject source, OwObject target) {
        this(name, OwDummyObjectLinkClass.getDefaultInstance(), source, target);
    }

    public OwDummyObjectLink(String name, OwObjectClass linkClass, OwObject source, OwObject target) {
        this.linkClass = linkClass;
        this.propertyMap = new HashMap<String, OwProperty>();
        OwStandardProperty nameProperty = new OwStandardProperty((Object)name, (OwPropertyClass)OwResource.m_ObjectNamePropertyClass);
        this.propertyMap.put(OwResource.m_ObjectNamePropertyClass.getClassName(), (OwProperty)nameProperty);
        OwStandardProperty sourceProperty = new OwStandardProperty((Object)source, (OwPropertyClass)OwVirtualLinkPropertyClasses.LINK_SOURCE);
        this.propertyMap.put(OwVirtualLinkPropertyClasses.LINK_SOURCE.getClassName(), (OwProperty)sourceProperty);
        OwStandardProperty targetProperty = new OwStandardProperty((Object)target, (OwPropertyClass)OwVirtualLinkPropertyClasses.LINK_TARGET);
        this.propertyMap.put(OwVirtualLinkPropertyClasses.LINK_TARGET.getClassName(), (OwProperty)targetProperty);
        OwStandardProperty classProperty = new OwStandardProperty((Object)linkClass, (OwPropertyClass)OwResource.m_ClassDescriptionPropertyClass);
        this.propertyMap.put(OwResource.m_ClassDescriptionPropertyClass.getClassName(), (OwProperty)classProperty);
    }

    public String getClassName() {
        return this.getObjectClass().getClassName();
    }

    public OwObjectClass getObjectClass() {
        return this.linkClass;
    }

    public OwObjectCollection getParents() throws Exception {
        OwStandardObjectCollection parents = new OwStandardObjectCollection();
        parents.add((Object)this.getSource());
        parents.add((Object)this.getTarget());
        return parents;
    }

    public OwObjectCollection getChilds(int[] iObjectTypes_p, Collection propertyNames_p, OwSort sort_p, int iMaxSize_p, int iVersionSelection_p, OwSearchNode filterCriteria_p) throws Exception {
        return null;
    }

    public boolean hasChilds(int[] iObjectTypes_p, int iContext_p) throws Exception {
        return false;
    }

    public int getChildCount(int[] iObjectTypes_p, int iContext_p) throws Exception {
        return 0;
    }

    public void changeClass(String strNewClassName_p, OwPropertyCollection properties_p, OwPermissionCollection permissions_p) throws Exception {
    }

    public boolean canChangeClass() throws Exception {
        return false;
    }

    public boolean canFilterChilds() throws Exception {
        return false;
    }

    public Collection<OwFieldDefinition> getFilterProperties(Collection propertynames_p) throws Exception {
        OwObjectClass myClass = this.getObjectClass();
        LinkedList filterNames = new LinkedList(myClass.getPropertyClassNames());
        filterNames.retainAll(propertynames_p);
        LinkedList<OwFieldDefinition> filteredFields = new LinkedList<OwFieldDefinition>();
        for (String name : filterNames) {
            filteredFields.add((OwFieldDefinition)myClass.getPropertyClass(name));
        }
        return filteredFields;
    }

    public OwVersionSeries getVersionSeries() throws Exception {
        return null;
    }

    public boolean hasVersionSeries() throws Exception {
        return false;
    }

    public OwVersion getVersion() throws Exception {
        return null;
    }

    public OwProperty getProperty(String strPropertyName_p) throws Exception {
        OwProperty property = this.propertyMap.get(strPropertyName_p);
        if (property == null) {
            String msg = "OwDummyObjectLink.getProperty: Cannot find the property, propertyName = " + strPropertyName_p;
            LOG.debug((Object)msg);
            throw new OwObjectNotFoundException(msg);
        }
        return property;
    }

    public OwPropertyCollection getProperties(Collection propertyNames_p) throws Exception {
        OwStandardPropertyCollection properties = new OwStandardPropertyCollection();
        if (propertyNames_p == null) {
            properties.putAll(this.propertyMap);
        } else {
            for (String name : propertyNames_p) {
                properties.put((Object)name, (Object)this.getProperty(name));
            }
        }
        return properties;
    }

    public OwPropertyCollection getClonedProperties(Collection propertyNames_p) throws Exception {
        return OwStandardPropertyClass.getClonedProperties((OwObject)this, (Collection)propertyNames_p);
    }

    public void setProperties(OwPropertyCollection properties_p) throws Exception {
        for (OwProperty propIn : properties_p.values()) {
            OwProperty prop = this.propertyMap.get(propIn.getPropertyClass().getClassName());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("OwDummyObjectLink.setProperties: Prop=[" + propIn.getPropertyClass().getClassName() + "], PrevValue=[" + prop.getValue() + "], NewValue=[" + propIn.getValue() + "]"));
            }
            prop.setValue(propIn.getValue());
        }
    }

    public void setProperties(OwPropertyCollection properties_p, Object mode_p) throws Exception {
        this.setProperties(properties_p);
    }

    public boolean canSetProperties(int iContext_p) throws Exception {
        return true;
    }

    public boolean canGetProperties(int iContext_p) throws Exception {
        return true;
    }

    public boolean canLock() throws Exception {
        return false;
    }

    public boolean setLock(boolean fLock_p) throws Exception {
        return false;
    }

    public boolean getLock(int iContext_p) throws Exception {
        return false;
    }

    public boolean getMyLock(int iContext_p) throws Exception {
        return false;
    }

    public String getLockUserID(int iContext_p) throws Exception {
        return null;
    }

    public void delete() throws Exception {
    }

    public boolean canDelete(int iContext_p) throws Exception {
        return false;
    }

    public void removeReference(OwObject oObject_p) throws Exception {
    }

    public boolean canRemoveReference(OwObject oObject_p, int iContext_p) throws Exception {
        return false;
    }

    public void add(OwObject oObject_p) throws Exception {
    }

    public boolean canAdd(OwObject oObject_p, int iContext_p) throws Exception {
        return false;
    }

    public void move(OwObject oObject_p, OwObject oldParent_p) throws Exception {
    }

    public boolean canMove(OwObject oObject_p, OwObject oldParent_p, int iContext_p) throws Exception {
        return false;
    }

    public OwSearchTemplate getSearchTemplate() throws Exception {
        return null;
    }

    public Collection getColumnInfoList() throws Exception {
        return null;
    }

    public OwResource getResource() throws Exception {
        return null;
    }

    public OwPermissionCollection getPermissions() throws Exception {
        return null;
    }

    public OwPermissionCollection getClonedPermissions() throws Exception {
        return null;
    }

    public boolean canGetPermissions() throws Exception {
        return false;
    }

    public boolean canSetPermissions() throws Exception {
        return false;
    }

    public void setPermissions(OwPermissionCollection permissions_p) throws Exception {
    }

    public OwContentCollection getContentCollection() throws Exception {
        return null;
    }

    public void setContentCollection(OwContentCollection content_p) throws Exception {
    }

    public boolean canSetContent(int iContentType_p, int iContext_p) throws Exception {
        return false;
    }

    public boolean canGetContent(int iContentType_p, int iContext_p) throws Exception {
        return false;
    }

    public void refreshProperties() throws Exception {
    }

    public void refreshProperties(Collection props_p) throws Exception {
    }

    public Object getNativeObject() throws Exception {
        return null;
    }

    public String getPath() throws Exception {
        return null;
    }

    public String getResourceID() throws Exception {
        return null;
    }

    public OwObject getInstance() throws Exception {
        return this;
    }

    public String getName() {
        try {
            return this.getProperty(OwResource.m_ObjectNamePropertyClass.getClassName()).getValue().toString();
        }
        catch (Exception e) {
            LOG.error((Object)"Could not retrieve link name.", (Throwable)e);
            return "N/A";
        }
    }

    public String getID() {
        return this.getClassName() + this.getSource().getID() + this.getSource().getID();
    }

    public int getType() {
        return this.getObjectClass().getType();
    }

    public String getDMSID() throws Exception {
        return "owdm,awl," + this.getClassName() + "," + this.getSource().getDMSID() + "," + this.getTarget().getDMSID();
    }

    public int getPageCount() throws Exception {
        return 0;
    }

    public String getMIMEType() throws Exception {
        return null;
    }

    public String getMIMEParameter() throws Exception {
        return null;
    }

    public boolean hasContent(int iContext_p) throws Exception {
        return false;
    }

    public OwField getField(String strFieldClassName_p) throws Exception, OwObjectNotFoundException {
        return this.getProperty(strFieldClassName_p);
    }

    public void setField(String sName_p, Object value_p) throws Exception, OwObjectNotFoundException {
        this.getProperty(sName_p).setValue(value_p);
    }

    public Object getSafeFieldValue(String sName_p, Object defaultvalue_p) {
        try {
            return this.getProperty(sName_p).getValue();
        }
        catch (Exception e) {
            return defaultvalue_p;
        }
    }

    public Collection getFields() throws Exception {
        return this.getProperties(null).values();
    }

    public int getFieldProviderType() {
        return 1;
    }

    public Object getFieldProviderSource() {
        return this;
    }

    public String getFieldProviderName() {
        return this.getName();
    }

    public OwObjectReference getTarget() {
        try {
            return (OwObjectReference)this.getProperty(OwVirtualLinkPropertyClasses.LINK_TARGET.getClassName()).getValue();
        }
        catch (Exception e) {
            LOG.error((Object)"Could not retrieve target.", (Throwable)e);
            return null;
        }
    }

    public OwObjectReference getSource() {
        try {
            return (OwObjectReference)this.getProperty(OwVirtualLinkPropertyClasses.LINK_SOURCE.getClassName()).getValue();
        }
        catch (Exception e) {
            LOG.error((Object)"Could not retrieve source.", (Throwable)e);
            return null;
        }
    }

    public OwObjectLinkRelation getRelation(OwObject obj) {
        if (obj != null) {
            try {
                String dmsid = obj.getDMSID();
                boolean inbound = dmsid.equals(this.getTarget().getDMSID());
                if (dmsid.equals(this.getSource().getDMSID())) {
                    return inbound ? OwObjectLinkRelation.BOTH : OwObjectLinkRelation.OUTBOUND;
                }
                if (inbound) {
                    return OwObjectLinkRelation.INBOUND;
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Invalid relation.", (Throwable)e);
            }
        }
        return OwObjectLinkRelation.NONE;
    }
}

