/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.ecmimpl.owdummy;

import com.wewebu.ow.server.conf.OwBaseUserInfo;
import com.wewebu.ow.server.ecmimpl.owdummy.log.OwLog;
import com.wewebu.ow.server.exceptions.OwConfigurationException;
import com.wewebu.ow.server.exceptions.OwException;
import com.wewebu.ow.server.exceptions.OwServerException;
import com.wewebu.ow.server.role.OwRoleManagerContext;
import com.wewebu.ow.server.roleimpl.simplerole.OwSimpleRoleManager;
import com.wewebu.ow.server.util.OwStandardXMLUtil;
import com.wewebu.ow.server.util.OwXMLDOMUtil;
import com.wewebu.ow.server.util.OwXMLUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.w3c.dom.Node;

public class OwDummyRoleManager
extends OwSimpleRoleManager {
    private static final Logger LOG = OwLog.getLogger(OwDummyRoleManager.class);
    private boolean m_fsupportMasterRoles = false;
    private Collection m_masterrolenames;
    private Collection m_filteredRoles;
    private String m_strMasterRole;

    public void init(OwRoleManagerContext mainContext_p, OwXMLUtil configNode_p) throws OwException {
        super.init(mainContext_p, configNode_p);
        try {
            this.m_fsupportMasterRoles = OwXMLDOMUtil.getSafeBooleanAttributeValue((Node)this.getConfigNode().getSubNode("MasterRoles"), (String)"enable", (boolean)false);
        }
        catch (Exception e) {
            throw new OwServerException("Could not create dummy role manager.", (Throwable)e);
        }
    }

    public void loginInit() throws Exception {
        super.loginInit();
        this.updateDesign();
    }

    public Collection getFilteredRoles() throws Exception {
        if (null == this.m_filteredRoles) {
            if (this.hasMasterRoles()) {
                Collection userroles = this.getRoles(this.getCurrentUser());
                HashSet allrolesdefinedbymaster = new HashSet();
                List masterroles = null;
                this.m_filteredRoles = new ArrayList();
                List mastergroupnodes = this.getConfigNode().getSafeNodeList("MasterRoles");
                Iterator it = mastergroupnodes.iterator();
                while (it.hasNext()) {
                    OwStandardXMLUtil mastergroupwrapper = new OwStandardXMLUtil((Node)it.next());
                    String strMasterRoleName = mastergroupwrapper.getSafeStringAttributeValue("name", null);
                    if (strMasterRoleName == null) {
                        String msg = "OwDummyRoleManager.getFilteredRoles: Define name in MasterRoleGroup.";
                        LOG.fatal((Object)msg);
                        throw new OwConfigurationException(msg);
                    }
                    List roles = mastergroupwrapper.getSafeStringList();
                    allrolesdefinedbymaster.addAll(roles);
                    if (!strMasterRoleName.equals(this.getMasterRole())) continue;
                    masterroles = roles;
                }
                if (masterroles == null) {
                    String msg = "OwDummyRoleManager.getFilteredRoles: Masterrole is not defined, name = " + this.getMasterRole();
                    LOG.fatal((Object)msg);
                    throw new OwConfigurationException(msg);
                }
                for (String strRole : userroles) {
                    if (!masterroles.contains(strRole) && allrolesdefinedbymaster.contains(strRole)) continue;
                    this.m_filteredRoles.add(strRole);
                }
            } else {
                this.m_filteredRoles = this.getRoles(this.getCurrentUser());
            }
        }
        return this.m_filteredRoles;
    }

    public boolean isAllowed(int iCategory_p, String strResourceID_p) throws Exception {
        Collection filteredmasterRoles = this.getFilteredRoles();
        switch (iCategory_p) {
            case 6: {
                if (strResourceID_p.equals("owcaneditsitesettings")) {
                    return filteredmasterRoles.contains("Guest");
                }
                return true;
            }
            case 1: {
                if (strResourceID_p.equals("com.wewebu.ow.Workdesk")) {
                    return true;
                }
                if (filteredmasterRoles.contains("Administrators")) {
                    if (strResourceID_p.equalsIgnoreCase("com.wewebu.ow.admin")) {
                        return true;
                    }
                    return strResourceID_p.equalsIgnoreCase("com.wewebu.ow.Help");
                }
                if (filteredmasterRoles.contains("Guest")) {
                    return !strResourceID_p.equalsIgnoreCase("com.wewebu.ow.admin");
                }
                if (filteredmasterRoles.contains("Application_A")) {
                    if (strResourceID_p.equalsIgnoreCase("com.wewebu.ow.admin")) {
                        return false;
                    }
                    if (strResourceID_p.startsWith("com.wewebu.ow.Record")) {
                        return false;
                    }
                    if (strResourceID_p.equalsIgnoreCase("com.wewebu.ow.owinterop.jspview")) {
                        return false;
                    }
                    if (strResourceID_p.equalsIgnoreCase("com.wewebu.ow.Demo")) {
                        return false;
                    }
                    return !strResourceID_p.equalsIgnoreCase("com.wewebu.ow.bpm");
                }
                if (filteredmasterRoles.contains("Application_B")) {
                    if (strResourceID_p.equalsIgnoreCase("com.wewebu.ow.admin")) {
                        return false;
                    }
                    if (strResourceID_p.equalsIgnoreCase("com.wewebu.ow.owinterop.jspview")) {
                        return false;
                    }
                    if (strResourceID_p.equalsIgnoreCase("com.wewebu.ow.Demo")) {
                        return false;
                    }
                    return !strResourceID_p.equalsIgnoreCase("com.wewebu.ow.bpm");
                }
            }
            case 8: {
                int lastPoint = strResourceID_p.lastIndexOf(46);
                if (lastPoint > -1) {
                    String optionId = strResourceID_p.substring(lastPoint);
                    if (optionId.equals(".B")) {
                        return filteredmasterRoles.contains("Application_B");
                    }
                    return false;
                }
                return false;
            }
        }
        return true;
    }

    public Collection getAllowedResources(int category_p) throws Exception {
        Collection allResources = this.getResources(category_p);
        ArrayList<String> allowedResources = new ArrayList<String>();
        for (String resourceName : allResources) {
            if (!this.isAllowed(category_p, resourceName)) continue;
            allowedResources.add(resourceName);
        }
        return allowedResources;
    }

    private Collection getRoles(OwBaseUserInfo userinfo_p) throws Exception {
        return userinfo_p.getRoleNames();
    }

    public Collection getMasterRoles() throws Exception {
        if (this.m_fsupportMasterRoles && this.m_masterrolenames == null) {
            Collection userroles = this.getRoles(this.getCurrentUser());
            this.m_masterrolenames = new ArrayList();
            List mastergroupnodes = this.getConfigNode().getSafeNodeList("MasterRoles");
            Iterator it = mastergroupnodes.iterator();
            while (it.hasNext()) {
                OwStandardXMLUtil mastergroupwrapper = new OwStandardXMLUtil((Node)it.next());
                String strMasterRoleName = mastergroupwrapper.getSafeStringAttributeValue("name", null);
                if (strMasterRoleName == null) {
                    String msg = "OwDummyRoleManager.getMasterRoles: Define name in MasterRoleGroup.";
                    LOG.fatal((Object)msg);
                    throw new OwConfigurationException(msg);
                }
                List roles = mastergroupwrapper.getSafeStringList();
                if (!userroles.containsAll(roles)) continue;
                this.m_masterrolenames.add(strMasterRoleName);
            }
        }
        return this.m_masterrolenames;
    }

    public String getMasterRoleDisplayName(Locale locale_p, String strRole_p) throws Exception {
        return strRole_p;
    }

    public String getMasterRole() throws Exception {
        Collection masterRoles;
        if (this.m_strMasterRole == null && (masterRoles = this.getMasterRoles()) != null && masterRoles.size() != 0) {
            this.m_strMasterRole = (String)masterRoles.iterator().next();
        }
        return this.m_strMasterRole;
    }

    protected void updateDesign() throws Exception {
        Collection filteredmasterRoles = this.getFilteredRoles();
        if (filteredmasterRoles.contains("Application_A")) {
            this.m_strDesign = "default41";
        }
        if (filteredmasterRoles.contains("Application_B")) {
            this.m_strDesign = "default41";
        }
    }

    public boolean setMasterRole(String strRole_p) throws Exception {
        if (this.m_fsupportMasterRoles && !strRole_p.equals(this.m_strMasterRole)) {
            if (this.getMasterRoles().contains(strRole_p)) {
                this.m_strMasterRole = strRole_p;
                this.m_filteredRoles = null;
                this.updateDesign();
                this.updateAllowedPlugins();
                return true;
            }
            LOG.error((Object)("OwDummyRoleManager.setMasterRole: Masterrole is not defined: " + strRole_p));
        }
        return false;
    }

    public boolean canExplicitDeny() {
        return true;
    }

    public boolean hasMasterRoles() {
        try {
            return this.m_fsupportMasterRoles && this.getMasterRoles().size() > 1;
        }
        catch (Exception e) {
            return false;
        }
    }
}

