/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly;

import com.sun.enterprise.web.connector.grizzly.Pipeline;
import com.sun.enterprise.web.connector.grizzly.SelectorThread;
import com.sun.enterprise.web.connector.grizzly.Task;
import com.sun.enterprise.web.connector.grizzly.WorkerThread;
import java.nio.ByteBuffer;
import java.util.logging.Level;

public class WorkerThreadImpl
extends Thread
implements WorkerThread {
    protected Runnable target;
    protected ByteBuffer byteBuffer;
    protected Pipeline pipeline;
    protected volatile boolean doTask = true;
    protected static final ThreadGroup threadGroup = new ThreadGroup("Grizzly");

    public WorkerThreadImpl(ThreadGroup threadGroup, Runnable runnable) {
        super(threadGroup, runnable);
        this.setDaemon(true);
        this.target = runnable;
    }

    public WorkerThreadImpl(Pipeline pipeline, String name) {
        super(threadGroup, name);
        this.pipeline = pipeline;
        this.setDaemon(true);
    }

    public void run() {
        if (this.target != null) {
            this.target.run();
            return;
        }
        while (this.doTask) {
            try {
                Task t = this.pipeline.getTask();
                if (t == null) continue;
                t.run();
                t = null;
            }
            catch (Throwable t) {
                if (this.byteBuffer != null) {
                    this.byteBuffer.clear();
                }
                SelectorThread.logger().log(Level.FINE, "workerThread.httpException", t);
            }
        }
    }

    public void terminate() {
        this.doTask = false;
    }

    public void setByteBuffer(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }
}

