/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationMap;

public final class ConfigurationConverter {
    private ConfigurationConverter() {
    }

    public static Configuration getConfiguration(ExtendedProperties eprops) {
        BaseConfiguration config = new BaseConfiguration();
        Iterator keys = eprops.getKeys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            config.setProperty(key, eprops.getProperty(key));
        }
        return config;
    }

    public static Configuration getConfiguration(Properties props) {
        BaseConfiguration config = new BaseConfiguration();
        Enumeration keys = ((Hashtable)props).keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            config.setProperty(key, props.getProperty(key));
        }
        return config;
    }

    public static ExtendedProperties getExtendedProperties(Configuration config) {
        ExtendedProperties props = new ExtendedProperties();
        Iterator keys = config.getKeys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Vector property = config.getProperty(key);
            if (property instanceof List) {
                property = new Vector(property);
            }
            props.setProperty(key, (Object)property);
        }
        return props;
    }

    public static Properties getProperties(Configuration config) {
        Properties props = new Properties();
        Iterator keys = config.getKeys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            List list = config.getList(key);
            StringBuffer property = new StringBuffer();
            Iterator it = list.iterator();
            while (it.hasNext()) {
                property.append(String.valueOf(it.next()));
                if (!it.hasNext()) continue;
                property.append(", ");
            }
            props.setProperty(key, property.toString());
        }
        return props;
    }

    public static Map getMap(Configuration config) {
        return new ConfigurationMap(config);
    }
}

