/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owdms;

import com.wewebu.ow.server.app.OwClientRefreshContext;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.app.OwStandardDialog;
import com.wewebu.ow.server.app.OwSubLayout;
import com.wewebu.ow.server.app.OwSubNavigationView;
import com.wewebu.ow.server.dmsdialogs.views.OwObjectClassView;
import com.wewebu.ow.server.dmsdialogs.views.OwObjectPropertyView;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectClass;
import com.wewebu.ow.server.ecm.OwVersionSeries;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.plug.owdms.OwChangeClassDialogDocument;
import com.wewebu.ow.server.plug.owdms.log.OwLog;
import com.wewebu.ow.server.ui.OwDialog;
import com.wewebu.ow.server.ui.OwEventTarget;
import com.wewebu.ow.server.ui.OwView;
import java.util.Collection;
import org.apache.log4j.Logger;

public class OwChangeClassDialog
extends OwStandardDialog
implements OwObjectClassView.OwObjectClassViewListner {
    private OwSubNavigationView m_SubNavigation;
    private OwSubLayout m_Layout;
    private OwObject m_object;
    private OwObjectClassView m_classView;
    private OwObjectPropertyView m_PropertyView;
    private OwChangeClassDialogDocument m_document;
    private OwClientRefreshContext m_refreshContext;
    private int m_indexClassView;
    private static final Logger LOG = OwLog.getLogger(OwChangeClassDialog.class);

    public OwChangeClassDialog(OwObject object_p, OwDialog.OwDialogListener dialogListener_p, OwClientRefreshContext refreshCtx_p) throws Exception {
        this.m_refreshContext = refreshCtx_p;
        this.setListener(dialogListener_p);
        this.m_Layout = new OwSubLayout();
        this.m_SubNavigation = new OwSubNavigationView();
        OwObject theObjectToChangeClass = object_p;
        if (object_p.hasVersionSeries()) {
            OwVersionSeries versSeries = object_p.getVersionSeries();
            theObjectToChangeClass = versSeries.getObject(versSeries.getLatest());
        }
        this.m_object = theObjectToChangeClass;
        this.m_document = new OwChangeClassDialogDocument(this.m_object);
        this.setDocument(this.m_document);
    }

    protected void init() throws Exception {
        super.init();
        this.m_document.attach(this.getContext(), null);
        this.addView((OwView)this.m_Layout, 2, null);
        this.m_Layout.addView((OwView)this.m_SubNavigation, 0, null);
        this.m_SubNavigation.setValidatePanels(true);
        this.m_Layout.addViewReference(this.m_SubNavigation.getViewReference(), 2);
        this.m_classView = new OwObjectClassView(this.m_object.getResource(), this.m_object.getType());
        this.m_indexClassView = this.m_SubNavigation.addView((OwView)this.m_classView, this.getContext().localize("owsavedialog.impl.OwSaveDlgDialog.class_title", "Select class"), null, this.getContext().getDesignURL() + "/images/plug/owdocprops/class.png", null, null);
        this.m_classView.navigateToClass(this.m_object.getObjectClass());
        this.m_classView.setSelectedItemStyle("OwSaveDlgObjectClassTextSelected");
        this.m_classView.setItemStyle("OwSaveDlgObjectClassText");
        this.m_classView.setEventListner((OwObjectClassView.OwObjectClassViewListner)this);
        this.m_PropertyView = new OwObjectPropertyView();
        this.m_PropertyView.setUpdateNoChanges(true);
        this.m_PropertyView.setInformUserOnSuccess(false);
        int iViewMask = 0;
        this.m_PropertyView.setViewMask(iViewMask);
        this.m_SubNavigation.addView((OwView)this.m_PropertyView, this.getContext().localize("owsavedialog.impl.OwSaveDlgDialog.properties_title", "Properties"), null, this.getContext().getDesignURL() + "/images/plug/owdocprops/properties.png", null, null);
        this.m_PropertyView.setObjectRef(this.m_object, false);
        this.m_classView.setNextActivateView((OwView)this.m_PropertyView);
        this.m_SubNavigation.navigate(this.m_indexClassView);
    }

    public void onObjectClassViewSelectClass(OwObjectClass classDescription_p, String strPath_p) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("OwChangeClassDialog.onObjectClassViewSelectClass: Selected class: " + classDescription_p.getClassName()));
        }
        this.m_document.updateObjectClass(classDescription_p);
    }

    public void onUpdate(OwEventTarget caller_p, int iCode_p, Object param_p) throws Exception {
        if (iCode_p == 5) {
            OwObject obj = this.m_document.getSkeletonObject();
            if (this.m_PropertyView != null) {
                this.m_PropertyView.setObjectRef(obj, false);
            }
        }
        switch (iCode_p) {
            case 15: 
            case 18: {
                this.performChangeClass(caller_p, iCode_p);
            }
        }
    }

    private void performChangeClass(OwEventTarget caller_p, int iCode_p) throws Exception, OwInvalidOperationException {
        Collection messages;
        if (caller_p instanceof OwObjectPropertyView) {
            try {
                this.m_document.changeClass();
                this.closeDialog();
                if (this.m_refreshContext != null) {
                    this.m_refreshContext.onClientRefreshContextUpdate(8, null);
                    this.m_refreshContext.onClientRefreshContextUpdate(14, null);
                    this.m_refreshContext.onClientRefreshContextUpdate(3, null);
                }
            }
            catch (OwInvalidOperationException e) {
                this.m_SubNavigation.navigate(this.m_indexClassView);
                throw e;
            }
        }
        if ((messages = ((OwMainAppContext)this.getContext()).getMessages()) != null) {
            messages.clear();
            ((OwMainAppContext)this.getContext()).postMessage(this.getContext().localize("app.OwObjectPropertyView.saved", "Changes have been saved."));
        }
    }

    public void detach() {
        super.detach();
        this.getDocument().detach();
    }
}

