/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owdms;

import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwObjectClass;
import com.wewebu.ow.server.ecm.OwObjectSkeleton;
import com.wewebu.ow.server.ecm.OwProperty;
import com.wewebu.ow.server.ecm.OwPropertyCollection;
import com.wewebu.ow.server.ecm.OwStandardPropertyCollection;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.plug.owdms.log.OwLog;
import com.wewebu.ow.server.ui.OwDocument;
import com.wewebu.ow.server.ui.OwEventTarget;
import com.wewebu.ow.server.util.OwString;
import java.util.Locale;
import org.apache.log4j.Logger;

public class OwChangeClassDialogDocument
extends OwDocument {
    private OwObject m_object;
    private OwObjectSkeleton m_skeleton;
    private static final Logger LOG = OwLog.getLogger(OwChangeClassDialogDocument.class);

    public OwChangeClassDialogDocument(OwObject object_p) throws Exception {
        this.m_object = object_p;
    }

    public void updateObjectClass(OwObjectClass objectClass_p) throws Exception {
        this.m_skeleton = this.createSkeletonObject(objectClass_p);
        if (this.m_object != null) {
            OwPropertyCollection templateProperties = this.m_object.getClonedProperties(null);
            OwPropertyCollection skeletonProperties = this.m_skeleton.getProperties(null);
            for (OwProperty skeletonProp : skeletonProperties.values()) {
                OwProperty templateProp;
                if (skeletonProp.getPropertyClass().isSystemProperty() || (templateProp = (OwProperty)templateProperties.get((Object)skeletonProp.getFieldDefinition().getClassName())) == null) continue;
                skeletonProp.setValue(templateProp.getValue());
            }
        }
        this.update((OwEventTarget)this, 5, null);
    }

    private OwObjectSkeleton createSkeletonObject(OwObjectClass objectClass_p) throws Exception {
        return ((OwMainAppContext)this.getContext()).getNetwork().createObjectSkeleton(objectClass_p, this.m_object.getResource());
    }

    public OwObject getSkeletonObject() {
        return this.m_skeleton;
    }

    public void changeClass() throws Exception {
        if (this.m_skeleton == null) {
            this.m_skeleton = this.createSkeletonObject(this.m_object.getObjectClass());
        }
        if (this.m_object.getObjectClass().getClassName().equals(this.m_skeleton.getObjectClass().getClassName())) {
            LOG.error((Object)"Please select another class name");
            throw new OwInvalidOperationException(OwString.localize((Locale)this.getContext().getLocale(), (String)"owdms.OwDocumentFunctionChangeClass.invalidSelection", (String)"The class you selected is the same with current object class. Please select another class name."));
        }
        try {
            OwPropertyCollection props = this.m_skeleton.getClonedProperties(null);
            OwStandardPropertyCollection newPropertyCollection = new OwStandardPropertyCollection();
            for (OwProperty prop : props.values()) {
                if (prop.isReadOnly(1) || prop.getPropertyClass().isSystemProperty() || prop.isHidden(1)) continue;
                newPropertyCollection.put((Object)prop.getPropertyClass().getClassName(), (Object)prop);
            }
            this.m_object.changeClass(this.m_skeleton.getClassName(), (OwPropertyCollection)newPropertyCollection, this.m_object.getPermissions());
        }
        catch (Exception e) {
            LOG.error((Object)"An error occurred on changing the document class.", (Throwable)e);
            throw new OwInvalidOperationException(this.getContext().localize("owdms.OwDocumentFunctionChangeClass.cannotChangeClass", "An error occurred on changing the document class."), (Throwable)e);
        }
    }
}

