/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owdms;

import com.wewebu.ow.server.app.OwClientRefreshContext;
import com.wewebu.ow.server.app.OwDocumentImportItem;
import com.wewebu.ow.server.app.OwDocumentImportItemContentCollection;
import com.wewebu.ow.server.ecm.OwContentCollection;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.ecm.OwPropertyCollection;
import com.wewebu.ow.server.plug.owdms.OwKeepContentDocumentImporter;
import com.wewebu.ow.server.plug.owdms.OwSaveDlgDialog;
import com.wewebu.ow.server.plug.owdms.OwSaveDlgDocument;
import com.wewebu.ow.server.ui.OwDialog;
import com.wewebu.ow.server.ui.OwNavigationView;
import com.wewebu.ow.server.util.OwHTMLHelper;
import java.io.IOException;
import java.util.List;

public class OwCheckInDialog
extends OwSaveDlgDialog
implements OwClientRefreshContext {
    protected static final int DIALOG_STATUS_NONE = 0;
    protected static final int DIALOG_STATUS_OK = 1;
    protected static final int DIALOG_STATUS_FAILED = 2;
    public static final int VIEW_MASK_CHECKIN_MODE_OPTION = 128;
    public static final int VIEW_MASK_RELEASE_VERSION_OPTION = 256;
    public static final int VIEW_MASK_RELEASE_VERSION_DEFAULT = 512;
    protected int m_dialogStatus = 0;
    private List m_propertyInfos;

    public OwCheckInDialog(OwObject saveObject_p, List documentImporters_p) throws Exception {
        super(saveObject_p.getResource(), false, documentImporters_p);
        this.getCurrentDocument().setObjectTemplate(saveObject_p);
    }

    public void setPropertiesInfo(List propertiesInfo_p) {
        this.m_propertyInfos = propertiesInfo_p;
    }

    public int getStatus() {
        return this.m_dialogStatus;
    }

    @Override
    protected void init() throws Exception {
        super.init();
        OwObject obj = this.getCurrentDocument().getObjectTemplate();
        if (this.hasViewMask(128)) {
            this.m_PropertyView.setCheckInOptions(obj.getObjectClass().getModes(2), this.hasViewMask(256));
        } else {
            this.m_PropertyView.setCheckInOptions(null, this.hasViewMask(256));
        }
        this.m_PropertyView.setObjectRefEx(obj, false, this.m_propertyInfos);
        boolean checkInAsMajorVersion = this.hasViewMask(512);
        this.m_PropertyView.setCheckInVersionMajor(checkInAsMajorVersion);
        this.getCurrentDocument().setObjectTemplate(obj);
        if (this.hasViewMask(32)) {
            this.m_classView.navigateToClass(obj.getObjectClass());
        } else {
            this.getCurrentDocument().setObjectClass(obj.getObjectClass());
        }
        this.m_PropertyView.setReadOnlyContext(2);
    }

    public String getTitle() {
        String strTitle = this.getContext().localize("owsavedialog.OwCheckInDialog.title", "Check in Document:");
        OwObject obj = this.getCurrentDocument().getObjectTemplate();
        try {
            strTitle = strTitle + OwHTMLHelper.encodeToSecureHTML((String)obj.getName());
        }
        catch (IOException ex) {
            strTitle = strTitle + obj.getName().replaceAll("[:<:]", "&#60;").replaceAll("[:>:]", "&#62;");
        }
        return strTitle;
    }

    public void onSaveDocument(OwContentCollection content_p, String strMimeType_p, String strMimeParameter_p, Object checkinMode_p, boolean fReleaseVersion_p) throws Exception {
        OwPropertyCollection docStandardPropertiesMap = this.getCurrentDocument().getSkeletonObject().getEditableProperties(2);
        String strClassName = this.getCurrentDocument().getSkeletonObject().getObjectClass().getClassName();
        try {
            this.getCurrentDocument().getObjectTemplate().getVersion().checkin(fReleaseVersion_p, checkinMode_p, strClassName, docStandardPropertiesMap, null, content_p, true, strMimeType_p, strMimeParameter_p);
        }
        catch (Exception e) {
            this.m_dialogStatus = 2;
            throw e;
        }
        this.m_dialogStatus = 1;
        if (this.m_RefreshCtx != null) {
            this.m_RefreshCtx.onClientRefreshContextUpdate(1, null);
        }
        this.closeDialog();
    }

    @Override
    protected void performSave() throws Exception {
        try {
            OwDocumentImportItem documentImportItem = ((OwSaveDlgDocument)this.getDocument()).getImportedDocument();
            if (documentImportItem == null) {
                throw new IllegalStateException("OwSaveDialog.performSave() has been invoked without an OwDocumentImportItem set at the OwSaveDlgDocument");
            }
            OwDocumentImportItemContentCollection contentCollection = new OwDocumentImportItemContentCollection(documentImportItem);
            OwPropertyCollection docStandardPropertiesMap = this.getCurrentDocument().getSkeletonObject().getEditableProperties(2);
            String strClassName = this.getCurrentDocument().getSkeletonObject().getObjectClass().getClassName();
            boolean releaseVersion = false;
            Object checkinModeObject = null;
            if (this.m_PropertyView != null) {
                releaseVersion = this.m_PropertyView.getReleaseVersion();
                checkinModeObject = this.m_PropertyView.getModeObject();
            }
            OwObject obj = this.getCurrentDocument().getObjectTemplate();
            obj.getVersion().checkin(releaseVersion, checkinModeObject, strClassName, docStandardPropertiesMap, null, (OwContentCollection)contentCollection, !(documentImportItem instanceof OwKeepContentDocumentImporter.OwKeepContentDocumentImporterItem), documentImportItem.getContentMimeType(0), documentImportItem.getContentMimeParameter(0));
            this.openPostProcessingView(this.getCurrentDocument().getDocumentImporter(), obj);
        }
        catch (Exception e) {
            this.m_dialogStatus = 2;
            throw e;
        }
        this.close();
    }

    public void onClientRefreshContextUpdate(int reason_p, Object param_p) throws Exception {
        if (this.m_RefreshCtx != null) {
            this.m_RefreshCtx.onClientRefreshContextUpdate(reason_p, param_p);
        }
    }

    @Override
    public int getDocumentImporterContext() {
        return 3;
    }

    @Override
    public void onDocumentImported() throws Exception {
        OwDocumentImportItem importedDoc = this.getCurrentDocument().getImportedDocument();
        if (this.m_indexPropertyView >= 0) {
            List modes = null;
            if (this.hasViewMask(128)) {
                modes = this.getCurrentDocument().getObjectTemplate().getObjectClass().getModes(2);
            }
            if (importedDoc != null && importedDoc.getCheckinAsMajor() != null) {
                this.m_PropertyView.setCheckInOptions(modes, false);
                this.m_PropertyView.setCheckInVersionMajor(importedDoc.getCheckinAsMajor());
            } else {
                this.m_PropertyView.setCheckInOptions(modes, this.hasViewMask(256));
                this.m_PropertyView.setCheckInVersionMajor(this.hasViewMask(512));
            }
            if (this.m_indexClassView >= 0) {
                if (this.getCurrentDocument().hasValidPredefinedObjectClass()) {
                    ((OwNavigationView.OwTabInfo)this.m_SubNavigation.getTabList().get(this.m_indexClassView)).setDisabled(true);
                    this.m_SubNavigation.navigate(this.m_indexPropertyView);
                } else {
                    ((OwNavigationView.OwTabInfo)this.m_SubNavigation.getTabList().get(this.m_indexClassView)).setDisabled(false);
                }
            }
        }
        super.onDocumentImported();
    }

    @Override
    protected void onPostProcessDialogClose(OwDialog dialog_p) throws Exception {
        this.close();
    }

    private void close() throws Exception {
        if (!this.isPostProcessDialogOpen()) {
            this.m_dialogStatus = 1;
            this.cleanup();
            this.closeDialog();
        }
    }
}

