/*
 * Decompiled with CFR 0.152.
 */
package com.wewebu.ow.server.plug.owdms;

import com.wewebu.ow.server.app.OwClientRefreshContext;
import com.wewebu.ow.server.app.OwDocumentFunction;
import com.wewebu.ow.server.app.OwMainAppContext;
import com.wewebu.ow.server.ecm.OwObject;
import com.wewebu.ow.server.exceptions.OwInvalidOperationException;
import com.wewebu.ow.server.plug.owdms.OwChangeClassDialog;
import com.wewebu.ow.server.plug.owdms.log.OwLog;
import com.wewebu.ow.server.ui.OwDialog;
import com.wewebu.ow.server.ui.OwEventTarget;
import com.wewebu.ow.server.util.OwXMLUtil;
import org.apache.log4j.Logger;

public class OwDocumentFunctionChangeClass
extends OwDocumentFunction
implements OwDialog.OwDialogListener {
    private static final Logger LOG = OwLog.getLogger(OwDocumentFunctionChangeClass.class);
    protected OwObject m_object;
    protected OwObject m_parentObject;

    public void init(OwXMLUtil node_p, OwMainAppContext context_p) throws Exception {
        super.init(node_p, context_p);
    }

    public String getIcon() throws Exception {
        return this.getContext().getDesignURL() + this.getConfigNode().getSafeTextValue("icon", "/images/plug/owdms/changeclass.png");
    }

    public String getBigIcon() throws Exception {
        return this.getContext().getDesignURL() + this.getConfigNode().getSafeTextValue("iconbig", "/images/plug/owdms/changeclass_24.png");
    }

    public boolean isEnabled(OwObject oObject_p, OwObject oParent_p, int iContext_p) throws Exception {
        return super.isEnabled(oObject_p, oParent_p, iContext_p) && oObject_p.canChangeClass();
    }

    public void onClickEvent(OwObject oObject_p, OwObject oParent_p, OwClientRefreshContext refreshCtx_p) throws Exception {
        if (!this.isEnabled(oObject_p, oParent_p, 2)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("OwDocumentFunctionChangeClass.onClickEvent: It is not possible to change the class of the document. DMSID = " + oObject_p != null ? oObject_p.getDMSID() : "<null>"));
            }
            throw new OwInvalidOperationException(this.getContext().localize("owdms.OwDocumentFunctionChangeClass.disabled", "It is not possible to change the class of the document."));
        }
        OwChangeClassDialog dlg = new OwChangeClassDialog(oObject_p, this, refreshCtx_p);
        this.m_object = oObject_p;
        this.m_parentObject = oParent_p;
        dlg.setHelp(this.getHelpPath());
        dlg.setTitle(this.getDefaultLabel());
        dlg.setInfoIcon(this.getBigIcon());
        this.getContext().openDialog((OwDialog)dlg, (OwDialog.OwDialogListener)this);
        this.addHistoryEvent(oObject_p, oParent_p, 2, 1);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("OwDocumentFunctionChangeClass.onClickEvent: Changing class for object: " + oObject_p.getName() + "initiated!"));
        }
    }

    public void onDialogClose(OwDialog dialogView_p) throws Exception {
    }

    public void onUpdate(OwEventTarget caller_p, int code_p, Object param_p) throws Exception {
        if (code_p == 15 && caller_p instanceof OwChangeClassDialog) {
            this.addHistoryEvent(this.m_object, this.m_parentObject, 3, 1);
        }
    }
}

